/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.element;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.Tuple2;

public class TailleCouleurTableModel
extends AbstractTableModel {
    private final List<SQLRow> tailles;
    private final List<SQLRow> couleurs;
    private final Boolean[][] selected;

    public TailleCouleurTableModel(ReferenceArticleSQLElement element) {
        SQLTable tTaille = element.getTable().getTable("ARTICLE_DECLINAISON_TAILLE");
        SQLSelect sTailles = new SQLSelect();
        sTailles.addSelect(tTaille.getKey());
        sTailles.addSelect(tTaille.getField("NOM"));
        sTailles.addFieldOrder(tTaille.getOrderField());
        this.tailles = new ArrayList<SQLRow>(SQLRowListRSH.execute(sTailles));
        SQLTable tCouleur = element.getTable().getTable("ARTICLE_DECLINAISON_COULEUR");
        SQLSelect sCouleurs = new SQLSelect();
        sCouleurs.addSelect(tCouleur.getKey());
        sCouleurs.addSelect(tCouleur.getField("NOM"));
        sCouleurs.addFieldOrder(tCouleur.getOrderField());
        this.couleurs = new ArrayList<SQLRow>(SQLRowListRSH.execute(sCouleurs));
        int size1 = this.tailles.size();
        int size2 = this.couleurs.size();
        this.selected = new Boolean[size1][size2];
        int i = 0;
        while (i < size1) {
            int j = 0;
            while (j < size2) {
                this.selected[i][j] = Boolean.FALSE;
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex > 0 && columnIndex > 0) {
            this.selected[columnIndex - 1][rowIndex] = (Boolean)aValue;
        }
    }

    @Override
    public int getRowCount() {
        return this.couleurs.size();
    }

    @Override
    public int getColumnCount() {
        return this.tailles.size() + 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "Couleurs / Tailles";
        }
        return this.tailles.get(columnIndex - 1).getString("NOM");
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return String.class;
        }
        return Boolean.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.couleurs.get(rowIndex).getString("NOM");
        }
        return this.selected[columnIndex - 1][rowIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    public List<Tuple2<SQLRow, SQLRow>> getSelected() {
        ArrayList<Tuple2<SQLRow, SQLRow>> r = new ArrayList<Tuple2<SQLRow, SQLRow>>();
        int size1 = this.tailles.size();
        int size2 = this.couleurs.size();
        int i = 0;
        while (i < size1) {
            int j = 0;
            while (j < size2) {
                if (this.selected[i][j].equals(Boolean.TRUE)) {
                    r.add(new Tuple2<SQLRow, SQLRow>(this.tailles.get(i), this.couleurs.get(j)));
                }
                ++j;
            }
            ++i;
        }
        return r;
    }
}

