/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.pos.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openconcerto.erp.core.sales.pos.model.Article;
import org.openconcerto.erp.core.sales.pos.model.Categorie;
import org.openconcerto.erp.core.sales.pos.ui.ArticleSelector;
import org.openconcerto.erp.core.sales.pos.ui.CaisseControler;
import org.openconcerto.erp.core.sales.pos.ui.CaisseListener;
import org.openconcerto.erp.core.sales.pos.ui.CaissePanel;
import org.openconcerto.erp.core.sales.pos.ui.FilteredListModel;
import org.openconcerto.erp.core.sales.pos.ui.POSButton;
import org.openconcerto.erp.core.sales.pos.ui.StatusBar;
import org.openconcerto.ui.touch.ScrollableList;

public class ArticleSearchPanel
extends JPanel
implements CaisseListener {
    private final ScrollableList list;
    private final CaisseControler controler;
    private final JTextField textField = new JTextField();
    private Map<Categorie, String> categoryCache = new HashMap<Categorie, String>();

    public ArticleSearchPanel(final CaisseControler controler) {
        Font f2;
        Font f1;
        this.controler = controler;
        this.controler.addCaisseListener(this);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        final FilteredListModel model = new FilteredListModel();
        if (this.controler.getPOSConf().getScreenWidth() < 1280) {
            f1 = new Font("Arial", 0, 21);
            f2 = new Font("Arial", 0, 14);
        } else {
            f1 = new Font("Arial", 0, 24);
            f2 = new Font("Arial", 0, 16);
        }
        this.setBackground(new Color(230, 230, 230));
        this.list = new ScrollableList(model){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.setColor(Color.LIGHT_GRAY);
                g.drawLine(0, 0, 0, this.getHeight());
            }

            @Override
            public void paintCell(Graphics g, Object object, int index, boolean isSelected, int posY) {
                if (object instanceof Article) {
                    Article article = (Article)object;
                    ArticleSelector.paintArticle(f1, g, article, isSelected, posY, this.getWidth(), this.getCellHeight(), 36, 10);
                    if (Categorie.getFavoriteProducts().contains(article)) {
                        g.setColor(Color.ORANGE);
                        g.fillRect(0, posY, 6, this.getCellHeight());
                    }
                } else if (object instanceof Categorie) {
                    Categorie c = (Categorie)object;
                    ArticleSearchPanel.this.paintCategorie(f1, f2, g, c, isSelected, posY, this.getWidth(), this.getCellHeight());
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if ((event.getModifiers() & 2) == 2) {
                    Object obj = this.getSelectedValue();
                    if (obj instanceof Article) {
                        Article product = (Article)obj;
                        Categorie.toggleFavoriteState(product);
                        controler.saveFavoriteProductsIds(Categorie.getFavoriteProducts());
                        model.setFilter(ArticleSearchPanel.this.textField.getText());
                        ArticleSearchPanel.this.list.scrollToOffset(0L);
                    }
                } else {
                    super.mouseReleased(event);
                }
            }
        };
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        StatusBar bar = new StatusBar();
        POSButton bSwitch = new POSButton("-");
        bSwitch.setForeground(Color.WHITE);
        bSwitch.setBackground(CaissePanel.DARK_BLUE);
        bar.setLayout(new FlowLayout(0));
        bar.add(bSwitch);
        bSwitch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                controler.switchListMode();
            }
        });
        bar.setTitle("Articles");
        bar.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                ArticleSearchPanel.this.list.scrollToOffset(0L);
            }
        });
        c.fill = 1;
        c.gridwidth = 2;
        this.add((Component)bar, c);
        c.weighty = 1.0;
        ++c.gridy;
        this.list.setBackground(new Color(240, 240, 240));
        this.add((Component)this.list, c);
        c.weighty = 0.0;
        JPanel pBottom = new JPanel();
        pBottom.setOpaque(true);
        pBottom.setBackground(CaissePanel.DARK_BLUE);
        pBottom.setLayout(new BorderLayout(3, 3));
        JLabel label = new JLabel(new ImageIcon(this.getClass().getResource("search.png")));
        pBottom.add((Component)label, "West");
        pBottom.setBorder(BorderFactory.createLineBorder(CaissePanel.DARK_BLUE, 3));
        this.textField.setBorder(BorderFactory.createLineBorder(CaissePanel.DARK_BLUE, 1));
        this.textField.setFont(f1);
        this.textField.setFont(f1);
        pBottom.add((Component)this.textField, "Center");
        ++c.gridy;
        c.weightx = 1.0;
        c.gridwidth = 2;
        this.add((Component)pBottom, c);
        this.textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                model.setFilter(ArticleSearchPanel.this.textField.getText());
                controler.setArticleSelected(null);
            }
        });
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object sel = ArticleSearchPanel.this.list.getSelectedValue();
                if (sel != null && !e.getValueIsAdjusting() && sel instanceof Article) {
                    Article article = (Article)sel;
                    controler.setArticleSelected(article);
                }
            }
        });
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object sel = ArticleSearchPanel.this.list.getSelectedValue();
                if (sel != null) {
                    int nb = e.getClickCount();
                    if (nb == 1) {
                        if (sel instanceof Article) {
                            Article article = (Article)sel;
                            controler.setArticleSelected(article);
                            controler.addArticle(article);
                        }
                    } else if (nb > 1) {
                        Article article = (Article)sel;
                        controler.incrementArticle(article);
                        controler.setArticleSelected(article);
                    }
                }
            }
        });
    }

    public void paintCategorie(Font f, Font f2, Graphics g, Categorie c, boolean isSelected, int posY, int cellWidth, int cellHeight) {
        String label2;
        g.setFont(f);
        g.setColor(Color.WHITE);
        g.fillRect(0, posY, cellWidth, cellHeight);
        g.setColor(Color.GRAY);
        g.drawLine(0, posY + cellHeight - 1, cellWidth, posY + cellHeight - 1);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String label = c.getName();
        int MAX_WIDTH = 36;
        int MAX_WIDTH2 = 48;
        if (label.length() > 72) {
            label = String.valueOf(label.substring(0, 72)) + "...";
        }
        if ((label2 = this.getCategoriePath(c)) != null && label2.length() > 48) {
            label2 = String.valueOf(label2.substring(0, 48)) + "...";
        }
        g.setColor(Color.BLACK);
        if (label2 == null) {
            g.drawString(label, 10, posY + 39);
        } else {
            g.drawString(label, 10, posY + 26);
            g.setColor(Color.DARK_GRAY);
            g.setFont(f2);
            g.drawString(label2, 10, posY + 52);
        }
    }

    private String getCategoriePath(Categorie c) {
        if (c.getParent() == null) {
            return null;
        }
        String storedString = this.categoryCache.get(c);
        if (storedString != null) {
            return storedString;
        }
        Categorie parent = c.getParent();
        String s = "";
        HashSet<Categorie> set = new HashSet<Categorie>();
        set.add(c);
        while (parent != null) {
            if (set.contains(parent)) {
                System.err.println("ArticleSearchPanel.getCategoriePath() loop detected for category " + c + " " + parent + " already in " + set);
                break;
            }
            set.add(parent);
            s = s.length() > 0 ? String.valueOf(parent.getName()) + " / " + s : parent.getName();
            parent = c.getParent();
        }
        this.categoryCache.put(c, s);
        return s;
    }

    @Override
    public void caisseStateChanged() {
        boolean found;
        Article articleSelected = this.controler.getArticleSelected();
        System.err.println("ArticleSearchPanel.caisseStateChanged() article selected : " + articleSelected);
        if (articleSelected == null) {
            this.list.clearSelection();
            return;
        }
        Object selectedValue = null;
        try {
            selectedValue = this.list.getSelectedValue();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!(selectedValue != null && articleSelected.equals(selectedValue) || (found = this.list.setSelectedValue(articleSelected, true)))) {
            this.list.clearSelection();
        }
    }
}

