/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import org.openconcerto.erp.action.CreateFrameAbstractAction;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.payment.element.SDDMessageSQLElement;
import org.openconcerto.erp.core.sales.invoice.element.EcheanceClientSQLElement;
import org.openconcerto.erp.generationEcritures.GenerationMvtSepa;
import org.openconcerto.erp.utils.TM;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.model.graph.Path;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.ListeAddPanel;
import org.openconcerto.sql.view.list.BaseSQLTableModelColumn;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.sql.view.list.SQLTableModelSourceOnline;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.i18n.Grammar_fr;

public class ListeEcheancePrelevementAction
extends CreateFrameAbstractAction {
    private final EcheanceClientSQLElement elem;
    private final ComptaPropsConfiguration conf;

    public ListeEcheancePrelevementAction(ComptaPropsConfiguration conf) {
        this.elem = conf.getDirectory().getElement(EcheanceClientSQLElement.class);
        this.conf = conf;
    }

    public final EcheanceClientSQLElement getElem() {
        return this.elem;
    }

    private void setWhere(SQLTableModelSourceOnline tableSource, boolean showHistory) {
        SQLTable tableEcheance = this.elem.getTable();
        Where w = new Where((FieldRef)tableEcheance.getField("ID_SEPA_MANDATE"), "!=", (Object)null);
        if (!showHistory) {
            w = w.and(new Where((FieldRef)tableEcheance.getField("REGLE"), "=", (Object)Boolean.FALSE));
            w = w.and(new Where((FieldRef)tableEcheance.getField("REG_COMPTA"), "=", (Object)Boolean.FALSE));
        }
        tableSource.getReq().setWhere(w);
    }

    @Override
    public JFrame createFrame() {
        final SQLTableModelSourceOnline tableSource = this.elem.getTableSource(true);
        this.setWhere(tableSource, false);
        final TM tm = this.conf.getERP_TM();
        tableSource.getColumns().add(new BaseSQLTableModelColumn("Etat", String.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                if (r.getBoolean("REGLE").booleanValue()) {
                    return TM.tr("sepa.deadline.done", new Object[0]);
                }
                if (r.getBoolean("REG_COMPTA").booleanValue()) {
                    return TM.tr("sepa.deadline.regul", new Object[0]);
                }
                if (!r.isForeignEmpty("ID_SDD_MESSAGE")) {
                    return TM.tr("sepa.deadline.filecreated", new Object[0]);
                }
                return TM.tr("sepa.deadline.waiting", new Object[0]);
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(ListeEcheancePrelevementAction.this.elem.getTable());
                return CollectionUtils.createSet(new FieldPath(p, "REGLE"), new FieldPath(p, "REG_COMPTA"), new FieldPath(p, "ID_SDD_MESSAGE"));
            }
        });
        tableSource.getColumns().add(new BaseSQLTableModelColumn("Fichier SEPA", String.class){

            @Override
            protected Object show_(SQLRowAccessor r) {
                if (r.isForeignEmpty("ID_SDD_MESSAGE")) {
                    return "";
                }
                return r.getForeign("ID_SDD_MESSAGE").getString("MessageIdentification");
            }

            @Override
            public Set<FieldPath> getPaths() {
                Path p = new Path(ListeEcheancePrelevementAction.this.elem.getTable());
                p = (Path)p.add(ListeEcheancePrelevementAction.this.elem.getTable().getField("ID_SDD_MESSAGE"));
                return CollectionUtils.createSet(new FieldPath(p, "MessageIdentification"));
            }
        });
        ListeAddPanel panel = new ListeAddPanel(this.elem, new IListe(tableSource));
        IListFrame res = new IListFrame(panel);
        res.setTextTitle("Pr\u00e9l\u00e8vements SEPA");
        res.getPanel().setReadWriteButtonsVisible(false);
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridy += 2;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        final JCheckBox checkboxHistory = new JCheckBox(TM.tr("sepa.history.hide", new Object[0]));
        checkboxHistory.setSelected(true);
        checkboxHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeEcheancePrelevementAction.this.setWhere(tableSource, !checkboxHistory.isSelected());
            }
        });
        res.getPanel().add((Component)checkboxHistory, c);
        final SDDMessageSQLElement sepaMsgElem = this.elem.getDirectory().getElement(SDDMessageSQLElement.class);
        final String aMessageLabel = this.elem.getForeignElement("ID_SDD_MESSAGE").getName().getVariant(Grammar_fr.INDEFINITE_ARTICLE_SINGULAR);
        RowAction.PredicateRowAction actionFileCreate = new RowAction.PredicateRowAction((Action)new AbstractAction("G\u00e9n\u00e9rer " + aMessageLabel, null){

            @Override
            public void actionPerformed(ActionEvent e) {
                final IListe l = IListe.get(e);
                final ArrayList<Integer> selectedIDs = new ArrayList<Integer>();
                final HashSet<Integer> selectedClientIDs = new HashSet<Integer>();
                for (SQLRowValues rowVals : l.getSelectedRows()) {
                    selectedClientIDs.add(rowVals.getForeignID("ID_CLIENT"));
                    if (rowVals.getLong("MONTANT") <= 0L) continue;
                    selectedIDs.add(rowVals.getID());
                }
                new SwingWorker<String, Void>(){

                    @Override
                    protected String doInBackground() throws Exception {
                        return ListeEcheancePrelevementAction.this.checkSEPA(selectedClientIDs);
                    }

                    @Override
                    protected void done() {
                        try {
                            String msg = (String)this.get();
                            if (msg.trim().length() > 0) {
                                msg = "Des informations n\u00e9cessaires \u00e0 la cr\u00e9ation du fichier sont manquantes : \n" + msg;
                                msg = String.valueOf(msg) + "Le fichier ne pourra \u00eatre cr\u00e9er tant que ces informations n'auront pas \u00e9t\u00e9 renseign\u00e9es.";
                                JOptionPane.showMessageDialog(null, msg, "Cr\u00e9ation du fichier SEPA annul\u00e9e", 2);
                                return;
                            }
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle(l, "Impossible de g\u00e9n\u00e9rer " + aMessageLabel, e);
                            return;
                        }
                        new SwingWorker<SDDMessageSQLElement.GenerationResult, Void>(){

                            @Override
                            protected SDDMessageSQLElement.GenerationResult doInBackground() throws Exception {
                                return sepaMsgElem.generateXML(ListeEcheancePrelevementAction.this.elem.getTable(), selectedIDs);
                            }

                            @Override
                            protected void done() {
                                SDDMessageSQLElement.GenerationResult genRes;
                                try {
                                    genRes = (SDDMessageSQLElement.GenerationResult)this.get();
                                }
                                catch (Exception e) {
                                    ExceptionHandler.handle(l, "Impossible de g\u00e9n\u00e9rer " + aMessageLabel, e);
                                    return;
                                }
                                int includedInvoicesCount = genRes.getIncludedInvoicesCount();
                                HashMap<String, Object> tmMap = new HashMap<String, Object>();
                                tmMap.put("msgElem", sepaMsgElem.getName());
                                tmMap.put("invoiceElem", ListeEcheancePrelevementAction.this.elem.getName());
                                tmMap.put("invoiceElemCount", includedInvoicesCount);
                                if (genRes.getDDInvoicesWithoutMessage().isEmpty()) {
                                    JOptionPane.showMessageDialog(l, tm.trM("sddMessage.generation.noneNeeded", tmMap));
                                } else if (genRes.getIgnoredInvoices().isEmpty()) {
                                    JOptionPane.showMessageDialog(l, tm.trM("sddMessage.generation.noneIgnored", tmMap));
                                } else {
                                    int futureCount = ((List)genRes.getIgnoredInvoices().getNonNull(SDDMessageSQLElement.IgnoreReason.TOO_FAR_IN_FUTURE)).size();
                                    int duplicateCount = ((List)genRes.getIgnoredInvoices().getNonNull(SDDMessageSQLElement.IgnoreReason.DUPLICATE_MANDATE)).size();
                                    int missingInfoCount = ((List)genRes.getIgnoredInvoices().getNonNull(SDDMessageSQLElement.IgnoreReason.MISSING_INFO)).size();
                                    tmMap.put("futureCount", futureCount);
                                    tmMap.put("duplicateCount", duplicateCount);
                                    tmMap.put("missingInfoCount", missingInfoCount);
                                    StringBuilder msg = new StringBuilder(256);
                                    msg.append(tm.trM("sddMessage.generation.someIgnored", tmMap));
                                    if (futureCount > 0) {
                                        msg.append("\n- ");
                                        msg.append(tm.trM("sddMessage.generation.someIgnored.future", tmMap));
                                    }
                                    if (duplicateCount > 0) {
                                        msg.append("\n- ");
                                        msg.append(tm.trM("sddMessage.generation.someIgnored.duplicateMandate", tmMap));
                                    }
                                    if (missingInfoCount > 0) {
                                        msg.append("\n- ");
                                        msg.append(tm.trM("sddMessage.generation.someIgnored.missingInfo", tmMap));
                                    }
                                    int messageType = duplicateCount == 0 ? 2 : 0;
                                    JOptionPane.showMessageDialog(l, msg.toString(), null, messageType);
                                }
                                if (genRes.getInsertedMessage() != null) {
                                    sepaMsgElem.exportXML(l, Collections.singletonList(genRes.getInsertedMessage()));
                                }
                            }
                        }.execute();
                    }
                }.execute();
            }
        }, true, true).setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        RowAction.PredicateRowAction actionSepaAgain = new RowAction.PredicateRowAction((Action)new AbstractAction("Pr\u00e9lever \u00e0 nouveau", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                final IListe l = IListe.get(e);
                if (JOptionPane.showConfirmDialog(l, "Voulez-vous vraiment pr\u00e9lever \u00e0 nouveau les factures s\u00e9lectionn\u00e9es ? Cette action est d\u00e9finitive.", "Pr\u00e9lever \u00e0 nouveau", 2, 2) != 0) {
                    return;
                }
                final List<Integer> selectedIDs = l.getSelection().getSelectedIDs();
                final SQLTable table = l.getSource().getPrimaryTable();
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        UpdateBuilder upd = new UpdateBuilder(table);
                        upd.setObject("ID_SDD_MESSAGE", (Object)upd.getTable().getForeignTable("ID_SDD_MESSAGE").getUndefinedIDNumber());
                        upd.setObject("SDD_EndToEndId", (Object)"");
                        upd.setWhere(new Where(upd.getTable().getKey(), selectedIDs).and(new Where((FieldRef)upd.getTable().getField("REGLE"), "=", (Object)Boolean.FALSE)).and(new Where((FieldRef)upd.getTable().getField("REG_COMPTA"), "=", (Object)Boolean.FALSE)));
                        upd.getTable().getDBSystemRoot().getDataSource().execute(upd.asString());
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                            SQLTable table2 = l.getSource().getPrimaryTable().getTable();
                            List<String> modifiedFields = Arrays.asList("ID_SDD_MESSAGE", "SDD_EndToEndId");
                            for (Integer id : selectedIDs) {
                                table2.fireTableModified(id, modifiedFields);
                            }
                        }
                        catch (InterruptedException | ExecutionException e) {
                            e.printStackTrace();
                        }
                    }
                }.execute();
            }
        }, false, true).setPredicate(IListeAction.IListeEvent.getNonEmptySelectionPredicate());
        panel.getListe().addIListeAction(actionFileCreate);
        panel.getListe().addIListeAction(actionSepaAgain);
        RowAction actionCompta = new RowAction(new AbstractAction("Valider le paiement", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                IListe l = IListe.get(e);
                if (JOptionPane.showConfirmDialog(l, "Voulez-vous vraiment transf\u00e9rer ces pr\u00e9l\u00e8vements en comptabilit\u00e9 ?", "Comptabiliser", 2, 2) != 0) {
                    return;
                }
                final ArrayList<SQLRow> rows = new ArrayList<SQLRow>();
                final ArrayList<Integer> ids = new ArrayList<Integer>();
                for (SQLRowAccessor sQLRowAccessor : l.getSelectedRows()) {
                    rows.add(sQLRowAccessor.asRow());
                    ids.add(sQLRowAccessor.getID());
                }
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        try {
                            GenerationMvtSepa sepa = new GenerationMvtSepa(rows);
                            sepa.genere();
                            UpdateBuilder build = new UpdateBuilder(ListeEcheancePrelevementAction.this.elem.getTable());
                            build.setObject(ListeEcheancePrelevementAction.this.elem.getTable().getField("REGLE"), (Object)Boolean.TRUE);
                            build.setWhere(new Where(ListeEcheancePrelevementAction.this.elem.getTable().getKey(), ids));
                            ListeEcheancePrelevementAction.this.elem.getTable().getDBSystemRoot().getDataSource().execute(build.asString());
                        }
                        catch (Exception e) {
                            ExceptionHandler.handle("Erreur lors du transfert en comptabilit\u00e9", e);
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                            for (Integer id : ids) {
                                ListeEcheancePrelevementAction.this.elem.getTable().fireTableModified(id, Arrays.asList("REGLE"));
                            }
                        }
                        catch (InterruptedException | ExecutionException e) {
                            e.printStackTrace();
                        }
                    }
                }.execute();
            }
        }, true, true){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection != null && selection.size() >= 1) {
                    for (SQLRowValues sqlRowValues : selection) {
                        if (!sqlRowValues.getBoolean("REGLE").booleanValue()) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        panel.getListe().addIListeAction(actionCompta);
        RowAction.PredicateRowAction actionHistoSEPA = new RowAction.PredicateRowAction((Action)new AbstractAction("Historique Fichiers SEPA", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                IListFrame res = new IListFrame(new ListeAddPanel(ListeEcheancePrelevementAction.this.elem.getDirectory().getElement(SDDMessageSQLElement.class)));
                res.getPanel().setReadWriteButtonsVisible(false);
                FrameUtil.showPacked(res);
            }
        }, true, true).setPredicate(IListeAction.IListeEvent.createSelectionCountPredicate(0, Integer.MAX_VALUE));
        panel.getListe().addIListeAction(actionHistoSEPA);
        RowAction.PredicateRowAction actionRelancer = new RowAction.PredicateRowAction((Action)new AbstractAction("Relancer", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                ListeEcheancePrelevementAction.this.elem.relanceClient(IListe.get(e).getSelectedRow().asRow());
            }
        }, true, true).setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        panel.getListe().addIListeAction(actionRelancer);
        RowAction actionCancelPaiement = new RowAction(new AbstractAction("Annuler la validation", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                final IListe l = IListe.get(e);
                if (JOptionPane.showConfirmDialog(l, "Voulez-vous vraiment annuler le transfert de ce pr\u00e9l\u00e8vement en comptabilit\u00e9 ?", "Comptabiliser", 2, 2) != 0) {
                    return;
                }
                final SQLRowValues selectedRow = IListe.get(e).getSelectedRow();
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        Collection res = selectedRow.asRow().getForeign("ID_MOUVEMENT").getReferentRows(ListeEcheancePrelevementAction.this.elem.getTable().getTable("ENCAISSER_MONTANT_ELEMENT").getField("ID_MOUVEMENT_ECHEANCE"));
                        if (res.size() >= 1) {
                            try {
                                ListeEcheancePrelevementAction.this.elem.getDirectory().getElement("MOUVEMENT").archive(((SQLRowAccessor)res.iterator().next()).getForeign("ID_ENCAISSER_MONTANT").getForeignID("ID_MOUVEMENT"));
                                UpdateBuilder build = new UpdateBuilder(ListeEcheancePrelevementAction.this.elem.getTable());
                                build.setObject(ListeEcheancePrelevementAction.this.elem.getTable().getField("REGLE"), (Object)Boolean.FALSE);
                                build.setWhere(new Where((FieldRef)ListeEcheancePrelevementAction.this.elem.getTable().getKey(), "=", l.getSelectedId()));
                                ListeEcheancePrelevementAction.this.elem.getTable().getDBSystemRoot().getDataSource().execute(build.asString());
                            }
                            catch (SQLException e1) {
                                e1.printStackTrace();
                            }
                        }
                        return null;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                            ListeEcheancePrelevementAction.this.elem.getTable().fireTableModified(l.getSelectedId(), Arrays.asList("REGLE"));
                        }
                        catch (InterruptedException | ExecutionException e) {
                            e.printStackTrace();
                        }
                    }
                }.execute();
            }
        }, false, true){

            @Override
            public boolean enabledFor(List<SQLRowValues> selection) {
                if (selection != null && selection.size() == 1) {
                    return selection.get(0).getBoolean("REGLE");
                }
                return false;
            }
        };
        panel.getListe().addIListeAction(actionCancelPaiement);
        return res;
    }

    private String checkSEPA(Set<Integer> selectedClientIDs) {
        StringBuilder msg = new StringBuilder();
        SQLRow rowSociete = this.conf.getRowSociete();
        if (rowSociete.getString("IBAN").trim().length() == 0) {
            msg.append("IBAN non renseign\u00e9 dans les informations de la soci\u00e9t\u00e9.\n");
        }
        if (rowSociete.getString("BIC").trim().length() == 0) {
            msg.append("BIC non renseign\u00e9 dans les informations de la soci\u00e9t\u00e9.\n");
        }
        if (rowSociete.getString("SEPA_CREDITOR_ID").trim().length() == 0) {
            msg.append("Idenfiant de cr\u00e9ancier non renseign\u00e9 dans les informations de la soci\u00e9t\u00e9.\n");
        }
        if (msg.length() == 0) {
            SQLRowValues rowVals = new SQLRowValues(this.elem.getTable().getForeignTable("ID_CLIENT"));
            rowVals.putNulls("CODE", "NOM", "IBAN", "BIC");
            SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowVals);
            List<SQLRowValues> res = fetcher.fetch(new Where(rowVals.getTable().getKey(), selectedClientIDs));
            for (SQLRowValues r : res) {
                int ibanLength = r.getString("IBAN").trim().length();
                int bicLength = r.getString("BIC").trim().length();
                if (ibanLength == 0 && bicLength == 0) {
                    msg.append("IBAN et BIC non renseign\u00e9s pour le client " + r.getString("NOM") + ".\n");
                    continue;
                }
                if (ibanLength == 0) {
                    msg.append("IBAN non renseign\u00e9s pour le client " + r.getString("NOM") + ".\n");
                    continue;
                }
                if (bicLength != 0) continue;
                msg.append("BIC non renseign\u00e9s pour le client " + r.getString("NOM") + ".\n");
            }
        }
        return msg.toString();
    }
}

