/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRowValues;

public class PropoLettrageTableModel
extends AbstractTableModel {
    List<SQLRowValues> datas;
    List<String> colName = Arrays.asList("Libell\u00e9", "N\u00b0 Mouvement", "Pi\u00e8ce", "Pi\u00e8ce commerciale", "Date", "D\u00e9bit", "Cr\u00e9dit");
    List<String> fieldName = Arrays.asList("NOM", "ID_MOUVEMENT", "ID_PIECE", "PIECE_COMMERCIALE", "DATE", "DEBIT", "CREDIT");
    List<Class<?>> colClass = Arrays.asList(String.class, Integer.class, String.class, String.class, Date.class, Long.class, Long.class);
    SQLElement eltEcr;

    public PropoLettrageTableModel(SQLElement eltEcr, List<SQLRowValues> datas) {
        this.datas = datas;
        this.eltEcr = eltEcr;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.colClass.get(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.datas.size();
    }

    @Override
    public int getColumnCount() {
        return this.fieldName.size();
    }

    @Override
    public String getColumnName(int column) {
        String field = this.colName.get(column);
        return field;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        SQLRowValues sqlRowValues = this.datas.get(rowIndex);
        String fieldName2 = this.fieldName.get(columnIndex);
        if (fieldName2.startsWith("ID_")) {
            if (fieldName2.equals("ID_MOUVEMENT")) {
                return sqlRowValues.getForeign("ID_MOUVEMENT").getInt("NUMERO");
            }
            return sqlRowValues.getForeign("ID_MOUVEMENT").getForeign("ID_PIECE").getString("NOM");
        }
        return sqlRowValues.getObject(fieldName2);
    }

    public boolean isSelectionEqual(int[] selectionIndex) {
        if (selectionIndex == null || selectionIndex.length == 0) {
            return false;
        }
        long l = 0L;
        int[] nArray = selectionIndex;
        int n = selectionIndex.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            l += this.datas.get(i).getLong("DEBIT");
            l -= this.datas.get(i).getLong("CREDIT");
            ++n2;
        }
        return l == 0L;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    public SQLRowValues getRowValuesAt(int index) {
        return this.datas.get(index);
    }
}

