/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.IListFilterDateStateManager;
import org.openconcerto.erp.utils.TM;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public class IListFilterDatePanel
extends JPanel {
    private JDate dateDu;
    private JDate dateAu;
    private static final String CUSTOM_COMBO_ITEM = TM.tr("dateFilter.custom", new Object[0]);
    private Map<IListe, SQLField> mapList;
    private Map<IListe, ITransformer<SQLSelect, SQLSelect>> mapListTransformer;
    private Map<String, Tuple2<Date, Date>> map;
    private static LinkedHashMap<String, Tuple2<Date, Date>> mapDefault;
    public static boolean LOAD_STATE;
    private static Tuple2<Date, Date> exerciceTuple;
    private JComboBox combo;
    private EventListenerList listeners = new EventListenerList();
    private final PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            IListFilterDatePanel.this.combo.setSelectedItem(CUSTOM_COMBO_ITEM);
            IListFilterDatePanel.this.fireDateChanged();
        }
    };
    private static Tuple2<String, Tuple2<Date, Date>> DEFAULT_FILTER;

    static {
        LOAD_STATE = true;
        DEFAULT_FILTER = null;
    }

    public IListFilterDatePanel(IListe l, SQLField fieldDate) {
        this(l, fieldDate, null);
        if (l.getRequest() == Configuration.getInstance().getDirectory().getElement(l.getSource().getPrimaryTable()).getListRequest()) {
            System.err.println("Attention il ne faut pas utiliser la ListRequest par d\u00e9faut sinon les filtres restent !!!");
            Thread.dumpStack();
        }
    }

    private static void initDefaultMap() {
        mapDefault = new LinkedHashMap();
        SQLRow rowEx = ComptaPropsConfiguration.getInstanceCompta().getRowSociete().getForeignRow("ID_EXERCICE_COMMON");
        Calendar c1 = rowEx.getDate("DATE_DEB");
        IListFilterDatePanel.clearTimeSchedule(c1);
        Calendar c2 = rowEx.getDate("DATE_FIN");
        IListFilterDatePanel.setEndTimeSchedule(c2);
        exerciceTuple = Tuple2.create(c1.getTime(), c2.getTime());
    }

    public static Map<String, Tuple2<Date, Date>> getDefaultMap() {
        if (mapDefault == null) {
            IListFilterDatePanel.initDefaultMap();
        }
        LinkedHashMap<String, Tuple2<Date, Date>> m = new LinkedHashMap<String, Tuple2<Date, Date>>();
        m.putAll(IListFilterDatePanel.getDefaultDateFilter());
        m.putAll(mapDefault);
        return m;
    }

    public static Map<String, Tuple2<Date, Date>> getDefaultDateFilter() {
        LinkedHashMap<String, Tuple2<Date, Date>> mapDefaultDate = new LinkedHashMap<String, Tuple2<Date, Date>>();
        Object emptyDate = null;
        mapDefaultDate.put(TM.tr("dateFilter.none", new Object[0]), Tuple2.create(emptyDate, emptyDate));
        Calendar c = Calendar.getInstance();
        IListFilterDatePanel.clearTimeSchedule(c);
        c.set(5, 1);
        c.set(2, 0);
        Date d1 = c.getTime();
        IListFilterDatePanel.setEndTimeSchedule(c);
        c.set(5, 31);
        c.set(2, 11);
        Date d2 = c.getTime();
        mapDefaultDate.put(TM.tr("dateFilter.currentYear", new Object[0]), Tuple2.create(d1, d2));
        IListFilterDatePanel.clearTimeSchedule(c);
        c.set(5, 1);
        c.set(2, 0);
        c.add(1, -1);
        Date d3 = c.getTime();
        IListFilterDatePanel.setEndTimeSchedule(c);
        c.set(5, 31);
        c.set(2, 11);
        Date d4 = c.getTime();
        mapDefaultDate.put(TM.tr("dateFilter.previousYear", new Object[0]), Tuple2.create(d3, d4));
        c = Calendar.getInstance();
        IListFilterDatePanel.clearTimeSchedule(c);
        c.set(5, 1);
        Date d5 = c.getTime();
        c.set(5, c.getActualMaximum(5));
        IListFilterDatePanel.setEndTimeSchedule(c);
        Date d6 = c.getTime();
        mapDefaultDate.put(TM.tr("dateFilter.currentMonth", new Object[0]), Tuple2.create(d5, d6));
        c = Calendar.getInstance();
        IListFilterDatePanel.clearTimeSchedule(c);
        c.set(5, 1);
        c.add(2, -1);
        Date d7 = c.getTime();
        c.set(5, c.getActualMaximum(5));
        IListFilterDatePanel.setEndTimeSchedule(c);
        Date d8 = c.getTime();
        mapDefaultDate.put(TM.tr("dateFilter.previousMonth", new Object[0]), Tuple2.create(d7, d8));
        c = Calendar.getInstance();
        IListFilterDatePanel.clearTimeSchedule(c);
        c.set(7, 2);
        Date d9 = c.getTime();
        c.set(7, 1);
        IListFilterDatePanel.setEndTimeSchedule(c);
        Date d10 = c.getTime();
        mapDefaultDate.put(TM.tr("dateFilter.currentWeek", new Object[0]), Tuple2.create(d9, d10));
        c = Calendar.getInstance();
        IListFilterDatePanel.clearTimeSchedule(c);
        c.add(5, -7);
        c.set(7, 2);
        Date d11 = c.getTime();
        c.set(7, 1);
        IListFilterDatePanel.setEndTimeSchedule(c);
        Date d12 = c.getTime();
        mapDefaultDate.put(TM.tr("dateFilter.previousWeek", new Object[0]), Tuple2.create(d11, d12));
        if (IListFilterDatePanel.findItem(exerciceTuple, mapDefault).equals(CUSTOM_COMBO_ITEM)) {
            mapDefaultDate.put(TM.tr("dateFilter.currentFiscalYear", new Object[0]), exerciceTuple);
        }
        mapDefaultDate.put(CUSTOM_COMBO_ITEM, null);
        return mapDefaultDate;
    }

    private static void addCustomToMap(Map<String, Tuple2<Date, Date>> map) {
    }

    public static void addDefaultValue(String label, Tuple2<Date, Date> period) {
        if (mapDefault == null) {
            IListFilterDatePanel.initDefaultMap();
        }
        mapDefault.put(label, period);
    }

    public IListFilterDatePanel(IListe l, SQLField fieldDate, Map<String, Tuple2<Date, Date>> m) {
        super(new GridBagLayout());
        this.setOpaque(false);
        HashMap<IListe, SQLField> map = new HashMap<IListe, SQLField>();
        map.put(l, fieldDate);
        this.init(map, m);
    }

    public IListFilterDatePanel(Map<IListe, SQLField> l, Map<String, Tuple2<Date, Date>> m) {
        super(new GridBagLayout());
        this.init(l, m);
    }

    public void init(Map<IListe, SQLField> mapList, Map<String, Tuple2<Date, Date>> m) {
        this.setBorder(BorderFactory.createTitledBorder(TM.tr("dateFilter.range", new Object[0])));
        this.mapList = mapList;
        this.mapListTransformer = new HashMap<IListe, ITransformer<SQLSelect, SQLSelect>>();
        for (IListe l : mapList.keySet()) {
            this.mapListTransformer.put(l, l.getRequest().getSelectTransf());
        }
        this.dateDu = new JDate();
        this.dateAu = new JDate();
        this.map = m;
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = -1;
        c.weightx = 0.0;
        c.fill = 0;
        if (this.map != null && this.map.keySet().size() > 0) {
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            for (String s : this.map.keySet()) {
                model.addElement(s);
            }
            this.combo = new JComboBox(model);
            c.weightx = 0.0;
            this.add((Component)this.combo, c);
            this.combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String s = (String)IListFilterDatePanel.this.combo.getSelectedItem();
                    IListFilterDatePanel.this.setPeriode((Tuple2)IListFilterDatePanel.this.map.get(s));
                }
            });
        }
        this.add((Component)new JLabel(TM.tr("dateFilter.from", new Object[0])), c);
        this.add((Component)this.dateDu, c);
        this.add((Component)new JLabel(TM.tr("dateFilter.to", new Object[0])), c);
        this.add((Component)this.dateAu, c);
        this.dateAu.addValueListener(this.listener);
        this.dateDu.addValueListener(this.listener);
        IListFilterDateStateManager stateManager = new IListFilterDateStateManager(this, IListFilterDatePanel.getConfigFile(mapList), true);
        if (LOAD_STATE) {
            stateManager.loadState();
        }
    }

    public void setDateDu(Date d) {
        this.dateDu.setValue(d);
    }

    public void setDateAu(Date d) {
        this.dateAu.setValue(d);
    }

    public Date getFromValue() {
        return this.dateDu.getValue();
    }

    public Date getToValue() {
        return this.dateAu.getValue();
    }

    public static void setDefaultFilter(Tuple2<String, Tuple2<Date, Date>> t) {
        DEFAULT_FILTER = t;
    }

    public void setFilterOnDefault() {
        if (DEFAULT_FILTER != null) {
            if (this.combo != null) {
                this.combo.setSelectedItem(DEFAULT_FILTER.get0());
            } else {
                this.setPeriode(DEFAULT_FILTER.get1().get0(), DEFAULT_FILTER.get1().get1());
            }
        }
    }

    public void setPeriode(Tuple2<Date, Date> t) {
        if (t != null) {
            this.setPeriode(t.get0(), t.get1());
        }
    }

    public void setPeriode(Date du, Date au) {
        this.setDateAu(au);
        this.setDateDu(du);
        this.fireDateChanged();
    }

    public void fireDateChanged() {
        SQLField filterField;
        Calendar c;
        if (this.dateAu.getValue() == null && this.dateDu.getValue() == null) {
            for (IListe list : this.mapList.keySet()) {
                list.getRequest().setSelectTransf(this.mapListTransformer.get(list));
            }
        } else if (this.dateAu.getValue() == null) {
            c = Calendar.getInstance();
            c.setTime(this.dateDu.getValue());
            IListFilterDatePanel.clearTimeSchedule(c);
            for (final IListe list : this.mapList.keySet()) {
                filterField = this.mapList.get(list);
                list.getRequest().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        Where w = new Where(input.getAlias(filterField), ">=", (Object)c.getTime());
                        return IListFilterDatePanel.this.setWhere(input, w, (ITransformer)IListFilterDatePanel.this.mapListTransformer.get(list));
                    }
                });
            }
        } else if (this.dateDu.getValue() == null) {
            c = Calendar.getInstance();
            c.setTime(this.dateAu.getValue());
            IListFilterDatePanel.setEndTimeSchedule(c);
            for (final IListe list : this.mapList.keySet()) {
                filterField = this.mapList.get(list);
                list.getRequest().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        Where w = new Where(input.getAlias(filterField), "<=", (Object)c.getTime());
                        return IListFilterDatePanel.this.setWhere(input, w, (ITransformer)IListFilterDatePanel.this.mapListTransformer.get(list));
                    }
                });
            }
        } else {
            c = Calendar.getInstance();
            c.setTime(this.dateAu.getValue());
            IListFilterDatePanel.setEndTimeSchedule(c);
            final Calendar c2 = Calendar.getInstance();
            c2.setTime(this.dateDu.getValue());
            IListFilterDatePanel.clearTimeSchedule(c2);
            for (final IListe list : this.mapList.keySet()) {
                final SQLField filterField2 = this.mapList.get(list);
                list.getRequest().setSelectTransf(new ITransformer<SQLSelect, SQLSelect>(){

                    @Override
                    public SQLSelect transformChecked(SQLSelect input) {
                        Where w = new Where(input.getAlias(filterField2), c2.getTime(), (Object)c.getTime());
                        return IListFilterDatePanel.this.setWhere(input, w, (ITransformer)IListFilterDatePanel.this.mapListTransformer.get(list));
                    }
                });
            }
        }
        Tuple2<Date, Date> selectedTuple = Tuple2.create(this.dateDu.getValue(), this.dateAu.getValue());
        this.combo.setSelectedItem(IListFilterDatePanel.findItem(selectedTuple, this.map));
        PropertyChangeListener[] propertyChangeListenerArray = (PropertyChangeListener[])this.listeners.getListeners(PropertyChangeListener.class);
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener l = propertyChangeListenerArray[n2];
            l.propertyChange(new PropertyChangeEvent(this, "valueChanged", null, selectedTuple));
            ++n2;
        }
    }

    public void addValueListener(PropertyChangeListener l) {
        this.listeners.add(PropertyChangeListener.class, l);
    }

    public void rmValueListener(PropertyChangeListener l) {
        this.listeners.remove(PropertyChangeListener.class, l);
    }

    private SQLSelect setWhere(SQLSelect input, Where w, ITransformer<SQLSelect, SQLSelect> t) {
        if (t != null) {
            input = t.transformChecked(input);
        }
        input.andWhere(w);
        return input;
    }

    public static String findItem(Tuple2<Date, Date> t, Map<String, Tuple2<Date, Date>> mapItem) {
        Date d1 = t.get0();
        Date d2 = t.get1();
        Calendar c1 = IListFilterDatePanel.getCalendarFromDate(d1);
        Calendar c2 = IListFilterDatePanel.getCalendarFromDate(d2);
        for (String label : mapItem.keySet()) {
            Tuple2<Date, Date> t2 = mapItem.get(label);
            if (t2 == null) continue;
            Date get0 = t2.get0();
            Date get1 = t2.get1();
            Calendar cGet0 = IListFilterDatePanel.getCalendarFromDate(get0);
            Calendar cGet1 = IListFilterDatePanel.getCalendarFromDate(get1);
            if (!IListFilterDatePanel.isDateEquals(c1, cGet0) || !IListFilterDatePanel.isDateEquals(c2, cGet1)) continue;
            return label;
        }
        return CUSTOM_COMBO_ITEM;
    }

    private static Calendar getCalendarFromDate(Date d) {
        Calendar cal = null;
        if (d != null) {
            cal = Calendar.getInstance();
            cal.setTime(d);
        }
        return cal;
    }

    public static boolean isDateEquals(Calendar d1, Calendar d2) {
        boolean b = false;
        b = d1 == null && d2 == null ? true : (d1 != null && d2 != null ? d1.get(5) == d2.get(5) && d2.get(1) == d1.get(1) && d1.get(2) == d2.get(2) : false);
        return b;
    }

    private static void clearTimeSchedule(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }

    private static void setEndTimeSchedule(Calendar c) {
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 59);
    }

    private static final File getConfigFile(Map<IListe, SQLField> mapList) {
        Configuration conf = Configuration.getInstance();
        if (conf == null) {
            return null;
        }
        String name = null;
        for (IListe l : mapList.keySet()) {
            File configFile = l.getConfigFile();
            if (configFile != null) {
                String confName = configFile.getName();
                if (name == null) {
                    name = confName;
                    continue;
                }
                if (name.compareTo(confName) <= 0) continue;
                name = confName;
                continue;
            }
            name = l.getSource().getPrimaryTable().getName();
        }
        return new File(conf.getConfDir(), "DateRanges" + File.separator + name);
    }
}

