/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.experimental.permutation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.experimental.permutation.ArrayPermutationsIter;
import org.jgrapht.experimental.permutation.IntegerPermutationIter;

public class CollectionPermutationIter<E> {
    private ArrayPermutationsIter permOrder;
    private List<E> sourceArray;
    private int[] currPermutationArray;

    public CollectionPermutationIter(Set<E> objectsSet) {
        this(new ArrayList<E>(objectsSet), new IntegerPermutationIter(objectsSet.size()));
    }

    public CollectionPermutationIter(List<E> objectsArray) {
        this(objectsArray, new IntegerPermutationIter(objectsArray.size()));
    }

    public CollectionPermutationIter(List<E> objectsArray, ArrayPermutationsIter permuter) {
        this.permOrder = permuter;
        this.sourceArray = objectsArray;
    }

    public boolean hasNext() {
        return this.permOrder.hasNextPermutaions();
    }

    public List<E> getNextArray() {
        List<E> permutationResult;
        if (this.permOrder.hasNextPermutaions()) {
            this.currPermutationArray = this.permOrder.nextPermutation();
            permutationResult = this.applyPermutation();
        } else {
            permutationResult = null;
        }
        return permutationResult;
    }

    private List<E> applyPermutation() {
        ArrayList<E> output = new ArrayList<E>(this.sourceArray);
        int i = 0;
        while (i < output.size()) {
            output.set(i, this.sourceArray.get(this.currPermutationArray[i]));
            ++i;
        }
        return output;
    }

    public Set<E> getNextSet() {
        List<E> result = this.getNextArray();
        if (result == null) {
            return null;
        }
        LinkedHashSet<E> resultSet = new LinkedHashSet<E>(result);
        return resultSet;
    }

    public int[] getCurrentPermutationArray() {
        return this.currPermutationArray;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Permutation int[]=");
        sb.append(Arrays.toString(this.getCurrentPermutationArray()));
        List<E> permutationResult = this.applyPermutation();
        sb.append("\nPermutationSet Source Object[]=");
        sb.append(this.sourceArray.toString());
        sb.append("\nPermutationSet Result Object[]=");
        sb.append(permutationResult.toString());
        return sb.toString();
    }
}

