/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import jpos.config.JposConfigException;
import jpos.config.JposEntry;
import jpos.config.simple.SimpleEntry;
import jpos.config.simple.xml.AbstractXercesRegPopulator;
import jpos.util.JposEntryUtility;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class Xerces2RegPopulator
extends AbstractXercesRegPopulator {
    private XMLReader xmlReader;
    private SAXParser saxParser;
    private ErrorHandler errorHandler;
    private ContentHandler contentHandler;
    private EntityResolver entityResolver;
    private List jposEntryList;
    private Tracer tracer;
    public static final String XERCES2_REG_POPULATOR_NAME_STRING = "JCL XML Entries Populator 2";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public Xerces2RegPopulator() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("jpos.config.simple.xml.XercesRegPopulator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz.getName());
        this.xmlReader = null;
        this.saxParser = null;
        this.errorHandler = new JposErrorHandler();
        this.contentHandler = new JposContentHandler();
        this.entityResolver = new JposEntityResolver();
        this.jposEntryList = new LinkedList();
        this.tracer = TracerFactory.getInstance().createTracer("Xerces2RegPopulator");
    }

    public Xerces2RegPopulator(String s) {
        super(s);
        this.xmlReader = null;
        this.saxParser = null;
        this.errorHandler = new JposErrorHandler();
        this.contentHandler = new JposContentHandler();
        this.entityResolver = new JposEntityResolver();
        this.jposEntryList = new LinkedList();
        this.tracer = TracerFactory.getInstance().createTracer("Xerces2RegPopulator");
    }

    public String getClassName() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("jpos.config.simple.xml.Xerces2RegPopulator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    public void load() {
        try {
            InputStream is = this.getPopulatorFileIS();
            this.load(this.getPopulatorFileName());
        }
        catch (Exception e) {
            this.tracer.println("Error while loading populator file Exception.message: " + e.getMessage());
            this.lastLoadException = e;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(String xmlFileName) {
        Reader reader = null;
        try {
            try {
                this.getJposEntries().clear();
                File xmlFile = new File(xmlFileName);
                InputStream is = null;
                is = xmlFile.exists() ? new FileInputStream(xmlFile) : this.findFileInClasspath(xmlFileName);
                InputSource inputSource = new InputSource(is);
                String a = inputSource.getSystemId();
                XMLReader xmlReader = this.getSAXParser().getXMLReader();
                this.initXMLReader(xmlReader);
                xmlReader.setErrorHandler(this.errorHandler);
                xmlReader.setContentHandler(this.contentHandler);
                xmlReader.setDTDHandler((JposContentHandler)this.contentHandler);
                xmlReader.setEntityResolver(this.entityResolver);
                this.jposEntryList.clear();
                this.lastLoadException = null;
                xmlReader.parse(inputSource);
                Iterator entries = this.jposEntryList.iterator();
                while (entries.hasNext()) {
                    JposEntry jposEntry = (JposEntry)entries.next();
                    this.getJposEntries().put(jposEntry.getLogicalName(), jposEntry);
                }
            }
            catch (FileNotFoundException fne) {
                this.tracer.println("Could not find file: " + xmlFileName);
                this.lastLoadException = fne;
            }
            catch (ParserConfigurationException pce) {
                this.tracer.println("Could not create and configure SAX parser/factory" + pce.getMessage());
                this.lastLoadException = pce;
            }
            catch (IOException ioe) {
                this.tracer.println("Error while parsing XML file:IOException.msg=" + ioe.getMessage());
                this.lastLoadException = ioe;
            }
            catch (SAXException se) {
                this.tracer.println("Error creating or using the SAXParser:SAXException.message=" + se.getMessage());
                this.lastLoadException = se;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            try {
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            catch (IOException ioe) {
                this.tracer.println("load( " + xmlFileName + ") IOException.msg=" + ioe.getMessage());
            }
            throw throwable;
        }
        {
            Object var10_16 = null;
        }
        try {}
        catch (IOException ioe) {
            this.tracer.println("load( " + xmlFileName + ") IOException.msg=" + ioe.getMessage());
            return;
        }
        if (reader == null) return;
        reader.close();
    }

    public String getName() {
        return XERCES2_REG_POPULATOR_NAME_STRING;
    }

    protected SAXParser getSAXParser() throws ParserConfigurationException, SAXException {
        if (this.saxParser == null) {
            SAXParserFactoryImpl factory = new SAXParserFactoryImpl();
            this.saxParser = factory.newSAXParser();
        }
        return this.saxParser;
    }

    protected void initXMLReader(XMLReader xmlReader) throws SAXException {
        xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
        xmlReader.setFeature("http://apache.org/xml/features/validation/schema", true);
        xmlReader.setFeature("http://xml.org/sax/features/validation", true);
    }

    protected Document createEmptyDocument() {
        DocumentImpl doc = null;
        DOMImplementationImpl domImpImpl = (DOMImplementationImpl)DOMImplementationImpl.getDOMImplementation();
        Object docType = null;
        doc = new DocumentImpl();
        Element root = doc.createElement("JposEntries");
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        root.setAttribute("xsi:noNamespaceSchemaLocation", this.getDoctypeValue());
        doc.appendChild(root);
        return doc;
    }

    protected String getDoctypeValue() {
        String ret = "";
        ret = "/jpos/res/jcl.xsd";
        return ret;
    }

    protected class JposContentHandler
    extends DefaultHandler
    implements ContentHandler {
        private JposEntry currentEntry = null;

        protected JposContentHandler() {
        }

        public void startDocument() throws SAXException {
            Xerces2RegPopulator.this.tracer.println("<startDocument/>");
        }

        public void endDocument() throws SAXException {
            Xerces2RegPopulator.this.tracer.println("<endDocument/>");
        }

        public void startElement(String namespaceUri, String localName, String qName, Attributes attributes) throws SAXException {
            Xerces2RegPopulator.this.tracer.println("<startElement qName=\"" + qName + "\"/>");
            if (qName.equals("JposEntries")) {
                Xerces2RegPopulator.this.jposEntryList.clear();
                this.currentEntry = null;
            } else if (qName.equals("JposEntry")) {
                this.currentEntry = this.createEntry(attributes);
            } else if (qName.equals("creation")) {
                this.addCreationProp(this.currentEntry, attributes);
            } else if (qName.equals("vendor")) {
                this.addVendorProp(this.currentEntry, attributes);
            } else if (qName.equals("jpos")) {
                this.addJposProp(this.currentEntry, attributes);
            } else if (qName.equals("product")) {
                this.addProductProp(this.currentEntry, attributes);
            } else if (qName.equals("prop")) {
                this.addProp(this.currentEntry, attributes);
            } else {
                Xerces2RegPopulator.this.tracer.println("Invalid qName=" + qName);
                throw new SAXException("Invalid qName=" + qName);
            }
        }

        public void endElement(String namespaceUri, String localName, String qName) throws SAXException {
            Xerces2RegPopulator.this.tracer.println("<endElement qName=\"" + qName + "\"/>");
            if (qName.equals("JposEntry")) {
                Xerces2RegPopulator.this.jposEntryList.add(this.currentEntry);
            }
        }

        protected JposEntry createEntry(Attributes attributes) throws SAXException {
            String logicalName = attributes.getValue("logicalName");
            return new SimpleEntry(logicalName, Xerces2RegPopulator.this);
        }

        protected void addCreationProp(JposEntry entry, Attributes attributes) throws SAXException {
            String factoryClass = attributes.getValue("factoryClass");
            String serviceClass = attributes.getValue("serviceClass");
            this.currentEntry.addProperty("serviceInstanceFactoryClass", factoryClass);
            this.currentEntry.addProperty("serviceClass", serviceClass);
        }

        protected void addVendorProp(JposEntry entry, Attributes attributes) throws SAXException {
            String factoryClass = attributes.getValue("name");
            String serviceClass = attributes.getValue("url");
            this.currentEntry.addProperty("vendorName", factoryClass);
            this.currentEntry.addProperty("vendorURL", serviceClass);
        }

        protected void addJposProp(JposEntry entry, Attributes attributes) throws SAXException {
            String category = attributes.getValue("category");
            String version = attributes.getValue("version");
            this.currentEntry.addProperty("deviceCategory", category);
            this.currentEntry.addProperty("jposVersion", version);
        }

        protected void addProductProp(JposEntry entry, Attributes attributes) throws SAXException {
            String description = attributes.getValue("description");
            String name = attributes.getValue("name");
            String url = attributes.getValue("url");
            this.currentEntry.addProperty("productDescription", description);
            this.currentEntry.addProperty("productName", name);
            this.currentEntry.addProperty("productURL", url);
        }

        protected void addProp(JposEntry entry, Attributes attributes) throws SAXException {
            String name = attributes.getValue("name");
            String valueString = attributes.getValue("value");
            String typeString = attributes.getValue("type");
            if (typeString == null || typeString.equals("")) {
                typeString = "String";
            }
            try {
                Class typeClass = JposEntryUtility.propTypeFromString(attributes.getValue("type"));
                Object value = JposEntryUtility.parsePropValue(valueString, typeClass);
                JposEntry.Prop prop = this.currentEntry.createProp(name, value, typeClass);
                this.currentEntry.add(prop);
            }
            catch (JposConfigException jce) {
                String msg = "Invalid prop: name=" + name + ":value=" + valueString;
                Xerces2RegPopulator.this.tracer.println(msg);
                throw new SAXException(msg);
            }
        }
    }

    public class JposEntityResolver
    implements EntityResolver {
        public InputSource resolveEntity(String publicId, String systemId) {
            Xerces2RegPopulator.this.tracer.println("JposEntityResolver:resolveEntity:publicId=" + publicId);
            Xerces2RegPopulator.this.tracer.println("JposEntityResolver:resolveEntity:systemId=" + systemId);
            InputStream is = null;
            if (systemId.endsWith(".xsd")) {
                is = this.getClass().getResourceAsStream("/jpos/res/jcl.xsd");
            } else if (systemId.endsWith(".dtd") && publicId.indexOf("-//JavaPOS//DTD//EN") != -1) {
                is = this.getClass().getResourceAsStream("/jpos/res/jcl.dtd");
            }
            if (is != null) {
                return new InputSource(new InputStreamReader(is));
            }
            return null;
        }
    }

    protected class JposErrorHandler
    implements ErrorHandler {
        protected JposErrorHandler() {
        }

        private String createMessage(String header, SAXParseException spe) {
            return String.valueOf(header) + "parsing XML file:SAXParseException.message = " + spe.getMessage();
        }

        public void error(SAXParseException spe) throws SAXException {
            String message = this.createMessage("JposErrorHandler:Error:", spe);
            Xerces2RegPopulator.this.tracer.print(message);
            throw new SAXException(message);
        }

        public void fatalError(SAXParseException spe) throws SAXException {
            String message = this.createMessage("JposErrorHandler:FatalError:", spe);
            Xerces2RegPopulator.this.tracer.print(message);
            throw new SAXException(message);
        }

        public void warning(SAXParseException spe) throws SAXException {
            String message = this.createMessage("JposErrorHandler:Warning:", spe);
            Xerces2RegPopulator.this.tracer.print(message);
            throw new SAXException(message);
        }
    }
}

