/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.io;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import org.openconcerto.utils.StringUtils;
import org.openconcerto.utils.io.MailAccount;

public class Mail {
    private String text = "";
    private final Map<File, String> attachements = new HashMap<File, String>();
    private final Session session;
    private final MimeMessage msg;

    public Mail(String subject, String recipient) throws MessagingException {
        this();
        this.msg.setSubject(subject);
        this.msg.setRecipient(Message.RecipientType.TO, (Address)new InternetAddress(recipient, true));
    }

    public Mail() {
        boolean debug = Boolean.getBoolean("mail.debug");
        this.session = Session.getInstance((Properties)new Properties(), null);
        this.session.setDebug(debug);
        this.msg = new MimeMessage(this.session);
    }

    public final Mail setText(String text) {
        this.text = text;
        return this;
    }

    public Map<File, String> getAttachments() {
        return this.attachements;
    }

    public final MimeMessage getMessage() {
        return this.msg;
    }

    public final void fillMessage(MailAccount account) throws IOException, MessagingException {
        Properties props = this.session.getProperties();
        props.putAll((Map<?, ?>)account.createProperties());
        MimeMessage msg = this.msg;
        if (msg.getFrom() == null) {
            try {
                msg.setFrom((Address)new InternetAddress(account.getAddress(), account.getName()));
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalArgumentException("can't encode account.getName()", e);
            }
        }
    }

    public final void setContent() throws MessagingException, IOException {
        if (this.attachements.isEmpty()) {
            this.setText((MimePart)this.msg);
        } else {
            MimeBodyPart txt = new MimeBodyPart();
            this.setText((MimePart)txt);
            MimeMultipart multi = new MimeMultipart();
            multi.addBodyPart((BodyPart)txt);
            for (Map.Entry<File, String> e : this.attachements.entrySet()) {
                MimeBodyPart att = new MimeBodyPart();
                att.attachFile(e.getKey());
                if (e.getValue() != null) {
                    att.setFileName(e.getValue());
                }
                multi.addBodyPart((BodyPart)att);
            }
            this.msg.setContent((Multipart)multi);
        }
    }

    public final void send(MailAccount account) throws IOException, MessagingException {
        this.fillMessage(account);
        this.setContent();
        account.send((Message)this.getMessage());
    }

    private void setText(MimePart txt) throws MessagingException {
        txt.setText(this.text, StringUtils.UTF8.name());
    }
}

