/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.ColumnsSpec;
import org.openconcerto.ui.light.RowSelectionSpec;
import org.openconcerto.ui.light.TableContent;
import org.openconcerto.ui.light.TableSearchParameter;
import org.openconcerto.ui.light.UserSearch;
import org.openconcerto.utils.io.JSONConverter;
import org.openconcerto.utils.io.Transferable;

public class TableSpec
implements Transferable {
    private String id;
    private ColumnsSpec columns;
    private TableContent content;
    private RowSelectionSpec selection;
    private List<TableSearchParameter> searchParameters = new ArrayList<TableSearchParameter>();
    private UserSearch search;
    private Boolean variableColumnsCount = false;

    public TableSpec() {
    }

    public TableSpec(String tableId, RowSelectionSpec selection, ColumnsSpec columns) {
        this.id = String.valueOf(tableId) + ".spec";
        if (selection == null) {
            throw new IllegalArgumentException("null RowSelectionSpec");
        }
        if (columns == null) {
            throw new IllegalArgumentException("null ColumnsSpec");
        }
        this.selection = selection;
        this.columns = columns;
        this.content = new TableContent(tableId);
    }

    public TableSpec(JSONObject json) {
        this.fromJSON(json);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ColumnsSpec getColumns() {
        return this.columns;
    }

    public void setColumns(ColumnsSpec columns) {
        this.columns = columns;
    }

    public TableContent getContent() {
        return this.content;
    }

    public void setContent(TableContent content) {
        this.content = content;
    }

    public RowSelectionSpec getSelection() {
        return this.selection;
    }

    public void setSelection(RowSelectionSpec selection) {
        this.selection = selection;
    }

    public UserSearch getSearch() {
        return this.search;
    }

    public void setSearch(UserSearch search) {
        this.search = search;
    }

    public Boolean isVariableColumnsCount() {
        return this.variableColumnsCount;
    }

    public void setVariableColumnsCount(Boolean variableColumnsCount) {
        this.variableColumnsCount = variableColumnsCount;
    }

    public void addSearchParameter(TableSearchParameter p) {
        this.searchParameters.add(p);
    }

    public void removeSearchParameter(TableSearchParameter p) {
        this.searchParameters.remove(p);
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        result.put("class", "TableSpec");
        result.put("id", this.id);
        if (this.columns != null) {
            result.put("columns", JSONConverter.getJSON(this.columns));
        }
        if (this.content != null) {
            result.put("content", JSONConverter.getJSON(this.content));
        }
        if (this.selection != null) {
            result.put("selection", JSONConverter.getJSON(this.selection));
        }
        if (this.search != null) {
            result.put("search", JSONConverter.getJSON(this.search));
        }
        if (this.variableColumnsCount.booleanValue()) {
            result.put("variable-columns-count", JSONConverter.getJSON(true));
        }
        if (!this.searchParameters.isEmpty()) {
            JSONArray a = new JSONArray();
            for (TableSearchParameter p : this.searchParameters) {
                a.add(p.toJSON());
            }
            result.put("search-params", a);
        }
        return result;
    }

    @Override
    public void fromJSON(JSONObject json) {
        JSONObject jsonSelection;
        JSONObject jsonContent;
        this.id = json.getAsString("id");
        JSONObject jsonColumns = JSONConverter.getParameterFromJSON(json, "columns", JSONObject.class);
        if (jsonColumns != null) {
            this.columns = new ColumnsSpec(jsonColumns);
        }
        if ((jsonContent = JSONConverter.getParameterFromJSON(json, "content", JSONObject.class)) != null) {
            this.content = new TableContent(jsonContent);
        }
        if ((jsonSelection = JSONConverter.getParameterFromJSON(json, "selection", JSONObject.class)) == null) {
            throw new IllegalArgumentException("null selection");
        }
        this.selection = new RowSelectionSpec(jsonSelection);
        JSONObject jsonSearch = JSONConverter.getParameterFromJSON(json, "search", JSONObject.class);
        if (jsonSearch != null) {
            this.search = new UserSearch(jsonSearch);
        }
        this.variableColumnsCount = JSONConverter.getParameterFromJSON(json, "variable-columns-count", Boolean.class);
        this.searchParameters.clear();
        if (json.containsKey("search-params")) {
            JSONArray array = (JSONArray)json.get("search-params");
            for (Object o : array) {
                TableSearchParameter p = new TableSearchParameter();
                p.fromJSON((JSONObject)o);
                this.searchParameters.add(p);
            }
        }
    }
}

