/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Component;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class SwingThreadUtils {
    public static final void invoke(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static <T> T call(Callable<T> c) throws Exception {
        if (SwingUtilities.isEventDispatchThread()) {
            return c.call();
        }
        FutureTask<T> f = new FutureTask<T>(c);
        SwingUtilities.invokeLater(f);
        return f.get();
    }

    public static final <C> C getAncestorOrSelf(Class<C> c, Component component) {
        while (component != null && !c.isInstance(component)) {
            component = component instanceof JPopupMenu ? ((JPopupMenu)component).getInvoker() : component.getParent();
        }
        return c.cast(component);
    }

    public static final String getActionID(Action a) {
        Object actionID = a.getValue("ActionCommandKey");
        if (actionID == null) {
            actionID = a.getValue("Name");
        }
        return actionID == null ? null : actionID.toString();
    }

    public static final void setActionID(Action a, String id) {
        a.putValue("ActionCommandKey", id);
    }
}

