/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.openconcerto.utils.JImage;

public class MovableContainerComponent
extends JComponent
implements MouseListener,
MouseMotionListener {
    private int size;
    private int offsetX;
    int currentIndex;
    private Vector list = new Vector();
    private JComponent draggedComponent = null;
    private int draggedComponentIndex;
    private Image componentImage;
    private JComponent imgComp;
    private Point pOffset;
    private JLayeredPane layerPane;

    public MovableContainerComponent(int size) {
        this.size = size;
        this.setLayout(new GridLayout(1, size));
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public Component add(Component comp) {
        this.list.add(comp);
        comp.addMouseListener(this);
        comp.addMouseMotionListener(this);
        return super.add(comp);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getY() < 16) {
            int i = 0;
            while (i < this.list.size()) {
                JComponent obj = (JComponent)this.list.elementAt(i);
                if (obj == e.getSource()) {
                    System.out.println("Le " + i + " eme est dragge");
                    this.draggedComponent = obj;
                    this.draggedComponentIndex = i;
                    this.currentIndex = i;
                    this.componentImage = new BufferedImage(obj.getWidth(), obj.getHeight(), 2);
                    Graphics gc = this.componentImage.getGraphics();
                    obj.print(gc);
                    this.layerPane = obj.getRootPane().getLayeredPane();
                    this.offsetX = e.getX();
                    this.pOffset = SwingUtilities.convertPoint(obj, 0, 0, this.layerPane);
                    System.out.println(this.pOffset);
                    this.imgComp = new JImage(this.componentImage);
                    this.imgComp.setLocation(this.pOffset);
                    this.imgComp.setSize(this.imgComp.getPreferredSize());
                    this.layerPane.add((Component)this.imgComp, JLayeredPane.DRAG_LAYER);
                    this.draggedComponent.setVisible(false);
                }
                ++i;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.draggedComponent.setVisible(true);
        this.draggedComponent = null;
        this.layerPane.remove(this.imgComp);
        this.layerPane.validate();
        this.layerPane.repaint();
        this.componentImage = null;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.componentImage != null) {
            int select;
            this.pOffset = SwingUtilities.convertPoint((JComponent)e.getSource(), 0, 0, this.layerPane);
            int currentX = e.getX() + this.pOffset.x - this.offsetX;
            Point p = SwingUtilities.convertPoint(this, 0, 0, this.layerPane);
            if (currentX < p.x) {
                currentX = p.x;
            }
            p = SwingUtilities.convertPoint(this, this.getWidth() - 2, 0, this.layerPane);
            p.x -= this.draggedComponent.getWidth();
            if (currentX >= p.x) {
                currentX = p.x;
            }
            if ((select = currentX / (this.getWidth() / this.size)) != this.currentIndex) {
                JComponent obj;
                this.currentIndex = select;
                this.remove(this.draggedComponent);
                int i = 0;
                while (i < this.list.size()) {
                    obj = (JComponent)this.list.elementAt(i);
                    this.remove(obj);
                    ++i;
                }
                this.swap(this.draggedComponentIndex, select);
                i = 0;
                while (i < this.list.size()) {
                    obj = (JComponent)this.list.elementAt(i);
                    super.add(obj);
                    ++i;
                }
                this.draggedComponentIndex = select;
                this.draggedComponent = (JComponent)this.list.elementAt(select);
                this.validate();
            }
            this.imgComp.setLocation(currentX, this.pOffset.y);
        }
    }

    private void swap(int i, int j) {
        System.out.println("Swap: " + i + "," + j);
        JComponent c1 = (JComponent)this.list.get(i);
        JComponent c2 = (JComponent)this.list.get(j);
        this.list.set(j, c1);
        this.list.set(i, c2);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

