/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.ui.IListFilterDatePanel;
import org.openconcerto.erp.core.finance.accounting.ui.ListEcritureRenderer;
import org.openconcerto.erp.core.finance.accounting.ui.ListPanelEcritures;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.ITableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.utils.GestionDevise;

public class ListeDesEcrituresPanel
extends JPanel {
    private ListPanelEcritures panelEcritures = new ListPanelEcritures();
    private JPanel panelTotal;
    private JPanel panelLegende;
    private JLabel montantDebit = new JLabel("0.0");
    private JLabel montantCredit = new JLabel("0.0");
    private JLabel montantSolde = new JLabel("0.0");

    public ListeDesEcrituresPanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 2;
        c.fill = 1;
        this.add((Component)this.panelEcritures, c);
        SQLRow rowExercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON").getRow(ComptaPropsConfiguration.getInstanceCompta().getRowSociete().getInt("ID_EXERCICE_COMMON"));
        IListFilterDatePanel comp = new IListFilterDatePanel(this.panelEcritures.getListe(), this.panelEcritures.getListe().getSource().getElem().getTable().getField("DATE"), IListFilterDatePanel.getDefaultMap());
        comp.setDateDu((Date)rowExercice.getObject("DATE_DEB"));
        c.weightx = 1.0;
        ++c.gridy;
        this.add((Component)comp, c);
        c.gridwidth = 1;
        ++c.gridy;
        this.panelLegende = new JPanel();
        this.panelLegende.setLayout(new GridBagLayout());
        this.panelLegende.setBorder(BorderFactory.createTitledBorder("L\u00e9gende"));
        c.insets = new Insets(0, 0, 0, 0);
        JPanel panelValide = new JPanel();
        panelValide.setLayout(new GridBagLayout());
        panelValide.add(new JLabel("Ecritures valid\u00e9es"));
        panelValide.setBackground(Color.WHITE);
        ++c.gridy;
        this.panelLegende.add((Component)panelValide, c);
        JPanel panelNonValide = new JPanel();
        panelNonValide.setLayout(new GridBagLayout());
        panelNonValide.add(new JLabel("Ecritures non valid\u00e9es"));
        panelNonValide.setBackground(ListEcritureRenderer.getCouleurEcritureNonValide());
        ++c.gridy;
        this.panelLegende.add((Component)panelNonValide, c);
        JPanel panelNonValideToDay = new JPanel();
        panelNonValideToDay.setLayout(new GridBagLayout());
        panelNonValideToDay.add(new JLabel("Ecritures non valid\u00e9es du jour"));
        panelNonValideToDay.setBackground(ListEcritureRenderer.getCouleurEcritureToDay());
        ++c.gridy;
        this.panelLegende.add((Component)panelNonValideToDay, c);
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.insets = new Insets(2, 2, 1, 2);
        this.add((Component)this.panelLegende, c);
        c.gridx = 0;
        this.panelTotal = new JPanel();
        this.panelTotal.setLayout(new GridBagLayout());
        this.panelTotal.setBorder(BorderFactory.createTitledBorder("Totaux"));
        JLabel labelDebit = new JLabel("D\u00e9bit");
        c.anchor = 13;
        c.weightx = 0.0;
        c.weighty = 0.0;
        this.panelTotal.add((Component)labelDebit, c);
        ++c.gridx;
        this.panelTotal.add((Component)this.montantDebit, c);
        JLabel labelCredit = new JLabel("Cr\u00e9dit");
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 0.0;
        this.panelTotal.add((Component)labelCredit, c);
        ++c.gridx;
        this.panelTotal.add((Component)this.montantCredit, c);
        JLabel labelSolde = new JLabel("Solde");
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.panelTotal.add((Component)labelSolde, c);
        ++c.gridx;
        this.panelTotal.add((Component)this.montantSolde, c);
        c.gridy = 2;
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 0;
        this.add((Component)this.panelTotal, c);
        this.panelEcritures.getListe().addListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                long totalDebit = 0L;
                long totalCredit = 0L;
                TableModel tableModel = ListeDesEcrituresPanel.this.panelEcritures.getListe().getTableModel();
                if (tableModel instanceof ITableModel) {
                    ITableModel model = ListeDesEcrituresPanel.this.panelEcritures.getListe().getModel();
                    int i = 0;
                    while (i < model.getRowCount()) {
                        SQLRowValues ecritureRow = model.getRow(i).getRow();
                        totalDebit += ((Long)ecritureRow.getObject("DEBIT")).longValue();
                        totalCredit += ((Long)ecritureRow.getObject("CREDIT")).longValue();
                        ++i;
                    }
                    ListeDesEcrituresPanel.this.montantDebit.setText(GestionDevise.currencyToString(totalDebit));
                    ListeDesEcrituresPanel.this.montantCredit.setText(GestionDevise.currencyToString(totalCredit));
                    ListeDesEcrituresPanel.this.montantSolde.setText(GestionDevise.currencyToString(totalDebit - totalCredit));
                }
            }
        });
    }

    public ListPanelEcritures getListPanelEcritures() {
        return this.panelEcritures;
    }
}

