/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jopendocument.link.OOConnexion;
import org.openconcerto.erp.config.ComptaPropsConfiguration;

public class AskUserImpressionPanel
extends JPanel {
    public AskUserImpressionPanel(String docURL, String printerName, Map<String, Object> propsVal) {
        final File f = new File(docURL);
        JLabel labelConfirm = new JLabel("Impression du document " + f.getName() + " sur " + printerName);
        JButton buttonLancer = new JButton("Lancer");
        JButton buttonAnnul = new JButton("Annuler");
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.gridy = 0;
        c.gridx = 0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.insets = new Insets(2, 2, 1, 2);
        c.anchor = 10;
        this.add((Component)labelConfirm, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        JPanel panel = new JPanel();
        panel.add(buttonLancer);
        panel.add((Component)buttonAnnul, c);
        this.add((Component)panel, c);
        buttonAnnul.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(AskUserImpressionPanel.this)).dispose();
            }
        });
        buttonLancer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    OOConnexion ooConnexion = ComptaPropsConfiguration.getOOConnexion();
                    if (ooConnexion == null) {
                        return;
                    }
                    org.jopendocument.link.Component doc = ooConnexion.loadDocument(f, true);
                    doc.close();
                }
                catch (LinkageError e1) {
                    JOptionPane.showMessageDialog(new JFrame(), "Merci d'installer OpenOffice ou LibreOffice");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                ((JFrame)SwingUtilities.getRoot(AskUserImpressionPanel.this)).dispose();
            }
        });
    }
}

