/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.i18n;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.Value;
import org.openconcerto.utils.cc.ITransformer;

public class DynamicMap<V>
implements Map<String, V> {
    private final Map<String, V> delegate;
    private final ITransformer<? super Tuple2<DynamicMap<V>, String>, ? extends V> createValue;

    public DynamicMap() {
        this(new HashMap());
    }

    public DynamicMap(Map<String, V> delegate) {
        this(delegate, null);
    }

    public DynamicMap(Map<String, V> delegate, ITransformer<? super Tuple2<DynamicMap<V>, String>, ? extends V> createValue) {
        this.delegate = delegate;
        this.createValue = createValue;
    }

    protected Value<? extends V> createValue(String key) {
        return Value.fromNonNull(this.createValueNonNull(key));
    }

    protected V createValueNonNull(String key) {
        if (this.createValue == null) {
            return null;
        }
        return this.createValue.transformChecked(Tuple2.create(this, key));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        String k;
        Value<V> newValue;
        boolean res = this.handleContains(key);
        if (res) {
            return res;
        }
        if (String.class.isInstance(key) && (newValue = this.createValue(k = (String)key)).hasValue()) {
            this.delegate.put(k, newValue.getValue());
            return true;
        }
        return false;
    }

    protected boolean handleContains(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public V get(Object key) {
        if (!this.containsKey(key)) {
            return null;
        }
        return this.handleGet(key);
    }

    protected V handleGet(Object key) {
        return this.delegate.get(key);
    }

    @Override
    public V put(String key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        this.delegate.putAll(m);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.delegate.entrySet();
    }
}

