/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.util.List;
import java.util.Optional;
import net.minidev.json.JSONObject;
import org.openconcerto.ui.light.LightUIComboBox;
import org.openconcerto.ui.light.LightUIComboBoxElement;
import org.openconcerto.ui.light.LightUIComboRequest;
import org.openconcerto.utils.io.JSONConverter;

public class LightUIAutoCompleteComboBox
extends LightUIComboBox {
    private static final String FILTER = "filter";
    private String filter;
    private LightUIComboRequest request;

    public LightUIAutoCompleteComboBox() {
    }

    public LightUIAutoCompleteComboBox(String id) {
        super(id);
        this.setType(31);
    }

    public void setComboRequest(LightUIComboRequest request) {
        this.request = request;
        this.setFilter("");
        this.setAlreadyFilled(true);
    }

    public LightUIComboRequest getComboRequest() {
        return this.request;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.applyFilter();
    }

    private void applyFilter() {
        if (this.request != null) {
            Integer selectedId = null;
            if (this.hasSelectedValue()) {
                selectedId = this.getSelectedValue().getId();
            }
            this.clearValues();
            if (this.hasNotSpecifedLine()) {
                this.addValue(LightUIComboBox.getDefaultValue());
            }
            Optional<LightUIComboBoxElement> sel = Optional.ofNullable(this.hasSelectedValue() ? this.getSelectedValue() : null);
            List<LightUIComboBoxElement> items = this.request.getItems(this.filter, sel);
            for (LightUIComboBoxElement item : items) {
                this.addValue(item);
            }
            this.setSelectedId(selectedId);
        }
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put(FILTER, this.filter);
        return json;
    }

    @Override
    public void fromJSON(JSONObject json) {
        super.fromJSON(json);
        this.filter = JSONConverter.getParameterFromJSON(json, FILTER, String.class);
    }
}

