/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.view.column;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openconcerto.sql.model.FieldPath;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.utils.cc.ITransformer;

public class ColumnPanelFetcher {
    private final SQLRowValues rowValsFecth;
    private final FieldPath p;
    private final ITransformer<SQLSelect, SQLSelect> t;
    private Map<String, Integer> columns;
    private List<List<SQLRowValues>> values;

    public ColumnPanelFetcher(SQLRowValues rowVals, FieldPath p, ITransformer<SQLSelect, SQLSelect> t) {
        if (p.getPath().getFirst() != rowVals.getTable()) {
            throw new IllegalStateException("Not same start : " + p.getPath().getFirst() + " != " + rowVals.getTable());
        }
        this.rowValsFecth = rowVals;
        this.rowValsFecth.assurePath(p.getPath()).put(p.getFieldName(), null);
        this.p = p;
        this.t = t;
    }

    public synchronized List<? extends SQLRowAccessor> getRowsForColumn(int index) {
        if (this.columns == null) {
            this.getColumnName();
        }
        if (this.values == null) {
            this.fetch();
        }
        return this.values.get(index);
    }

    public synchronized void clear() {
        this.values = null;
        this.columns = null;
    }

    private void fetch() {
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(this.rowValsFecth);
        if (this.t != null) {
            fetcher.setSelTransf(this.t);
        }
        List<SQLRowValues> rowVals = fetcher.fetch();
        if (this.columns == null) {
            this.getColumnName();
        }
        ArrayList<Integer> cols = new ArrayList<Integer>(this.columns.values());
        this.values = new ArrayList<List<SQLRowValues>>();
        int size = cols.size();
        int i = 0;
        while (i < size) {
            this.values.add(new ArrayList());
            ++i;
        }
        for (SQLRowValues sqlRowValues : rowVals) {
            int index;
            SQLRowValues rowValuesStep = sqlRowValues.followPath(this.p.getPath());
            if (rowValuesStep == null || rowValuesStep.isUndefined() || (index = cols.indexOf(((SQLRowAccessor)rowValuesStep).getID())) < 0 || index >= this.values.size()) continue;
            this.values.get(index).add(sqlRowValues);
        }
    }

    public synchronized Set<SQLTable> getFecthTables() {
        Set<SQLRowValues> r = this.rowValsFecth.getGraph().getItems();
        HashSet<SQLTable> s = new HashSet<SQLTable>(r.size());
        for (SQLRowValues row : r) {
            s.add(row.getTable());
        }
        return s;
    }

    public synchronized List<String> getColumnName() {
        if (this.columns == null) {
            this.columns = new LinkedHashMap<String, Integer>();
            SQLSelect sel = new SQLSelect();
            sel.addSelectStar(this.p.getTable());
            ArrayList<SQLRow> rows = new ArrayList<SQLRow>(SQLRowListRSH.execute(sel));
            Collections.sort(rows, new Comparator<SQLRow>(){

                @Override
                public int compare(SQLRow o1, SQLRow o2) {
                    return o1.getString(ColumnPanelFetcher.this.p.getFieldName()).compareToIgnoreCase(o2.getString(ColumnPanelFetcher.this.p.getFieldName()));
                }
            });
            for (SQLRow sqlRow : rows) {
                this.columns.put(sqlRow.getString(this.p.getFieldName()), sqlRow.getID());
            }
        }
        return new ArrayList<String>(this.columns.keySet());
    }

    public synchronized int getColumnCount() {
        if (this.columns == null) {
            this.getColumnName();
        }
        return this.columns.size();
    }
}

