/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.order.element;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.openconcerto.erp.core.common.element.NumerotationAutoSQLElement;
import org.openconcerto.erp.core.finance.tax.model.TaxeCache;
import org.openconcerto.erp.core.supplychain.stock.element.StockItemsUpdater;
import org.openconcerto.erp.core.supplychain.stock.element.StockLabel;
import org.openconcerto.erp.generationEcritures.GenerationMvtSaisieVenteFacture;
import org.openconcerto.erp.preferences.GestionArticleGlobalPreferencePanel;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.IResultSetHandler;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLInjector;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.preferences.SQLPreferences;
import org.openconcerto.utils.ExceptionHandler;

public class TransfertCommandeAutoUtils {
    private final SQLTable table;

    public TransfertCommandeAutoUtils(SQLTable tableCmd) {
        this.table = tableCmd;
    }

    public SQLTable getTable() {
        return this.table;
    }

    public void transfertMultiBL(List<SQLRowValues> cmds) {
        Date toDay = new Date();
        for (SQLRowValues sqlRowValues : cmds) {
            try {
                this.transfertBL(toDay, sqlRowValues);
            }
            catch (Exception e) {
                ExceptionHandler.handle("Erreur lors du transfert en bl!", e);
            }
        }
    }

    public SQLRow transfertBL(Date dateTransfert, SQLRowValues sqlRowCmd) throws Exception {
        SQLInjector inj = SQLInjector.getInjector(this.getTable(), this.getTable().getTable("BON_DE_LIVRAISON"));
        SQLRowValues rowValuesBL = inj.createRowValuesFrom(sqlRowCmd.asRow());
        SQLTable referentTable = this.getTable().getTable("BON_DE_LIVRAISON_ELEMENT");
        Collection<SQLRowValues> refs = rowValuesBL.getReferentRows(referentTable);
        for (SQLRowValues refRow : refs) {
            refRow.put("QTE_LIVREE", refRow.getObject("QTE"));
        }
        rowValuesBL.put("DATE", dateTransfert);
        rowValuesBL.put("NUMERO", this.getNextNumero(rowValuesBL.getTable(), Configuration.getInstance().getDirectory().getElement(rowValuesBL.getTable()).getClass(), dateTransfert));
        rowValuesBL.put("TOTAL_HT", sqlRowCmd.getObject("T_HT"));
        rowValuesBL.put("TOTAL_TVA", sqlRowCmd.getObject("T_TVA"));
        rowValuesBL.put("TOTAL_TTC", sqlRowCmd.getObject("T_TTC"));
        SQLRow row = rowValuesBL.commit();
        inj.commitTransfert(Arrays.asList(sqlRowCmd), row.getID());
        this.updateStock(row, referentTable, "Bon de livraison N\u00b0");
        return row;
    }

    public void transfertFacture(List<SQLRowValues> cmds) {
        for (SQLRowValues sqlRowValues : cmds) {
            SQLInjector inj = SQLInjector.getInjector(this.getTable(), this.getTable().getTable("SAISIE_VENTE_FACTURE"));
            SQLRowValues rowValuesfacture = inj.createRowValuesFrom(sqlRowValues.asRow());
            try {
                SQLRowValues rowVals = new SQLRowValues(this.getTable().getTable("MODE_REGLEMENT"));
                rowVals.put("ID_TYPE_REGLEMENT", 7);
                rowVals.put("DATE_FACTURE", Boolean.TRUE);
                rowVals.put("COMPTANT", Boolean.FALSE);
                rowVals.put("FIN_MOIS", Boolean.FALSE);
                rowVals.put("LENJOUR", 0);
                rowVals.put("AJOURS", 0);
                rowValuesfacture.put("ID_MODE_REGLEMENT", (Object)rowVals);
                rowValuesfacture.put("ID_COMMERCIAL", sqlRowValues.getForeignID("ID_COMMERCIAL"));
                rowValuesfacture.put("DATE", sqlRowValues.getObject("DATE"));
                rowValuesfacture.put("NUMERO", this.getNextNumero(rowValuesfacture.getTable(), Configuration.getInstance().getDirectory().getElement(rowValuesfacture.getTable()).getClass(), sqlRowValues.getDate("DATE").getTime()));
                if (this.getTable().contains("ID_TAXE_PORT")) {
                    SQLRow taxeDefault = TaxeCache.getCache().getFirstTaxe();
                    rowValuesfacture.put("ID_TAXE_PORT", taxeDefault.getID());
                }
                rowValuesfacture.put("T_HT", sqlRowValues.getObject("T_HT"));
                rowValuesfacture.put("T_TVA", sqlRowValues.getObject("T_TVA"));
                rowValuesfacture.put("T_TTC", sqlRowValues.getObject("T_TTC"));
                SQLRow row = rowValuesfacture.commit();
                inj.commitTransfert(Arrays.asList(sqlRowValues), row.getID());
                new GenerationMvtSaisieVenteFacture(row.getID());
                this.updateStock(row, this.getTable().getTable("SAISIE_VENTE_FACTURE_ELEMENT"), "Facture N\u00b0");
            }
            catch (Exception e) {
                ExceptionHandler.handle("Erreur lors du transfert en facture!", e);
            }
        }
    }

    private String getNextNumero(SQLTable table, Class<? extends SQLElement> element, Date toDay) throws IllegalStateException {
        SQLTable tableNum = this.getTable().getTable("NUMEROTATION_AUTO");
        String num = NumerotationAutoSQLElement.getNextNumero(element, toDay);
        SQLSelect selNum = new SQLSelect();
        selNum.addSelect(table.getKey(), "COUNT");
        Where w = new Where((FieldRef)table.getField("NUMERO"), "=", (Object)num);
        selNum.setWhere(w);
        String req = selNum.asString();
        Number l = (Number)this.getTable().getBase().getDataSource().execute(req, new IResultSetHandler(SQLDataSource.SCALAR_HANDLER, false));
        if (l.intValue() <= 0) {
            SQLRow rowNum = tableNum.getRow(2);
            SQLRowValues rowValsNum = rowNum.createEmptyUpdateRow();
            String labelNumberFor = NumerotationAutoSQLElement.getLabelNumberFor(element);
            int val = rowNum.getInt(labelNumberFor);
            rowValsNum.put(labelNumberFor, (Object)(++val));
            try {
                rowValsNum.update();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalStateException("La num\u00e9ratotation automatique n'est pas correcte! Un num\u00e9ro existant est retourn\u00e9!");
        }
        return num;
    }

    private void updateStock(SQLRow row, SQLTable referentTable, final String labelPrefix) throws SQLException {
        SQLPreferences prefs = new SQLPreferences(this.getTable().getDBRoot());
        boolean stockOnFacture = prefs.getBoolean(GestionArticleGlobalPreferencePanel.STOCK_FACT, true);
        if (row.getTable().getName().equals("BON_DE_LIVRAISON") && !stockOnFacture || row.getTable().getName().equals("SAISIE_VENTE_FACTURE") && stockOnFacture) {
            StockItemsUpdater stockUpdater = new StockItemsUpdater(new StockLabel(){

                @Override
                public String getLabel(SQLRowAccessor rowOrigin, SQLRowAccessor rowElt) {
                    return String.valueOf(labelPrefix) + rowOrigin.getString("NUMERO");
                }
            }, row, (List<? extends SQLRowAccessor>)row.getReferentRows(referentTable), StockItemsUpdater.TypeStockUpdate.REAL_DELIVER);
            stockUpdater.update();
        }
    }
}

