/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.finance.accounting.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.finance.accounting.element.ComptePCESQLElement;
import org.openconcerto.erp.core.finance.accounting.element.EcritureSQLElement;
import org.openconcerto.erp.core.finance.accounting.model.SommeCompte;
import org.openconcerto.erp.element.objet.Compte;
import org.openconcerto.erp.generationEcritures.GenerationMvtVirement;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.JLabelBold;
import org.openconcerto.utils.ExceptionHandler;

public class ClotureSansAnouveauxPanel
extends JPanel {
    private final JDate dateOuv = new JDate();
    private final JDate dateFerm = new JDate();
    private SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
    private final SQLTable societe = Configuration.getInstance().getBase().getTable("SOCIETE_COMMON");
    private final SQLTable exercice = Configuration.getInstance().getBase().getTable("EXERCICE_COMMON");
    private final SQLRow rowSociete = ((ComptaPropsConfiguration)Configuration.getInstance()).getRowSociete();
    private final Map<Object, Long> mRAN = new HashMap<Object, Long>();
    private JButton valider = new JButton("Valider");
    private JButton annul = new JButton("Annuler");
    private final DateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
    private JLabel opEnCours = new JLabel("Etat: en attente de validation");
    private JCheckBox boxValid = new JCheckBox("Je confirme avoir effectu\u00e9 toutes les op\u00e9rations n\u00e9cessaires.");
    private JProgressBar bar = new JProgressBar(0, 4);
    private final SQLTable tablePrefCompte = this.base.getTable("PREFS_COMPTE");

    public ClotureSansAnouveauxPanel() {
        this.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.fill = 2;
        c.anchor = 17;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        JLabelBold rappel = new JLabelBold("Op\u00e9rations \u00e0 effectuer avant de continuer: ");
        JLabel label = new JLabel("- report des charges et produits constat\u00e9s d'avance");
        JLabel label2 = new JLabel("- report des charges \u00e0 payer et produits \u00e0 recevoir");
        JLabel label3 = new JLabel("- impression du bilan, compte de r\u00e9sultat, grand livre, journaux et balance");
        JLabel label5 = new JLabel("- g\u00e9n\u00e9ration les \u00e9critures comptables des payes");
        JLabel label4 = new JLabel("Il est pr\u00e9f\u00e9rable de r\u00e9aliser une sauvegarde avant de continuer.");
        JLabelBold op = new JLabelBold("Op\u00e9rations qui vont etre effectu\u00e9es: ");
        JLabel labelValid = new JLabel("- validation de toutes les \u00e9critures concernant la p\u00e9riode de l'exercice.");
        JLabel labelSoldeGestion = new JLabel("- soldes de tous les comptes de gestions 6* et 7*");
        JLabel labelSoldeBilan = new JLabel("- soldes de tous les comptes de bilan");
        JLabel labelAN = new JLabel("- report des \u00e0 nouveaux");
        c.gridy = -1;
        c.gridx = 0;
        c.insets = new Insets(10, 2, 1, 2);
        this.add((Component)rappel, c);
        this.add((Component)label, c);
        this.add((Component)label2, c);
        this.add((Component)label3, c);
        this.add((Component)label5, c);
        this.add((Component)label4, c);
        c.insets = new Insets(15, 2, 1, 2);
        this.add((Component)op, c);
        c.insets = new Insets(10, 2, 1, 2);
        this.add((Component)labelValid, c);
        this.add((Component)labelSoldeGestion, c);
        this.add((Component)labelSoldeBilan, c);
        this.add((Component)labelAN, c);
        c.gridwidth = 1;
        c.gridy = -1;
        c.gridx = 0;
        c.gridx = -1;
        c.fill = 0;
        this.add((Component)new JLabel("Date du nouvel exercice du "), c);
        this.add((Component)this.dateOuv, c);
        this.add((Component)new JLabel("au"), c);
        this.add((Component)this.dateFerm, c);
        c.gridx = 0;
        c.fill = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.add((Component)this.opEnCours, c);
        c.gridwidth = 4;
        c.gridx = 0;
        c.weightx = 1.0;
        this.add((Component)this.bar, c);
        this.add((Component)this.boxValid, c);
        JPanel buttonBar = new JPanel();
        buttonBar.add(this.valider);
        buttonBar.add(this.annul);
        c.fill = 0;
        c.anchor = 13;
        c.gridx = 0;
        this.add((Component)buttonBar, c);
        PropertyChangeListener listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ClotureSansAnouveauxPanel.this.valider.setEnabled(ClotureSansAnouveauxPanel.this.isDateValid());
            }
        };
        this.valider.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClotureSansAnouveauxPanel.this.valider.setEnabled(false);
                ClotureSansAnouveauxPanel.this.dateFerm.setEnabled(false);
                ClotureSansAnouveauxPanel.this.dateOuv.setEnabled(false);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ClotureSansAnouveauxPanel.this.clotureExercice();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    Component comp = SwingUtilities.getRoot(ClotureSansAnouveauxPanel.this);
                                    JOptionPane.showMessageDialog(ClotureSansAnouveauxPanel.this, "Exercice cl\u00f4tur\u00e9", "Fin de la cl\u00f4ture", 1);
                                    if (comp != null) {
                                        ((JFrame)comp).dispose();
                                    }
                                }
                            });
                        }
                        catch (Exception ex) {
                            ExceptionHandler.handle("Erreur lors de la cl\u00f4ture", ex);
                        }
                    }
                }).start();
            }
        });
        this.boxValid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ClotureSansAnouveauxPanel.this.valider.setEnabled(ClotureSansAnouveauxPanel.this.isDateValid());
            }
        });
        this.annul.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((JFrame)SwingUtilities.getRoot(ClotureSansAnouveauxPanel.this)).dispose();
            }
        });
    }

    private boolean isDateValid() {
        return true;
    }

    private void clotureExercice() throws SQLException {
        SQLRow rowPrefCompte = this.tablePrefCompte.getRow(2);
        if (rowPrefCompte.getInt("ID_COMPTE_PCE_BILAN_O") <= 1) {
            int id_Compte_Bilan_Ouverture = ComptePCESQLElement.getId("890");
        } else {
            int id_Compte_Bilan_Ouverture = rowPrefCompte.getInt("ID_COMPTE_PCE_BILAN_O");
        }
        final int id_Compte_Bilan_Cloture = rowPrefCompte.getInt("ID_COMPTE_PCE_BILAN_F") <= 1 ? ComptePCESQLElement.getId("891") : rowPrefCompte.getInt("ID_COMPTE_PCE_BILAN_F");
        SQLUtils.executeAtomic(this.tablePrefCompte.getDBSystemRoot().getDataSource(), new SQLUtils.SQLFactory<Object>(){

            @Override
            public Object create() throws SQLException {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ClotureSansAnouveauxPanel.this.opEnCours.setText("En cours: solde des comptes 6 et 7");
                    }
                });
                long time = new Date().getTime();
                System.err.println("Start :: " + time);
                ClotureSansAnouveauxPanel.this.soldeCompte(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ClotureSansAnouveauxPanel.this.opEnCours.setText("En cours: solde des comptes autres que 6 et 7");
                        ClotureSansAnouveauxPanel.this.bar.setValue(1);
                    }
                });
                ClotureSansAnouveauxPanel.this.soldeCompte(true);
                long time2 = new Date().getTime();
                System.err.println("Stop :: " + time2);
                System.err.println("Time :: " + (time2 - time));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ClotureSansAnouveauxPanel.this.opEnCours.setText("En cours: report des \u00e0 nouveaux");
                        ClotureSansAnouveauxPanel.this.bar.setValue(2);
                    }
                });
                SQLTable ecritureTable = ClotureSansAnouveauxPanel.this.base.getTable("ECRITURE");
                SQLTable compteTable = ClotureSansAnouveauxPanel.this.base.getTable("COMPTE_PCE");
                SQLSelect sel = new SQLSelect(ClotureSansAnouveauxPanel.this.base);
                sel.addSelect(compteTable.getKey());
                sel.addSelect(compteTable.getField("NUMERO"));
                sel.addSelect(compteTable.getField("NOM"));
                sel.addSelect(ecritureTable.getField("DEBIT"), "SUM");
                sel.addSelect(ecritureTable.getField("CREDIT"), "SUM");
                Where w = new Where((FieldRef)ecritureTable.getField("ID_COMPTE_PCE"), "=", id_Compte_Bilan_Cloture);
                w = w.and(new Where((FieldRef)ecritureTable.getField("ID_COMPTE_PCE"), "=", compteTable.getKey()));
                sel.setWhere(w);
                String req = String.valueOf(sel.asString()) + " GROUP BY \"COMPTE_PCE\".\"ID\", \"COMPTE_PCE\".\"NUMERO\", \"COMPTE_PCE\".\"NOM\" ORDER BY \"COMPTE_PCE\".\"NUMERO\"";
                System.out.println(req);
                Object ob = ClotureSansAnouveauxPanel.this.base.getDataSource().execute(req, new ArrayListHandler());
                List myList = (List)ob;
                if (myList.size() != 0) {
                    GenerationMvtVirement gen = new GenerationMvtVirement(1, id_Compte_Bilan_Cloture, 0L, 0L, "Fermeture du compte ", ClotureSansAnouveauxPanel.this.dateFerm.getDate(), 6, "Fermeture des comptes");
                    int i = 0;
                    while (i < myList.size()) {
                        Object[] objTmp = (Object[])myList.get(i);
                        Compte cptTmp = new Compte(((Number)objTmp[0]).intValue(), objTmp[1].toString(), objTmp[2].toString(), "", ((Number)objTmp[3]).longValue(), ((Number)objTmp[4]).longValue());
                        long solde = cptTmp.getTotalDebit() - cptTmp.getTotalCredit();
                        if (solde != 0L) {
                            if (solde > 0L) {
                                gen.setValues(cptTmp.getId(), id_Compte_Bilan_Cloture, 0L, Math.abs(solde), "Fermeture du compte " + cptTmp.getNumero(), ClotureSansAnouveauxPanel.this.dateFerm.getDate(), 6, false);
                            } else {
                                gen.setValues(cptTmp.getId(), id_Compte_Bilan_Cloture, Math.abs(solde), 0L, "Fermeture du compte " + cptTmp.getNumero(), ClotureSansAnouveauxPanel.this.dateFerm.getDate(), 6, false);
                            }
                            gen.genereMouvement();
                        }
                        ++i;
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ClotureSansAnouveauxPanel.this.opEnCours.setText("En cours: validation des \u00e9critures de l'exercice");
                        ClotureSansAnouveauxPanel.this.bar.setValue(3);
                    }
                });
                EcritureSQLElement.validationEcrituresBefore(ClotureSansAnouveauxPanel.this.dateFerm.getDate(), true);
                return null;
            }
        });
    }

    private void soldeCompte(boolean compteBilan) throws SQLException {
        int compteDest;
        String typeCompte;
        SQLRow rowPrefCompte = this.tablePrefCompte.getRow(2);
        if (compteBilan) {
            typeCompte = "^[^6-8].*$";
            compteDest = rowPrefCompte.getInt("ID_COMPTE_PCE_BILAN_F");
            if (compteDest <= 1) {
                compteDest = ComptePCESQLElement.getId("891", "Bilan de cl\u00f4ture");
            }
        } else {
            SommeCompte s = new SommeCompte();
            long solde6 = s.soldeCompte(6, 6, true, this.dateOuv.getDate(), this.dateFerm.getDate());
            long solde7 = s.soldeCompte(7, 7, true, this.dateOuv.getDate(), this.dateFerm.getDate());
            long resultat = -solde7 - solde6;
            System.err.println("Solde R\u00e9sultat :::: " + solde7 + " __ " + solde6 + "__" + (solde7 - solde6));
            typeCompte = "^(6|7).*$";
            compteDest = resultat > 0L ? rowPrefCompte.getInt("ID_COMPTE_PCE_RESULTAT") : rowPrefCompte.getInt("ID_COMPTE_PCE_RESULTAT_PERTE");
            if (compteDest <= 1) {
                compteDest = resultat > 0L ? ComptePCESQLElement.getId("120", "R\u00e9sultat de l'exercice (b\u00e9n\u00e9fice)") : ComptePCESQLElement.getId("129", "R\u00e9sultat de l'exercice (perte)");
            }
        }
        SQLTable ecritureTable = this.base.getTable("ECRITURE");
        SQLTable compteTable = this.base.getTable("COMPTE_PCE");
        SQLSelect sel = new SQLSelect(this.base);
        sel.addSelect(compteTable.getKey());
        sel.addSelect(compteTable.getField("NUMERO"));
        sel.addSelect(compteTable.getField("NOM"));
        sel.addSelect(ecritureTable.getField("DEBIT"), "SUM");
        sel.addSelect(ecritureTable.getField("CREDIT"), "SUM");
        Where w = new Where((FieldRef)ecritureTable.getField("ID_COMPTE_PCE"), "=", compteTable.getKey());
        String function = "REGEXP";
        if (Configuration.getInstance().getBase().getServer().getSQLSystem() == SQLSystem.POSTGRESQL) {
            function = "~";
        }
        Where w2 = new Where((FieldRef)compteTable.getField("NUMERO"), function, (Object)typeCompte);
        Where w3 = new Where((FieldRef)ecritureTable.getField("DATE"), "<=", (Object)this.dateFerm.getDate());
        sel.setWhere(w.and(w2).and(w3));
        String req = String.valueOf(sel.asString()) + " GROUP BY \"COMPTE_PCE\".\"ID\", \"COMPTE_PCE\".\"NUMERO\", \"COMPTE_PCE\".\"NOM\" ORDER BY \"COMPTE_PCE\".\"NUMERO\"";
        System.err.println(req);
        Object ob = this.base.getDataSource().execute(req, new ArrayListHandler());
        List myList = (List)ob;
        if (myList != null && myList.size() != 0) {
            GenerationMvtVirement genFerm = new GenerationMvtVirement(1, compteDest, 0L, 0L, "Fermeture du compte ", this.dateFerm.getDate(), 6, "Fermeture des comptes");
            int i = 0;
            while (i < myList.size()) {
                Object[] objTmp = (Object[])myList.get(i);
                Compte cptTmp = new Compte(((Number)objTmp[0]).intValue(), objTmp[1].toString(), objTmp[2].toString(), "", ((Number)objTmp[3]).longValue(), ((Number)objTmp[4]).longValue());
                long solde = cptTmp.getTotalDebit() - cptTmp.getTotalCredit();
                if (compteBilan) {
                    this.mRAN.put(objTmp[0], solde);
                }
                if (solde > 0L) {
                    genFerm.setValues(cptTmp.getId(), compteDest, 0L, Math.abs(solde), "Fermeture du compte " + cptTmp.getNumero(), this.dateFerm.getDate(), 6, false);
                } else {
                    genFerm.setValues(cptTmp.getId(), compteDest, Math.abs(solde), 0L, "Fermeture du compte " + cptTmp.getNumero(), this.dateFerm.getDate(), 6, false);
                }
                genFerm.genereMouvement();
                ++i;
            }
        }
    }
}

