/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.valuewrapper.format;

import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.JTextComponent;
import org.openconcerto.ui.component.IDocument;
import org.openconcerto.ui.component.text.DocumentComponent;
import org.openconcerto.ui.filters.FormatFilter;
import org.openconcerto.ui.valuewrapper.format.FormatValueWrapper;
import org.openconcerto.utils.text.DocumentFilterList;
import org.openconcerto.utils.text.SimpleDocumentListener;

public final class FilterFormatValueWrapper<T>
extends FormatValueWrapper<T> {
    private final IDocument doc;

    public FilterFormatValueWrapper(JTextComponent b, Class<T> c) {
        this((JComponent)b, (AbstractDocument)b.getDocument(), c);
    }

    public FilterFormatValueWrapper(JTextComponent b, Class<T> c, FormatFilter<? super T> ff) {
        this(b, (AbstractDocument)b.getDocument(), c, ff);
    }

    public FilterFormatValueWrapper(DocumentComponent b, Class<T> c) {
        this(b.getComp(), (AbstractDocument)b.getDocument(), c);
    }

    FilterFormatValueWrapper(JComponent b, AbstractDocument doc, Class<T> c) {
        this(b, doc, c, FormatFilter.create(c));
    }

    FilterFormatValueWrapper(JComponent b, AbstractDocument doc, Class<T> c, FormatFilter<? super T> ff) {
        super(b, ff, c);
        this.doc = new IDocument(doc);
        doc.addDocumentListener(new SimpleDocumentListener(){

            @Override
            public void update(DocumentEvent e) {
                FilterFormatValueWrapper.this.textChanged();
            }
        });
        DocumentFilterList.add(doc, ff, DocumentFilterList.FilterType.SIMPLE_FILTER);
        this.textChanged();
    }

    @Override
    protected String getText() {
        return this.doc.getText();
    }

    @Override
    protected void setText(String s) {
        this.doc.setText(s);
    }
}

