/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.light;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import org.openconcerto.utils.io.JSONAble;

public class RowSpec
implements Externalizable,
JSONAble {
    private static final String KEY_COLUMN_IDS = "column-ids";
    private static final String KEY_TABLE_ID = "table-id";
    private static final String KEY_CLASS = "class";
    private String tableId;
    private String[] columnIds;

    public RowSpec() {
    }

    public RowSpec(JSONObject json) {
        this.fromJSON(json);
    }

    public RowSpec(String tableId, String[] columnIds) {
        this.tableId = tableId;
        this.columnIds = columnIds;
    }

    public String[] getIds() {
        return this.columnIds;
    }

    public void setIds(String[] columnIds) {
        this.columnIds = columnIds;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public String getTableId() {
        return this.tableId;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RowSpec:");
        b.append(this.tableId);
        b.append(" : ");
        int length = this.columnIds.length;
        int i = 0;
        while (i < length) {
            b.append(this.columnIds[i]);
            if (i < length - 1) {
                b.append(", ");
            }
            ++i;
        }
        return b.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.tableId);
        out.writeObject(this.columnIds);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tableId = in.readUTF();
        this.columnIds = (String[])in.readObject();
    }

    @Override
    public JSONObject toJSON() {
        JSONObject result = new JSONObject();
        result.put(KEY_CLASS, "RowSpec");
        result.put(KEY_TABLE_ID, this.tableId);
        result.put(KEY_COLUMN_IDS, this.columnIds);
        return result;
    }

    @Override
    public void fromJSON(JSONObject json) {
        this.tableId = (String)json.get(KEY_TABLE_ID);
        JSONArray jsonColumnIds = (JSONArray)json.get(KEY_COLUMN_IDS);
        if (!json.containsKey(KEY_COLUMN_IDS) || json.get(KEY_COLUMN_IDS) instanceof JSONArray) {
            throw new IllegalArgumentException("value for 'value-type' not found or invalid");
        }
        if (!json.containsKey(KEY_TABLE_ID) || json.get(KEY_TABLE_ID) instanceof String) {
            throw new IllegalArgumentException("value for 'value-type' not found or invalid");
        }
        int columnCount = jsonColumnIds.size();
        this.columnIds = new String[columnCount];
        int i = 0;
        while (i < columnCount) {
            Object jsonColumnId = jsonColumnIds.get(i);
            if (!(jsonColumnId instanceof String)) {
                throw new IllegalArgumentException("one or more column Ids are invalid in 'column-ids'");
            }
            this.columnIds[i] = (String)jsonColumnId;
            ++i;
        }
    }
}

