/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.utils.correct;

import java.sql.SQLException;
import org.openconcerto.sql.changer.Changer;
import org.openconcerto.sql.model.AliasedField;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSelectJoin;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;

public class FillClotureTotal
extends Changer<DBRoot> {
    public FillClotureTotal(DBSystemRoot b) {
        super(b);
    }

    @Override
    protected void changeImpl(DBRoot root) throws SQLException {
        SQLTable closureT = root.getTable("CAISSE_CLOTURE");
        SQLField closureTotalField = closureT.getField("TOTAL_TTC");
        SQLTable receiptT = root.getTable("TICKET_CAISSE");
        String receiptTotal = "receiptTotal";
        SQLSelect selTotal = new SQLSelect();
        selTotal.addFrom(closureT);
        SQLSelectJoin join = selTotal.addJoin("INNER", Where.between(receiptT.getField("NUMERO"), closureT.getField("PREMIER_TICKET"), closureT.getField("DERNIER_TICKET")));
        selTotal.addSelect(closureT.getKey());
        selTotal.addSelect(join.getJoinedTable().getField("TOTAL_TTC"), "sum", "receiptTotal");
        selTotal.addGroupBy(closureT.getKey());
        UpdateBuilder upd = new UpdateBuilder(closureT);
        String alias = "totals";
        upd.addTable(selTotal, "totals");
        upd.setWhere(new Where((FieldRef)closureTotalField, "=", 0).and(new Where((FieldRef)closureT.getKey(), "=", new AliasedField(closureT.getKey(), "totals"))));
        upd.set(closureTotalField.getName(), String.valueOf(new SQLName("totals", "receiptTotal").quote()) + " / 100");
        this.getDS().execute(upd.asString());
        upd.getTable().fireTableModified(-1);
    }
}

