/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.model;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.commons.dbutils.handlers.ArrayListHandler;
import org.openconcerto.erp.core.humanresources.payroll.component.VariableRowTreeNode;
import org.openconcerto.erp.model.FamilleTreeNode;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.SQLTableListener;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.ui.FontUtils;

public class FamilleArticleTree
extends JTree
implements MouseListener {
    private final DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Toutes");
    private final DefaultTreeModel model = new DefaultTreeModel(this.rootNode, false);
    private final SQLElement familleElt = Configuration.getInstance().getDirectory().getElement("FAMILLE_ARTICLE");
    private Map<Integer, DefaultMutableTreeNode> mapNode = new HashMap<Integer, DefaultMutableTreeNode>();

    public FamilleArticleTree() {
        this.setModel(this.model);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        this.setCellRenderer(renderer);
        this.loadTree();
        this.addMouseListener(this);
        this.setTableListener();
        this.setDragEnabled(true);
        this.setRowHeight(FontUtils.getPreferredRowHeight(this));
    }

    private void loadTree() {
        SQLSelect sel = new SQLSelect(this.familleElt.getTable().getBase());
        sel.addSelect(this.familleElt.getTable().getField("ID"));
        sel.addSelect(this.familleElt.getTable().getField("ID_FAMILLE_ARTICLE_PERE"));
        List l = (List)this.familleElt.getTable().getBase().getDataSource().execute(sel.asString(), new ArrayListHandler());
        if (l != null) {
            int i = 0;
            while (i < l.size()) {
                Object[] tmp = (Object[])l.get(i);
                this.addFamille(((Number)tmp[0]).intValue(), ((Number)tmp[1]).intValue());
                ++i;
            }
        }
    }

    private void addFamille(int id, int idPere) {
        DefaultMutableTreeNode nodePere = this.mapNode.get(idPere);
        SQLRow row = this.familleElt.getTable().getRow(id);
        FamilleTreeNode newNode = new FamilleTreeNode(row);
        this.mapNode.put(id, newNode);
        if (id > 1) {
            if (nodePere != null && idPere > 1) {
                this.addNode(newNode, nodePere);
            } else {
                this.addNode(newNode, this.rootNode);
            }
        }
    }

    private void addNode(FamilleTreeNode nodeToAdd, MutableTreeNode nodeParent) {
        int n = 0;
        while (n < nodeParent.getChildCount()) {
            if (nodeToAdd.toString().compareToIgnoreCase(nodeParent.getChildAt(n).toString()) < 0) break;
            ++n;
        }
        this.model.insertNodeInto(nodeToAdd, nodeParent, n);
    }

    private void modifyNode(SQLRow row, MutableTreeNode nodeParent) {
        int i = 0;
        while (i < nodeParent.getChildCount()) {
            VariableRowTreeNode v;
            TreeNode o = nodeParent.getChildAt(i);
            if (o instanceof VariableRowTreeNode && (v = (VariableRowTreeNode)o).getID() == row.getID()) {
                v.setRow(row);
                this.model.nodeChanged(v);
            }
            ++i;
        }
    }

    private void setTableListener() {
        SQLTableListener listener = new SQLTableListener(){

            @Override
            public void rowModified(SQLTable table, int id) {
                System.err.println("row modified --> " + table.getName() + ", " + id);
                MutableTreeNode node = (MutableTreeNode)FamilleArticleTree.this.mapNode.get(id);
                if (node != null && node instanceof FamilleTreeNode) {
                    FamilleArticleTree.this.modifyNode(table.getRow(id), node);
                }
            }

            @Override
            public void rowAdded(SQLTable table, int id) {
                System.err.println("row added --> " + table.getName() + ", " + id);
                SQLRow row = table.getRow(id);
                int idPere = row.getInt("ID_FAMILLE_ARTICLE_PERE");
                FamilleArticleTree.this.addFamille(id, idPere);
            }

            @Override
            public void rowDeleted(SQLTable table, int id) {
                System.err.println("row deleted --> " + table.getName() + ", " + id);
                MutableTreeNode node = (MutableTreeNode)FamilleArticleTree.this.mapNode.get(id);
                int i = 0;
                while (i < node.getChildCount()) {
                    FamilleArticleTree.this.removeNode(table.getRow(id), node);
                    ++i;
                }
            }
        };
        this.familleElt.getTable().addTableListener(listener);
    }

    private void removeNode(SQLRow row, MutableTreeNode nodeParent) {
        int i = 0;
        while (i < nodeParent.getChildCount()) {
            FamilleTreeNode v;
            TreeNode o = nodeParent.getChildAt(i);
            if (o instanceof FamilleTreeNode && (v = (FamilleTreeNode)o).getId() == row.getID()) {
                this.model.removeNodeFromParent(v);
            }
            ++i;
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Object o = this.getSelectionPath().getLastPathComponent();
        int id = 1;
        if (e.getButton() == 3) {
            if (o instanceof FamilleTreeNode) {
                FamilleTreeNode nodeSelect = (FamilleTreeNode)o;
                id = nodeSelect.getId();
            }
            final int idSelect = id;
            JPopupMenu menu = new JPopupMenu();
            menu.add(new AbstractAction("Ajouter une famille"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EditFrame frameAddFamille = new EditFrame(FamilleArticleTree.this.familleElt, EditFrame.CREATION);
                    SQLRowValues rowVals = new SQLRowValues(FamilleArticleTree.this.familleElt.getTable());
                    rowVals.put("ID_FAMILLE_ARTICLE_PERE", idSelect);
                    frameAddFamille.getSQLComponent().select(rowVals);
                    frameAddFamille.setVisible(true);
                }
            });
            if (idSelect > 1) {
                menu.add(new AbstractAction("Modifier"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EditFrame frameModFamille = new EditFrame(FamilleArticleTree.this.familleElt, EditFrame.MODIFICATION);
                        frameModFamille.selectionId(idSelect, 1);
                        frameModFamille.setVisible(true);
                    }
                });
                menu.add(new AbstractAction("Supprimer"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            FamilleArticleTree.this.familleElt.archive(idSelect);
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                });
            }
            menu.show(e.getComponent(), e.getPoint().x, e.getPoint().y);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

