/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.openconcerto.erp.core.common.ui.Acompte;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.erp.generationDoc.provider.UserInitialsValueProvider;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.utils.GestionDevise;

public class RemiseProvider
extends UserInitialsValueProvider {
    public final TypeAffichage type;

    public RemiseProvider(TypeAffichage t) {
        this.type = t;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        BigDecimal montant = row.getBigDecimal("MONTANT_REMISE");
        BigDecimal remise = (BigDecimal)row.getObject("POURCENT_REMISE");
        Acompte a = new Acompte(remise, montant);
        if (a == null) {
            return null;
        }
        if (a.getPercent() != null) {
            return String.valueOf(a.getPercent().setScale(2, RoundingMode.HALF_UP).toString()) + "%";
        }
        if (montant != null) {
            return GestionDevise.currencyToString(montant);
        }
        return "";
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("remise.global", new RemiseProvider(TypeAffichage.GLOBAL));
        SpreadSheetCellValueProviderManager.put("remise.line", new RemiseProvider(TypeAffichage.LIGNE));
        SpreadSheetCellValueProviderManager.put("remise", new RemiseProvider(TypeAffichage.NORMAL));
    }

    public static enum TypeAffichage {
        GLOBAL,
        LIGNE,
        NORMAL;

    }
}

