/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.report;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.openconcerto.erp.generationDoc.AbstractListeSheetXml;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.utils.cc.ITransformer;

public class ReportingClientXml
extends AbstractListeSheetXml {
    public static final String TEMPLATE_ID = "ReportingClient";
    public static final String TEMPLATE_PROPERTY_NAME = "Default";
    private final Calendar toDay = Calendar.getInstance();
    private final Date d1;
    private final Date d2;
    private DateFormat format;

    public ReportingClientXml(SQLRow rowClient, Date d1, Date d2) {
        super(rowClient);
        this.d1 = d1;
        this.d2 = d2;
    }

    @Override
    protected void createListeValues() {
        SQLTable table = Configuration.getInstance().getDirectory().getElement("CLIENT").getTable();
        SQLRowValues rowVals = new SQLRowValues(table);
        rowVals.putNulls("NOM");
        final SQLTable tableFacture = Configuration.getInstance().getDirectory().getElement("SAISIE_VENTE_FACTURE").getTable();
        SQLRowValues rowValsF = new SQLRowValues(tableFacture);
        rowValsF.put("ID_CLIENT", (Object)rowVals);
        rowValsF.putNulls("NUMERO", "NOM", "T_HT", "T_TTC", "DATE", "INFOS");
        SQLTable tableEch = Configuration.getInstance().getDirectory().getElement("ECHEANCE_CLIENT").getTable();
        SQLRowValues rowValsE = new SQLRowValues(tableEch);
        rowValsE.put("ID_SAISIE_VENTE_FACTURE", (Object)rowValsF);
        rowValsE.putNulls("REGLE", "DATE", "MONTANT", "REG_COMPTA", "DATE_LAST_RELANCE");
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(rowValsF);
        fetcher.setSelTransf(new ITransformer<SQLSelect, SQLSelect>(){

            @Override
            public SQLSelect transformChecked(SQLSelect input) {
                Where w = new Where((FieldRef)tableFacture.getField("ID_CLIENT"), "=", ReportingClientXml.this.row.getID());
                if (ReportingClientXml.this.d1 != null || ReportingClientXml.this.d2 != null) {
                    w = ReportingClientXml.this.d1 == null ? w.and(new Where((FieldRef)tableFacture.getField("DATE"), "<=", (Object)ReportingClientXml.this.d2)) : (ReportingClientXml.this.d2 == null ? w.and(new Where((FieldRef)tableFacture.getField("DATE"), ">=", (Object)ReportingClientXml.this.d1)) : w.and(new Where((FieldRef)tableFacture.getField("DATE"), ReportingClientXml.this.d1, (Object)ReportingClientXml.this.d2)));
                }
                input.setWhere(w);
                return input;
            }
        });
        List<SQLRowValues> l = fetcher.fetch();
        this.mapAllSheetValues = new HashMap();
        HashMap<String, Object> mapValues = new HashMap<String, Object>();
        mapValues.put("CLIENT", this.row.getString("NOM"));
        mapValues.put("DATE", this.toDay.getTime());
        String upTo = "Invoices up to ";
        String since = "Invoices since ";
        String between = "Invoices between ";
        String and = " and ";
        if (this.row.getObject("ID_LANGUE") != null && this.row.getInt("ID_LANGUE") == 2) {
            upTo = "Factures jusqu'au ";
            since = "Factures depuis le ";
            between = "Factures entre le ";
            and = " et le ";
            this.format = DateFormat.getDateInstance(1, Locale.FRANCE);
        } else {
            this.format = new SimpleDateFormat("d MMMM yyyy", Locale.US);
        }
        if (this.d1 != null || this.d2 != null) {
            if (this.d1 == null) {
                mapValues.put("PERIOD", String.valueOf(upTo) + this.format.format(this.d2));
            } else if (this.d2 == null) {
                mapValues.put("PERIOD", String.valueOf(since) + this.format.format(this.d1));
            } else {
                mapValues.put("PERIOD", String.valueOf(between) + this.format.format(this.d1) + and + this.format.format(this.d2));
            }
        }
        this.mapAllSheetValues.put(0, mapValues);
        ArrayList values = new ArrayList();
        this.listAllSheetValues.put(0, values);
        this.styleAllSheetValues = new HashMap();
        HashMap<Integer, String> styles = new HashMap<Integer, String>();
        this.styleAllSheetValues.put(0, styles);
        HashMap<String, Object> total = new HashMap<String, Object>();
        total.put("NUMERO_FACTURE", "TOTAL");
        double totalTTC = 0.0;
        double totalDu = 0.0;
        for (SQLRowValues sqlRowValues : l) {
            HashMap<String, Object> line = new HashMap<String, Object>();
            line.put("NUMERO_FACTURE", sqlRowValues.getObject("NUMERO"));
            line.put("INFOS", sqlRowValues.getObject("INFOS"));
            line.put("NOM", sqlRowValues.getObject("NOM"));
            Calendar c = sqlRowValues.getDate("DATE");
            line.put("DATE", c.getTime());
            double ttc = (double)sqlRowValues.getLong("T_TTC") / 100.0;
            line.put("T_TTC", ttc);
            double du = 0.0;
            SQLRowAccessor rowC = sqlRowValues.getForeign("ID_CLIENT");
            if (rowC != null && !rowC.isUndefined()) {
                line.put("CLIENT", rowC.getObject("NOM"));
            }
            Calendar dateEch = Calendar.getInstance();
            dateEch.setTime(c.getTime());
            Collection<SQLRowValues> echeances = sqlRowValues.getReferentRows(tableEch);
            for (SQLRowValues sqlRowValues2 : echeances) {
                if (sqlRowValues2.getBoolean("REGLE").booleanValue() || sqlRowValues2.getBoolean("REG_COMPTA").booleanValue()) continue;
                du += (double)sqlRowValues2.getLong("MONTANT") / 100.0;
                dateEch = sqlRowValues2.getDate("DATE");
            }
            line.put("ECHEANCE", dateEch.getTime());
            line.put("DU", du);
            line.put("REGLE", ttc - du);
            totalTTC += ttc;
            totalDu += du;
            if (du == 0.0) {
                styles.put(values.size(), "Normal");
            } else if (!this.toDay.after(dateEch)) {
                styles.put(values.size(), "Titre 1");
            } else {
                styles.put(values.size(), "Titre 2");
            }
            values.add(line);
        }
        total.put("T_TTC", totalTTC);
        total.put("DU", totalDu);
        total.put("REGLE", totalTTC - totalDu);
        styles.put(values.size(), "Titre 3");
        values.add(total);
    }

    @Override
    public String getDefaultTemplateId() {
        return TEMPLATE_ID;
    }

    @Override
    public String getName() {
        return TEMPLATE_ID + this.row.getString("NOM");
    }
}

