/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.mime;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.openconcerto.utils.mime.FreeDesktopMimeDetector;

public class File {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println(String.valueOf(File.class.getName()) + " file...");
            System.out.println("Allow to find the MIME type of files");
            System.out.println("The 'freeDesktop.mime.mode' property can be set to " + Arrays.asList(FreeDesktopMimeDetector.Mode.values()));
            System.out.println("\tthe default is the first one, see http://standards.freedesktop.org/shared-mime-info-spec/shared-mime-info-spec-latest.html#idm140625828606432");
            System.exit(1);
        }
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            Path p = Paths.get(f, new String[0]);
            System.out.println(String.valueOf(f) + '\t' + new FreeDesktopMimeDetector().probeContentType(p));
            ++n2;
        }
    }
}

