/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui.group;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.GroupModifier;

public class GroupModifiers {
    private List<GroupModifier> modifiers = new ArrayList<GroupModifier>();
    private Group baseGroup;
    private Group currentGroup;

    GroupModifiers(Group baseGroup) {
        this.baseGroup = baseGroup;
        this.currentGroup = baseGroup;
    }

    void addModifier(GroupModifier m) {
        if (!this.canAdd(m)) {
            throw new IllegalArgumentException("Cannot apply " + m + " on group " + this.baseGroup);
        }
        m.applyOn(this.currentGroup);
        this.modifiers.add(m);
    }

    private boolean canAdd(GroupModifier m) {
        if (!m.canBeAppliedOn(this.currentGroup)) {
            return false;
        }
        for (GroupModifier element : this.modifiers) {
            if (!element.isCompatibleWith(m)) {
                return false;
            }
            if (m.isCompatibleWith(element)) continue;
            return false;
        }
        return true;
    }

    public Group getCurrentGroup() {
        return this.currentGroup;
    }
}

