/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.util.Locale;
import java.util.NavigableMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import org.openconcerto.ui.FormLayouter;
import org.openconcerto.ui.component.HTMLTextField;
import org.openconcerto.ui.component.ITextArea;
import org.openconcerto.utils.SystemInfo;
import org.openconcerto.utils.i18n.TM;

public class SystemInfoPanel
extends JPanel {
    private final FormLayouter l = new FormLayouter(this, 1);

    public SystemInfoPanel() {
        this(Locale.getDefault());
    }

    public SystemInfoPanel(Locale locale) {
        this.refresh(locale);
    }

    public final void refresh(Locale locale) {
        this.l.clear();
        NavigableMap<SystemInfo.Info, String> infos = SystemInfo.get(true, locale);
        HTMLTextField p = new HTMLTextField((String)infos.get((Object)SystemInfo.Info.JAVA)){

            private final String getClassName(HyperlinkEvent e) {
                String uri = e.getDescription();
                if (uri.startsWith("class:")) {
                    return uri.substring("class".length() + 1);
                }
                return null;
            }

            @Override
            protected String getToolTip(HyperlinkEvent e) {
                String className = this.getClassName(e);
                if (className != null) {
                    return className;
                }
                return super.getToolTip(e);
            }

            @Override
            protected void linkActivated(HyperlinkEvent e, JComponent src) {
                String className = this.getClassName(e);
                if (className != null) {
                    String msg = className;
                    try {
                        Class<?> cl = Class.forName(className);
                        msg = String.valueOf(msg) + " (exists\nand its superclass is " + cl.getSuperclass() + ")";
                    }
                    catch (ClassNotFoundException e1) {
                        msg = String.valueOf(msg) + " (couldn't be loaded)";
                    }
                    ITextArea txtComp = new ITextArea(msg, 3, 50);
                    txtComp.setEditable(false);
                    txtComp.setBorder(BorderFactory.createEmptyBorder());
                    txtComp.setOpaque(false);
                    JOptionPane.showMessageDialog(src, txtComp, "Class name", 1);
                } else {
                    super.linkActivated(e, src);
                }
            }
        };
        this.l.add("Java", p);
        this.l.add(TM.tr(locale, "os", new Object[0]), new JLabel("<html>" + (String)infos.get((Object)SystemInfo.Info.OS) + "</html>"));
        this.l.add(TM.tr(locale, "user", new Object[0]), new HTMLTextField((String)infos.get((Object)SystemInfo.Info.USER)));
        this.l.add(TM.tr(locale, "network", new Object[0]), new HTMLTextField((String)infos.get((Object)SystemInfo.Info.NETWORK)));
        this.l.getComponent().revalidate();
    }
}

