/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.ui.textmenu;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.JTextComponent;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.ui.textmenu.TextFieldCustomTablePanel;
import org.openconcerto.sql.ui.textmenu.TextFieldMenuItem;
import org.openconcerto.sql.ui.textmenu.TextFieldWithMenuItemsFetcher;
import org.openconcerto.sql.view.IListButton;
import org.openconcerto.utils.CollectionUtils;
import org.openconcerto.utils.StringUtils;

public class TextFieldCustomMenu
extends JMenu {
    public static int SWITCH_TO_TABLEPANEL_AT = 10;
    private final JTextComponent textComp;
    private SQLRow selectedRow;
    private final TextFieldWithMenuItemsFetcher itemsGetter;
    private final List<AbstractAction> actions = new ArrayList<AbstractAction>();

    public TextFieldCustomMenu(JTextComponent textComp, TextFieldWithMenuItemsFetcher itemsGetter) {
        this.itemsGetter = itemsGetter;
        this.textComp = textComp;
        this.setIcon(new ImageIcon(IListButton.class.getResource("liste.png")));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setOpaque(false);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.init();
    }

    public void addAction(AbstractAction action) {
        this.actions.add(action);
    }

    public void clearAction() {
        this.actions.clear();
    }

    public void init() {
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent me) {
                TextFieldCustomMenu.this.removeAll();
                TextFieldCustomMenu.this.revalidate();
                TextFieldCustomMenu.this.repaint();
                List<String> selectedItems = StringUtils.fastSplitTrimmed(TextFieldCustomMenu.this.textComp.getText(), ',');
                List<TextFieldMenuItem> items = TextFieldCustomMenu.this.itemsGetter.getItems(selectedItems, TextFieldCustomMenu.this.selectedRow);
                if (items.size() > SWITCH_TO_TABLEPANEL_AT) {
                    TextFieldCustomTablePanel p = new TextFieldCustomTablePanel(TextFieldCustomMenu.this.textComp, items, TextFieldCustomMenu.this.itemsGetter.getItemName());
                    for (AbstractAction action : TextFieldCustomMenu.this.actions) {
                        p.addAction(action);
                    }
                    JDialog diag = new JDialog((JFrame)SwingUtilities.getRoot(TextFieldCustomMenu.this));
                    diag.setTitle("S\u00e9lection");
                    diag.setModal(true);
                    diag.setContentPane(p);
                    diag.pack();
                    diag.setLocation(TextFieldCustomMenu.this.getLocationOnScreen());
                    diag.setResizable(false);
                    TextFieldCustomMenu.this.doClick();
                    diag.setVisible(true);
                } else {
                    TextFieldCustomMenu.this.fill(items);
                    TextFieldCustomMenu.this.doClick();
                }
            }

            @Override
            public void menuDeselected(MenuEvent me) {
            }

            @Override
            public void menuCanceled(MenuEvent me) {
            }
        });
    }

    public void setSelectedRow(SQLRow selectedRow) {
        this.selectedRow = selectedRow;
    }

    private void fillTextComp() {
        int itemCount = this.getItemCount();
        ArrayList<String> l = new ArrayList<String>();
        int i = 0;
        while (i < itemCount) {
            JCheckBoxMenuItem item;
            if (this.getItem(i) instanceof JCheckBoxMenuItem && (item = (JCheckBoxMenuItem)this.getItem(i)) != null && item.isSelected() && item.isEnabled()) {
                l.add(item.getText());
            }
            ++i;
        }
        this.textComp.setText(CollectionUtils.join(l, ", "));
    }

    public void fill(List<TextFieldMenuItem> items) {
        JMenuItem item;
        for (TextFieldMenuItem menuItem : items) {
            item = new JCheckBoxMenuItem(menuItem.getName());
            item.setSelected(menuItem.isSelected());
            item.setEnabled(menuItem.isEnabled());
            if (menuItem.isEnabled()) {
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TextFieldCustomMenu.this.fillTextComp();
                    }
                });
            }
            this.add(item);
        }
        if (this.actions.size() > 0) {
            this.add(new JSeparator());
            for (AbstractAction action : this.actions) {
                item = new JMenuItem(action);
                this.add(item);
            }
        }
    }
}

