/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.humanresources.payroll.element;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import org.openconcerto.erp.config.ComptaPropsConfiguration;
import org.openconcerto.erp.core.common.element.ComptaSQLConfElement;
import org.openconcerto.erp.core.common.ui.JNiceButton;
import org.openconcerto.erp.core.common.ui.PanelFrame;
import org.openconcerto.erp.core.humanresources.payroll.component.VariableRowTreeNode;
import org.openconcerto.erp.core.humanresources.payroll.report.FichePayeSheetXML;
import org.openconcerto.erp.core.humanresources.payroll.ui.FichePayeRenderer;
import org.openconcerto.erp.core.humanresources.payroll.ui.PanelCumulsPaye;
import org.openconcerto.erp.model.FichePayeModel;
import org.openconcerto.erp.model.MouseSheetXmlListeListener;
import org.openconcerto.erp.model.RubriquePayeTree;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.BaseSQLComponent;
import org.openconcerto.sql.element.SQLComponent;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.element.SQLElementDirectory;
import org.openconcerto.sql.element.SQLElementLink;
import org.openconcerto.sql.element.SQLElementLinksSetup;
import org.openconcerto.sql.element.TreesOfSQLRows;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowListRSH;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.sqlobject.ElementComboBox;
import org.openconcerto.sql.view.EditFrame;
import org.openconcerto.sql.view.IListFrame;
import org.openconcerto.sql.view.list.IListe;
import org.openconcerto.sql.view.list.IListeAction;
import org.openconcerto.sql.view.list.RowAction;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.JDate;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.utils.ExceptionHandler;
import org.openconcerto.utils.ListMap;

public class FichePayeSQLElement
extends ComptaSQLConfElement {
    private static List<String> cumulFields = Arrays.asList("SAL_BRUT", "CSG", "COT_SAL", "COT_PAT", "NET_IMP", "HEURE_TRAV", "CICE", "AVANTAGE_NATURE", "ALLEGEMENT_COTISATION", "SAL_BASE_BRUT", "TAXE_CM_SAL", "TAXE_CM_PAT", "SAL_BRUT_COTISABLE", "SAL_BRUT_TAXABLE");

    public FichePayeSQLElement() {
        super("FICHE_PAYE", "une fiche de paye", "fiches de paye");
        MouseSheetXmlListeListener l = new MouseSheetXmlListeListener((SQLElement)this, FichePayeSheetXML.class);
        this.getRowActions().addAll(l.getRowActions());
        RowAction.PredicateRowAction actionCumuls = new RowAction.PredicateRowAction(new AbstractAction("D\u00e9tails cumuls et variables"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelCumulsPaye pCumuls = new PanelCumulsPaye();
                PanelFrame p = new PanelFrame(pCumuls, "D\u00e9tails cumuls et variables");
                pCumuls.selectFiche(IListe.get(e).getSelectedRow().asRow());
                p.setVisible(true);
            }
        }, true);
        actionCumuls.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(actionCumuls);
        RowAction.PredicateRowAction genererNonSimplifie = new RowAction.PredicateRowAction(new AbstractAction("Cr\u00e9er le bulletin d\u00e9taill\u00e9"){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRow row = IListe.get(e).getSelectedRow().asRow();
                FichePayeSheetXML sheet = new FichePayeSheetXML(row, false);
                try {
                    sheet.createDocument();
                    sheet.showPrintAndExport(true, false, true, Collections.emptyList());
                }
                catch (Exception e1) {
                    ExceptionHandler.handle("Erreur lors de la cr\u00e9ation du document.", e1);
                }
            }
        }, false);
        genererNonSimplifie.setPredicate(IListeAction.IListeEvent.getSingleSelectionPredicate());
        this.getRowActions().add(genererNonSimplifie);
    }

    @Override
    public ListMap<String, String> getShowAs() {
        ListMap<String, String> map = new ListMap<String, String>();
        map.put("ID_SALARIE", Arrays.asList("CODE", "NOM", "PRENOM", "ID_REGLEMENT_PAYE"));
        return map;
    }

    @Override
    protected List<String> getListFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_SALARIE");
        l.add("ID_MOIS");
        l.add("ANNEE");
        l.add("NET_A_PAYER");
        return l;
    }

    @Override
    protected List<String> getComboFields() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ID_SALARIE");
        l.add("ID_MOIS");
        l.add("ANNEE");
        return l;
    }

    @Override
    public boolean isPrivate() {
        return true;
    }

    @Override
    protected void setupLinks(SQLElementLinksSetup links) {
        super.setupLinks(links);
        if (this.getTable().contains("ID_INFOS_SALARIE_PAYE")) {
            links.get("ID_INFOS_SALARIE_PAYE").setType(SQLElementLink.LinkType.ASSOCIATION);
        }
    }

    @Override
    public SQLComponent createComponent() {
        return new BaseSQLComponent(this){
            private FichePayeModel model;
            private ElementComboBox comboSelProfil;
            private ElementComboBox selSalCombo;
            private EditFrame edit;
            private ElementComboBox selMois;
            private int dernMois;
            private int dernAnnee;
            private JTextField textAnnee;
            JDate dateDu;
            JDate dateAu;
            private JScrollPane paneTreeLeft;
            private JPanel pDate;
            {
                this.edit = null;
            }

            @Override
            public void addViews() {
                this.dernMois = 0;
                this.dernAnnee = 0;
                this.setLayout(new GridBagLayout());
                final RubriquePayeTree tree = new RubriquePayeTree();
                tree.expandRow(0);
                JPanel panelLeft = new JPanel(new GridBagLayout());
                DefaultGridBagConstraints cLeft = new DefaultGridBagConstraints();
                cLeft.fill = 1;
                cLeft.weightx = 1.0;
                cLeft.weighty = 1.0;
                cLeft.gridheight = 0;
                panelLeft.add((Component)tree, cLeft);
                this.paneTreeLeft = new JScrollPane((Component)tree);
                JPanel panelRight = new JPanel(new GridBagLayout());
                DefaultGridBagConstraints c = new DefaultGridBagConstraints();
                c.fill = 2;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.gridheight = 1;
                c.gridwidth = 2;
                this.selSalCombo = new ElementComboBox();
                panelRight.add((Component)this.selSalCombo, c);
                JLabel labelMois = new JLabel("Fiche de paye du mois de");
                this.selMois = new ElementComboBox(true, 20);
                JLabel labelDu = new JLabel("Du");
                JLabel labelAu = new JLabel("Au");
                this.dateDu = new JDate();
                this.dateAu = new JDate();
                JLabel labelAnnee = new JLabel("Ann\u00e9e");
                this.textAnnee = new JTextField();
                this.pDate = new JPanel(new GridBagLayout());
                DefaultGridBagConstraints cDate = new DefaultGridBagConstraints();
                cDate.weightx = 0.0;
                cDate.gridx = -1;
                this.pDate.setOpaque(false);
                this.pDate.add((Component)labelMois, cDate);
                cDate.weightx = 1.0;
                this.pDate.add((Component)this.selMois, cDate);
                cDate.weightx = 0.0;
                this.pDate.add((Component)labelAnnee, cDate);
                cDate.weightx = 1.0;
                this.pDate.add((Component)this.textAnnee, cDate);
                cDate.weightx = 0.0;
                this.pDate.add((Component)labelDu, cDate);
                cDate.weightx = 0.0;
                this.pDate.add((Component)this.dateDu, cDate);
                cDate.weightx = 0.0;
                this.pDate.add((Component)labelAu, cDate);
                cDate.weightx = 0.0;
                this.pDate.add((Component)this.dateAu, cDate);
                ++c.gridy;
                c.fill = 2;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.gridheight = 1;
                c.gridwidth = 2;
                panelRight.add((Component)this.pDate, c);
                JPanel pButtons = new JPanel(new GridBagLayout());
                pButtons.setOpaque(false);
                JNiceButton buttonUp = new JNiceButton(IListFrame.class.getResource("fleche_haut.png"));
                JNiceButton buttonDown = new JNiceButton(IListFrame.class.getResource("fleche_bas.png"));
                JNiceButton buttonRemove = new JNiceButton(SQLComponent.class.getResource("delete.png"));
                DefaultGridBagConstraints cButtons = new DefaultGridBagConstraints();
                cButtons.weightx = 0.0;
                cButtons.fill = 0;
                cButtons.gridx = -1;
                pButtons.add((Component)buttonUp, cButtons);
                pButtons.add((Component)buttonDown, cButtons);
                pButtons.add((Component)buttonRemove, cButtons);
                c.gridx += 2;
                c.fill = 0;
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.gridwidth = 1;
                panelRight.add((Component)pButtons, c);
                c.fill = 1;
                c.weightx = 1.0;
                c.weighty = 1.0;
                c.gridx = 0;
                ++c.gridy;
                c.gridwidth = 0;
                this.model = new FichePayeModel(1);
                final JTable table = new JTable((TableModel)this.model);
                panelRight.add((Component)new JScrollPane(table), c);
                FichePayeRenderer rend = new FichePayeRenderer();
                table.setDefaultRenderer(String.class, rend);
                table.setDefaultRenderer(Float.class, rend);
                c.gridx = 0;
                ++c.gridy;
                c.weightx = 0.0;
                c.weighty = 0.0;
                c.gridwidth = 1;
                c.fill = 2;
                JLabel labelProfil = new JLabel("Li\u00e9 \u00e0 un profil pr\u00e9d\u00e9fini");
                panelRight.add((Component)labelProfil, c);
                c.gridwidth = 1;
                this.comboSelProfil = new ElementComboBox();
                this.comboSelProfil.setListIconVisible(false);
                ++c.gridx;
                c.gridwidth = 1;
                c.weightx = 1.0;
                panelRight.add((Component)this.comboSelProfil, c);
                JButton buttonImportProfil = new JButton("Importer");
                ++c.gridx;
                c.weightx = 0.0;
                panelRight.add((Component)buttonImportProfil, c);
                JPanel panelTotal = new JPanel(new GridBagLayout());
                panelTotal.setBorder(BorderFactory.createTitledBorder("Totaux sur la p\u00e9riode"));
                DefaultGridBagConstraints cPanel = new DefaultGridBagConstraints();
                JLabel labelInfosConges = new JLabel(this.getLabelFor("DETAILS_CONGES"));
                panelTotal.add((Component)labelInfosConges, cPanel);
                JTextField textConges = new JTextField();
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                cPanel.gridwidth = 5;
                panelTotal.add((Component)textConges, cPanel);
                this.addView(textConges, "DETAILS_CONGES");
                cPanel.weightx = 0.0;
                cPanel.gridwidth = 1;
                ++cPanel.gridy;
                cPanel.gridx = 0;
                JLabel labelBrut = new JLabel(this.getLabelFor("SAL_BRUT"));
                panelTotal.add((Component)labelBrut, cPanel);
                JTextField textSalBrut = new JTextField(10);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelTotal.add((Component)textSalBrut, cPanel);
                textSalBrut.setEditable(false);
                textSalBrut.setEnabled(false);
                ++cPanel.gridx;
                cPanel.weightx = 0.0;
                JLabel labelAcompte = new JLabel(this.getLabelFor("ACOMPTE"));
                panelTotal.add((Component)labelAcompte, cPanel);
                JTextField textAcompte = new JTextField(10);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelTotal.add((Component)textAcompte, cPanel);
                ++cPanel.gridx;
                cPanel.weightx = 0.0;
                JLabel labelCongesAcquis = new JLabel(this.getLabelFor("CONGES_ACQUIS"));
                panelTotal.add((Component)labelCongesAcquis, cPanel);
                JTextField textCongesAcquis = new JTextField(10);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelTotal.add((Component)textCongesAcquis, cPanel);
                cPanel.gridx = 0;
                ++cPanel.gridy;
                cPanel.weightx = 0.0;
                JLabel labelCotSal = new JLabel(this.getLabelFor("COT_SAL"));
                panelTotal.add((Component)labelCotSal, cPanel);
                JTextField textCotSal = new JTextField(10);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelTotal.add((Component)textCotSal, cPanel);
                textCotSal.setEditable(false);
                textCotSal.setEnabled(false);
                ++cPanel.gridx;
                cPanel.weightx = 0.0;
                JLabel labelCotPat = new JLabel(this.getLabelFor("COT_PAT"));
                panelTotal.add((Component)labelCotPat, cPanel);
                JTextField textCotPat = new JTextField(10);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelTotal.add((Component)textCotPat, cPanel);
                textCotPat.setEditable(false);
                textCotPat.setEnabled(false);
                JLabel labelCSG = new JLabel(this.getLabelFor("CSG"));
                ++cPanel.gridx;
                cPanel.weightx = 0.0;
                panelTotal.add((Component)labelCSG, cPanel);
                JTextField textCSG = new JTextField(10);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelTotal.add((Component)textCSG, cPanel);
                textCSG.setEditable(false);
                textCSG.setEnabled(false);
                cPanel.gridx = 0;
                ++cPanel.gridy;
                cPanel.weightx = 0.0;
                JLabel labelNetImp = new JLabel(this.getLabelFor("NET_IMP"));
                panelTotal.add((Component)labelNetImp, cPanel);
                JTextField textNetImp = new JTextField(10);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelTotal.add((Component)textNetImp, cPanel);
                textNetImp.setEditable(false);
                textNetImp.setEnabled(false);
                ++cPanel.gridx;
                cPanel.weightx = 0.0;
                JLabel labelNetAPayer = new JLabel(this.getLabelFor("NET_A_PAYER"));
                panelTotal.add((Component)labelNetAPayer, cPanel);
                JTextField textNetAPayer = new JTextField(10);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelTotal.add((Component)textNetAPayer, cPanel);
                textNetAPayer.setEditable(false);
                textNetAPayer.setEnabled(false);
                ++cPanel.gridx;
                cPanel.weightx = 0.0;
                JLabel labelCice = new JLabel(this.getLabelFor("CICE"));
                panelTotal.add((Component)labelCice, cPanel);
                JTextField textCice = new JTextField(10);
                ++cPanel.gridx;
                cPanel.weightx = 1.0;
                panelTotal.add((Component)textCice, cPanel);
                textCice.setEditable(false);
                textCice.setEnabled(false);
                this.addSQLObject(textCice, "CICE");
                c.gridx = 0;
                ++c.gridy;
                c.fill = 2;
                c.weightx = 1.0;
                c.weighty = 0.0;
                c.gridwidth = 0;
                panelRight.add((Component)panelTotal, c);
                DefaultGridBagConstraints cGlobal = new DefaultGridBagConstraints();
                cGlobal.gridx = 0;
                cGlobal.gridy = 0;
                cGlobal.gridwidth = 1;
                cGlobal.gridheight = 1;
                cGlobal.fill = 1;
                cGlobal.weightx = 1.0;
                cGlobal.weighty = 1.0;
                this.add((Component)new JSplitPane(1, this.paneTreeLeft, panelRight), cGlobal);
                buttonUp.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int newRowSelected = model.upRow(table.getSelectedRow());
                        if (newRowSelected >= 0) {
                            table.setRowSelectionInterval(newRowSelected, newRowSelected);
                        }
                    }
                });
                buttonDown.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int newRowSelected = model.downRow(table.getSelectedRow());
                        if (newRowSelected >= 0) {
                            table.setRowSelectionInterval(newRowSelected, newRowSelected);
                        }
                    }
                });
                buttonRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        model.removeRow(table.getSelectedRow());
                    }
                });
                tree.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent mE) {
                        TreePath path = tree.getClosestPathForLocation(mE.getPoint().x, mE.getPoint().y);
                        Object obj = path.getLastPathComponent();
                        if (obj == null) {
                            return;
                        }
                        if (mE.getClickCount() == 2 && mE.getButton() == 1) {
                            if (obj instanceof VariableRowTreeNode) {
                                model.addRowAt(((VariableRowTreeNode)obj).getRow(), table.getSelectedRow());
                            }
                        } else if (mE.getButton() == 3 && obj instanceof VariableRowTreeNode) {
                            final SQLRow row = ((VariableRowTreeNode)obj).getRow();
                            JPopupMenu menuDroit = new JPopupMenu();
                            menuDroit.add(new AbstractAction("Editer"){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (edit != null) {
                                        edit.dispose();
                                    }
                                    edit = new EditFrame(Configuration.getInstance().getDirectory().getElement(row.getTable()), EditFrame.MODIFICATION);
                                    edit.selectionId(row.getID(), 0);
                                    edit.pack();
                                    edit.setVisible(true);
                                }
                            });
                            menuDroit.add(new AbstractAction("Nouvelle rubrique"){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    if (edit != null) {
                                        edit.dispose();
                                    }
                                    edit = new EditFrame(Configuration.getInstance().getDirectory().getElement(row.getTable()));
                                    edit.pack();
                                    edit.setVisible(true);
                                }
                            });
                            menuDroit.show(mE.getComponent(), mE.getPoint().x, mE.getPoint().y);
                        }
                    }
                });
                this.dateDu.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        java.util.Date d;
                        if (!dateDu.isEmpty() && (d = dateDu.getValue()) != null) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(d);
                            if (selMois.getSelectedId() > 1 && cal.get(2) + 2 != selMois.getSelectedId()) {
                                cal.set(5, 1);
                                cal.set(2, selMois.getSelectedId() - 2);
                                dateDu.setValue(cal.getTime());
                            }
                            this.fireValidChange();
                        }
                    }
                });
                this.dateAu.addValueListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        java.util.Date d;
                        if (!dateAu.isEmpty() && (d = dateAu.getValue()) != null) {
                            Calendar cal = Calendar.getInstance();
                            cal.setTime(d);
                            if (selMois.getSelectedId() > 1 && cal.get(2) + 2 != selMois.getSelectedId()) {
                                cal.set(5, 1);
                                cal.set(2, selMois.getSelectedId() - 2);
                                cal.set(5, cal.getActualMaximum(5));
                                dateAu.setValue(cal.getTime());
                            }
                            this.fireValidChange();
                        }
                    }
                });
                this.addRequiredSQLObject(this.textAnnee, "ANNEE");
                this.addRequiredSQLObject(this.selMois, "ID_MOIS");
                this.addSQLObject(this.comboSelProfil, "ID_PROFIL_PAYE");
                this.addSQLObject(textCongesAcquis, "CONGES_ACQUIS");
                this.addSQLObject(textCotPat, "COT_PAT");
                this.addSQLObject(textCotSal, "COT_SAL");
                this.addSQLObject(textCSG, "CSG");
                this.addSQLObject(textNetAPayer, "NET_A_PAYER");
                this.addSQLObject(textNetImp, "NET_IMP");
                this.addSQLObject(textSalBrut, "SAL_BRUT");
                this.addSQLObject(textAcompte, "ACOMPTE");
                this.addSQLObject(this.selSalCombo, "ID_SALARIE");
                this.addRequiredSQLObject(this.dateDu, "DU");
                this.addRequiredSQLObject(this.dateAu, "AU");
                this.selSalCombo.setInteractionMode(InteractionMode.DISABLED);
                this.selSalCombo.setEnabled(false);
                this.selSalCombo.setButtonsVisible(false);
                buttonImportProfil.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        model.loadFromProfil(comboSelProfil.getSelectedId());
                    }
                });
            }

            @Override
            public int insert(SQLRow order) {
                int id = super.insert(order);
                this.model.updateFields(id);
                return id;
            }

            @Override
            public void update() {
                super.update();
                this.model.updateFields(this.getSelectedID());
            }

            @Override
            public void select(SQLRowAccessor r) {
                super.select(r);
                if (r != null && r.getID() > 1) {
                    this.model.setFicheID(r.getID());
                    SQLTable tableSal = this.getTable().getBase().getTable("SALARIE");
                    SQLRow rowSal = tableSal.getRow(r.getInt("ID_SALARIE"));
                    this.dernMois = rowSal.getInt("DERNIER_MOIS");
                    this.dernAnnee = rowSal.getInt("DERNIERE_ANNEE");
                    this.selSalCombo.setVisible((Boolean)r.getObject("VALIDE"));
                    this.paneTreeLeft.setVisible((Boolean)r.getObject("VALIDE") == false);
                    this.setpDateEnabled((Boolean)r.getObject("VALIDE") == false);
                }
                this.selSalCombo.setInteractionMode(InteractionMode.DISABLED);
                this.selSalCombo.setEnabled(false);
                this.selMois.setButtonsVisible(false);
                this.selSalCombo.setButtonsVisible(false);
            }

            private void setpDateEnabled(boolean b) {
                this.selMois.setInteractionMode(b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
                this.textAnnee.setEditable(b);
                this.textAnnee.setEnabled(b);
                this.dateDu.setInteractionMode(b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
                this.dateAu.setInteractionMode(b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
            }

            @Override
            protected SQLRowValues createDefaults() {
                SQLRowValues rowVals = new SQLRowValues(this.getTable());
                Calendar cal = Calendar.getInstance();
                rowVals.put("ID_MOIS", cal.get(2) + 2);
                rowVals.put("ANNEE", cal.get(1));
                cal.set(5, 1);
                rowVals.put("DU", new Date(cal.getTime().getTime()));
                cal.set(5, cal.getActualMaximum(5));
                rowVals.put("AU", new Date(cal.getTime().getTime()));
                return rowVals;
            }
        };
    }

    @Override
    protected void archive(TreesOfSQLRows trees, boolean cutLinks) throws SQLException {
        super.archive(trees, cutLinks);
        for (SQLRow row : trees.getRows()) {
            if (row == null || row.getID() <= 1 || JOptionPane.showConfirmDialog(null, "Soustraire les cumuls de cette fiche \u00e0 celle en cours?", "Suppression d'une fiche de paye", 0) != 0) continue;
            SQLRow rowSal = row.getForeignRow("ID_SALARIE");
            SQLRow rowCumuls = rowSal.getForeignRow("ID_CUMULS_PAYE");
            SQLRowValues rowValsCumul = rowCumuls.createEmptyUpdateRow();
            for (String string : cumulFields) {
                float cumul = rowCumuls.getFloat(String.valueOf(string) + "_C") - row.getFloat(string);
                rowValsCumul.put(String.valueOf(string) + "_C", new Float(cumul));
            }
            float netAPayer = rowCumuls.getFloat("NET_A_PAYER_C") - row.getFloat("NET_A_PAYER") - row.getFloat("ACOMPTE");
            rowValsCumul.put("NET_A_PAYER_C", new Float(netAPayer));
            try {
                rowValsCumul.update();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            SQLRow rowCumulConge = rowSal.getForeignRow("ID_CUMULS_CONGES");
            SQLRow rowVarSalFiche = row.getForeignRow("ID_VARIABLE_SALARIE");
            SQLRow rowVarSal = rowSal.getForeignRow("ID_VARIABLE_SALARIE");
            float congeCumule = rowCumulConge.getFloat("ACQUIS");
            float congeRestant = rowCumulConge.getFloat("RESTANT");
            float prisPeriode = rowVarSalFiche.getFloat("CONGES_PRIS");
            SQLRowValues rowValsCumulsConges = new SQLRowValues(rowCumulConge.getTable());
            rowValsCumulsConges.put("ACQUIS", new Float(congeCumule -= row.getFloat("CONGES_ACQUIS")));
            rowValsCumulsConges.put("RESTANT", new Float(congeRestant += prisPeriode));
            try {
                rowValsCumulsConges.update(rowCumulConge.getID());
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            SQLRowValues rowVals = rowVarSal.asRowValues();
            for (SQLField field : rowVarSalFiche.getTable().getContentFields()) {
                if (field.getName().endsWith("_DEFAULT_VAL") || field.getName().endsWith("_CUMUL_VAL") || !rowVarSalFiche.getTable().contains(String.valueOf(field.getName()) + "_CUMUL_VAL")) continue;
                float valPeriode = rowVarSalFiche.getObject(field.getName()) == null ? 0.0f : rowVarSalFiche.getFloat(field.getName());
                float valCumul = rowVarSal.getObject(String.valueOf(field.getName()) + "_CUMUL_VAL") == null ? 0.0f : rowVarSal.getFloat(String.valueOf(field.getName()) + "_CUMUL_VAL");
                rowVals.put(String.valueOf(field.getName()) + "_CUMUL_VAL", Float.valueOf(valCumul - valPeriode));
            }
            try {
                rowVals.update();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public static synchronized void validationFiche(int id) throws SQLException {
        int oldID = id;
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLTable tableSal = base.getTable("SALARIE");
        SQLTable tableCumulConge = base.getTable("CUMULS_CONGES");
        SQLTable tableVariableSal = base.getTable("VARIABLE_SALARIE");
        SQLTable tableFiche = base.getTable("FICHE_PAYE");
        SQLTable tableFicheElt = base.getTable("FICHE_PAYE_ELEMENT");
        SQLTable tableCumuls = base.getTable("CUMULS_PAYE");
        final SQLRowValues rowValsSal = new SQLRowValues(tableSal);
        final SQLRow rowFiche = tableFiche.getRow(oldID);
        final SQLRow rowSal = tableSal.getRow(rowFiche.getInt("ID_SALARIE"));
        if (!FichePayeSQLElement.checkDateValid(id)) {
            String msg = "Impossible de cr\u00e9er la fiche de paye de " + rowSal.getString("NOM") + " " + rowSal.getString("PRENOM") + ".\n La p\u00e9riode est clotur\u00e9e.";
            JOptionPane.showMessageDialog(null, msg, "Cr\u00e9ation paye impossible", 1);
            return;
        }
        FichePayeSQLElement.validElements(id);
        FichePayeSQLElement.stockValidValues(oldID);
        final SQLRowValues rowValsNewFiche = new SQLRowValues(tableFiche);
        SQLRow r = rowValsNewFiche.insert();
        rowValsNewFiche.put("ID", r.getID());
        int mois = rowFiche.getInt("ID_MOIS");
        int annee = rowFiche.getInt("ANNEE");
        rowValsNewFiche.put("ID_MOIS", mois);
        rowValsNewFiche.put("ANNEE", annee);
        Calendar calDu = rowFiche.getDate("DU");
        calDu.add(2, 1);
        calDu.set(5, 1);
        rowValsNewFiche.put("DU", calDu.getTime());
        calDu.set(5, calDu.getActualMaximum(5));
        rowValsNewFiche.put("AU", calDu.getTime());
        rowValsNewFiche.put("ID_PROFIL_PAYE", rowFiche.getInt("ID_PROFIL_PAYE"));
        rowValsNewFiche.put("ID_SALARIE", rowSal.getID());
        rowValsSal.put("ID_FICHE_PAYE", rowValsNewFiche.getID());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    rowValsSal.update(rowSal.getID());
                    rowValsNewFiche.update();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        });
        SQLSelect selAllElt = new SQLSelect();
        selAllElt.addSelect(tableFicheElt.getKey());
        selAllElt.addSelect(tableFicheElt.getField("POSITION"));
        selAllElt.addSelect(tableFicheElt.getField("SOURCE"));
        selAllElt.addSelect(tableFicheElt.getField("IDSOURCE"));
        selAllElt.setWhere(tableFicheElt.getField("ID_FICHE_PAYE"), "=", oldID);
        selAllElt.setDistinct(true);
        selAllElt.addFieldOrder(tableFicheElt.getField("POSITION"));
        for (SQLRow rowTmpElt : SQLRowListRSH.execute(selAllElt)) {
            String source = rowTmpElt.getString("SOURCE");
            int idSource = rowTmpElt.getInt("IDSOURCE");
            int pos = rowTmpElt.getInt("POSITION");
            SQLRowValues rowValsTmp = new SQLRowValues(tableFicheElt);
            rowValsTmp.put("SOURCE", source);
            rowValsTmp.put("IDSOURCE", idSource);
            rowValsTmp.put("POSITION", pos);
            rowValsTmp.put("ID_FICHE_PAYE", rowValsNewFiche.getID());
            rowValsTmp.commit();
        }
        final SQLRow rowVarSal = tableVariableSal.getRow(rowSal.getInt("ID_VARIABLE_SALARIE"));
        int idCumuls = rowSal.getInt("ID_CUMULS_PAYE");
        SQLRow rowCumuls = tableCumuls.getRow(idCumuls);
        SQLRowValues rowValsCumul = new SQLRowValues(tableCumuls);
        for (String string : cumulFields) {
            float cumul = rowCumuls.getFloat(String.valueOf(string) + "_C") + rowFiche.getFloat(string);
            rowValsCumul.put(String.valueOf(string) + "_C", new Float(cumul));
        }
        float netAPayer = rowCumuls.getFloat("NET_A_PAYER_C") + rowFiche.getFloat("NET_A_PAYER") + rowFiche.getFloat("ACOMPTE");
        rowValsCumul.put("NET_A_PAYER_C", new Float(netAPayer));
        SQLRow row = rowValsCumul.insert();
        rowValsCumul.put("ID", row.getID());
        rowValsSal.put("ID_CUMULS_PAYE", rowValsCumul.getID());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    rowValsSal.update(rowFiche.getInt("ID_SALARIE"));
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        });
        final SQLRow rowCumulConge = tableCumulConge.getRow(rowSal.getInt("ID_CUMULS_CONGES"));
        float congeCumule = rowCumulConge.getFloat("ACQUIS");
        float congeRestant = rowCumulConge.getFloat("RESTANT");
        float prisPeriode = rowVarSal.getFloat("CONGES_PRIS");
        congeRestant -= prisPeriode;
        SQLTable tableInfosSalPaye = base.getTable("INFOS_SALARIE_PAYE");
        final SQLRow rowSalInfosPaye = tableInfosSalPaye.getRow(rowSal.getInt("ID_INFOS_SALARIE_PAYE"));
        final SQLRowValues rowValsCumulsConges = new SQLRowValues(tableCumulConge);
        rowValsCumulsConges.put("ACQUIS", new Float(congeCumule += rowFiche.getFloat("CONGES_ACQUIS")));
        rowValsCumulsConges.put("RESTANT", new Float(congeRestant));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    rowValsCumulsConges.update(rowCumulConge.getID());
                    rowValsNewFiche.put("CONGES_ACQUIS", new Float(rowSalInfosPaye.getFloat("CONGES_PAYES")));
                    rowValsNewFiche.update();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
        final SQLRowValues rowValsOldFiche = new SQLRowValues(tableFiche);
        rowValsOldFiche.put("VALIDE", Boolean.TRUE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    rowValsOldFiche.update(rowFiche.getID());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
        final SQLRowValues rowVals = new SQLRowValues(tableVariableSal);
        for (SQLField field : tableVariableSal.getContentFields()) {
            if (field.getName().endsWith("_DEFAULT_VAL") || field.getName().endsWith("_CUMUL_VAL")) continue;
            if (tableVariableSal.contains(String.valueOf(field.getName()) + "_CUMUL_VAL")) {
                float valPeriode = rowVarSal.getObject(field.getName()) == null ? 0.0f : rowVarSal.getFloat(field.getName());
                float valCumul = rowVarSal.getObject(String.valueOf(field.getName()) + "_CUMUL_VAL") == null ? 0.0f : rowVarSal.getFloat(String.valueOf(field.getName()) + "_CUMUL_VAL");
                rowVals.put(String.valueOf(field.getName()) + "_CUMUL_VAL", Float.valueOf(valCumul + valPeriode));
            }
            if (tableVariableSal.contains(String.valueOf(field.getName()) + "_DEFAULT_VAL")) {
                rowVals.put(field.getName(), rowVarSal.getObject(String.valueOf(field.getName()) + "_DEFAULT_VAL"));
                continue;
            }
            if (field.getType().getJavaType() == Integer.class) {
                rowVals.put(field.getName(), 0);
                continue;
            }
            rowVals.put(field.getName(), Float.valueOf(0.0f));
        }
        rowVals.put("HEURE_TRAV", rowSalInfosPaye.getObject("DUREE_MOIS"));
        if (tableVariableSal.contains("NB_JOUR_MOIS")) {
            rowVals.put("NB_JOUR_MOIS", Float.valueOf(31.0f));
            rowVals.put("NB_JOUR_TRAV", Float.valueOf(31.0f));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    rowVals.update(rowVarSal.getID());
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void clotureMensuelle(int idMois, int annee, int idSal) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLRowValues rowValsSal = new SQLRowValues(base.getTable("SALARIE"));
        SQLRow rowSal = base.getTable("SALARIE").getRow(idSal);
        int ancMois = rowSal.getInt("DERNIER_MOIS");
        int ancAnnee = rowSal.getInt("DERNIERE_ANNEE");
        if (ancAnnee < annee && ancMois < idMois) {
            rowValsSal.put("DERNIER_MOIS", idMois);
            rowValsSal.put("DERNIERE_ANNEE", annee);
            try {
                rowValsSal.update(idSal);
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
    }

    private static void stockValidValues(int id) throws SQLException {
        ComptaPropsConfiguration conf = ComptaPropsConfiguration.getInstanceCompta();
        SQLElementDirectory dir = conf.getDirectory();
        SQLTable tableFiche = conf.getRootSociete().getTable("FICHE_PAYE");
        SQLRow rowFiche = tableFiche.getRow(id);
        SQLRow rowSal = rowFiche.getForeignRow("ID_SALARIE");
        SQLRowValues rowValsFiche = new SQLRowValues(tableFiche);
        for (String fk : Arrays.asList("ID_PAS", "ID_VARIABLE_SALARIE", "ID_CUMULS_CONGES", "ID_CUMULS_PAYE", "ID_REGLEMENT_PAYE")) {
            SQLRow fRow = rowSal.getForeignRow(fk);
            SQLRowValues copy = dir.getElement(fRow.getTable()).createCopy(fRow, null);
            assert (copy.getIDNumber() == null);
            rowValsFiche.put(fk, (Object)copy);
        }
        SQLRow rInfosSalPaye = rowSal.getForeignRow("ID_INFOS_SALARIE_PAYE");
        SQLRow rContrat = rInfosSalPaye.getForeignRow("ID_CONTRAT_SALARIE");
        rowValsFiche.put("NATURE_EMPLOI", rContrat.getString("NATURE"));
        rowValsFiche.put("ID_IDCC", rInfosSalPaye.getInt("ID_IDCC"));
        rowValsFiche.put("ID_INFOS_SALARIE_PAYE", rInfosSalPaye.getID());
        rowValsFiche.update(id);
    }

    private static void validElements(int id) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        String trueString = "1";
        if (Configuration.getInstance().getBase().getServer().getSQLSystem() == SQLSystem.POSTGRESQL) {
            trueString = "true";
        }
        String req = "UPDATE \"FICHE_PAYE_ELEMENT\" SET \"VALIDE\" = " + trueString + " WHERE \"FICHE_PAYE_ELEMENT\".\"ID_FICHE_PAYE\" = " + id;
        base.getDataSource().execute(req);
    }

    private static boolean checkDateValid(int idFiche) {
        SQLBase base = ((ComptaPropsConfiguration)Configuration.getInstance()).getSQLBaseSociete();
        SQLRow rowFiche = base.getTable("FICHE_PAYE").getRow(idFiche);
        SQLRow rowSal = base.getTable("SALARIE").getRow(rowFiche.getInt("ID_SALARIE"));
        int moisClot = rowSal.getInt("DERNIER_MOIS");
        int anneeClot = rowSal.getInt("DERNIERE_ANNEE");
        int mois = rowFiche.getInt("ID_MOIS");
        int annee = rowFiche.getInt("ANNEE");
        return anneeClot == 0 || annee > anneeClot || moisClot == 0 || moisClot == 13 || mois > moisClot;
    }

    @Override
    protected String createCode() {
        return String.valueOf(this.createCodeOfPackage()) + ".payslip";
    }
}

