/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jopendocument.model.OpenDocument;
import org.jopendocument.panel.ODSViewerPanel;
import org.jopendocument.print.DefaultXMLDocumentPrinter;
import org.jopendocument.print.DocumentPrinter;
import org.openconcerto.erp.generationDoc.A4;
import org.openconcerto.erp.generationDoc.DefaultNXDocumentPrinter;
import org.openconcerto.utils.Action;
import org.openconcerto.utils.ExceptionHandler;

public class PreviewFrame
extends JFrame {
    private PreviewFrame(OpenDocument doc, String title) {
        super(title);
        ODSViewerPanel viewerPanel = new ODSViewerPanel(doc, (DocumentPrinter)this.createDocumentPrinter());
        viewerPanel.showSaveAsButton(false);
        this.setContentPane((Container)viewerPanel);
        this.setDefaultCloseOperation(2);
    }

    public PreviewFrame(String title, String url, String odspXml) {
        ODSViewerPanel contentPane = new ODSViewerPanel(url, odspXml, (DocumentPrinter)this.createDocumentPrinter(), true);
        contentPane.showSaveAsButton(false);
        this.setContentPane((Container)contentPane);
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
    }

    public void addTool(final Action a) {
        JButton b = new JButton(a.getName());
        ((ODSViewerPanel)this.getContentPane()).addTool((JComponent)b);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                a.run(PreviewFrame.this);
            }
        });
    }

    public DefaultXMLDocumentPrinter createDocumentPrinter() {
        return new DefaultXMLDocumentPrinter(){

            public void print(final List<OpenDocument> documents) {
                double POINTS_PER_INCH = 72.0;
                final PrinterJob printJob = PrinterJob.getPrinterJob();
                HashPrintRequestAttributeSet attributes = new HashPrintRequestAttributeSet();
                MediaSizeName media = MediaSizeName.ISO_A4;
                attributes.add(media);
                A4 paper = new A4(0.0f, 0.0f);
                MediaPrintableArea printableArea = new MediaPrintableArea((float)(paper.getImageableX() / 72.0), (float)(paper.getImageableY() / 72.0), (float)(paper.getImageableWidth() / 72.0), (float)(paper.getImageableHeight() / 72.0), 25400);
                attributes.add(printableArea);
                boolean okToPrint = printJob.printDialog(attributes);
                Attribute attribute = attributes.get(Copies.class);
                if (attribute != null) {
                    Copies attributeCopies = (Copies)attribute;
                    int value = attributeCopies.getValue();
                    printJob.setCopies(value);
                } else {
                    printJob.setCopies(1);
                }
                if (okToPrint) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DefaultNXDocumentPrinter printer = new DefaultNXDocumentPrinter();
                                printer.print(documents, printJob);
                            }
                            catch (Exception e) {
                                ExceptionHandler.handle("Print error", e);
                            }
                        }
                    });
                    t.setName("PreviewFrame Print Thread");
                    t.setDaemon(true);
                    t.start();
                }
            }
        };
    }

    @Override
    public void pack() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.setMaximizedBounds(ge.getMaximumWindowBounds());
        Dimension maxD = ge.getMaximumWindowBounds().getSize();
        this.setMaximumSize(maxD);
        super.pack();
        Dimension d = this.getSize();
        if (d.width > maxD.width) {
            d.setSize(maxD.width, d.height);
        }
        if (d.height > maxD.height) {
            d.setSize(d.width, maxD.height);
        }
        this.setLocationRelativeTo(null);
    }

    public static void show(File file) {
        PreviewFrame.show(file, Collections.emptyList());
    }

    public static void show(File file, final List<Action> actions) {
        final OpenDocument doc = new OpenDocument(file);
        final String title = file.getName();
        if (SwingUtilities.isEventDispatchThread()) {
            PreviewFrame previewFrame = new PreviewFrame(doc, title);
            for (Action a : actions) {
                previewFrame.addTool(a);
            }
            previewFrame.pack();
            previewFrame.setVisible(true);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PreviewFrame previewFrame = new PreviewFrame(doc, title, null);
                    for (Action a : actions) {
                        previewFrame.addTool(a);
                    }
                    previewFrame.pack();
                    previewFrame.setVisible(true);
                }
            });
        }
    }

    /* synthetic */ PreviewFrame(OpenDocument openDocument, String string, PreviewFrame previewFrame) {
        this(openDocument, string);
    }
}

