/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRequestLog;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.users.User;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.postgresql.jdbc.PgConnection;

public class SQLInsert {
    private List<SQLField> fields = new ArrayList<SQLField>();
    private List<Object> values = new ArrayList<Object>();
    private SQLTable table;

    public void importValuesFrom(SQLRowAccessor row) {
        SQLField pk = row.getTable().getKey();
        for (String field : row.getFields()) {
            SQLField sqlField = row.getTable().getField(field);
            if (pk.equals(sqlField)) continue;
            if (sqlField.isForeignKey()) {
                this.add(sqlField, row.getForeignIDNumber(field));
                continue;
            }
            this.add(sqlField, row.getObject(field));
        }
    }

    public int getFieldsSize() {
        return this.fields.size();
    }

    public List<SQLField> getFields() {
        return Collections.unmodifiableList(this.fields);
    }

    public void add(SQLField field, Object value) {
        if (this.table == null) {
            this.table = field.getTable();
        } else if (!this.table.equals(field.getTable())) {
            throw new IllegalArgumentException(field + " is not in table " + this.table.toString());
        }
        int index = this.fields.indexOf(field);
        if (index >= 0) {
            throw new IllegalArgumentException(field + " field already in list");
        }
        this.fields.add(field);
        this.values.add(value);
    }

    public void set(SQLField field, Object value) {
        if (this.table == null) {
            this.table = field.getTable();
        } else if (!this.table.equals(field.getTable())) {
            throw new IllegalArgumentException(field + " is not in table " + this.table.toString());
        }
        int index = this.fields.indexOf(field);
        if (index < 0) {
            throw new IllegalArgumentException(field + " not in field list");
        }
        this.values.set(index, value);
    }

    public void addCreationTrackedField(User u, SQLTable table) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        SQLField creationDateField = table.getCreationDateField();
        SQLField creationUserField = table.getCreationUserField();
        if (creationDateField != null && creationUserField != null) {
            this.add(creationDateField, now);
            this.add(creationUserField, u.getId());
        }
        SQLField modifDateField = table.getModifDateField();
        SQLField modifUserField = table.getModifUserField();
        if (modifDateField != null && modifUserField != null) {
            this.add(modifDateField, now);
            this.add(modifUserField, u.getId());
        }
    }

    public boolean contains(SQLField field) {
        return this.fields.indexOf(field) >= 0;
    }

    public Object getValue(SQLField field) {
        int index = this.fields.indexOf(field);
        if (index < 0) {
            throw new IllegalArgumentException(field + " not in field list");
        }
        return this.values.get(index);
    }

    public String asString() {
        if (this.fields.isEmpty()) {
            throw new IllegalStateException("not fields added");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("INSERT INTO ");
        builder.append(this.table.getSQLName());
        builder.append(" (");
        int stop = this.fields.size();
        int i = 0;
        while (i < stop) {
            builder.append(this.fields.get(i).getQuotedName());
            if (i < stop - 1) {
                builder.append(',');
            }
            ++i;
        }
        builder.append(") VALUES (");
        i = 0;
        while (i < stop) {
            Object value = this.values.get(i);
            SQLField field = this.fields.get(i);
            Class<?> javaType = field.getType().getJavaType();
            Object str = value;
            if (value != null) {
                if (!javaType.isInstance(value)) {
                    str = SQLRowValues.convert(value.getClass(), value, javaType);
                }
                builder.append(field.getType().toString(str));
            } else {
                builder.append("null");
            }
            if (i < stop - 1) {
                builder.append(',');
            }
            ++i;
        }
        builder.append(")");
        return builder.toString();
    }

    public static void executeMultiple(DBSystemRoot sysRoot, List<SQLInsert> queries) throws SQLException {
        if (queries.isEmpty()) {
            throw new IllegalArgumentException("no inserts");
        }
        HashMap<SQLTable, ArrayList<SQLInsert>> map = new HashMap<SQLTable, ArrayList<SQLInsert>>();
        for (SQLInsert sQLInsert : queries) {
            ArrayList<SQLInsert> list = (ArrayList<SQLInsert>)map.get(sQLInsert.table);
            if (list == null) {
                list = new ArrayList<SQLInsert>();
                map.put(sQLInsert.table, list);
            }
            list.add(sQLInsert);
        }
        for (Map.Entry entry : map.entrySet()) {
            SQLInsert.executeSimilarInserts(sysRoot, (List)entry.getValue(), false);
        }
    }

    public static long executeMultipleWithBatch(DBSystemRoot sysRoot, List<SQLInsert> queries) throws SQLException {
        if (queries.isEmpty()) {
            throw new IllegalArgumentException("no inserts");
        }
        ArrayList<String> l = new ArrayList<String>(queries.size());
        for (SQLInsert i : queries) {
            l.add(i.asString());
        }
        return sysRoot.getDataSource().executeBatch(l, true).get0();
    }

    public static long executeSimilarWithCopy(DBSystemRoot sysRoot, final List<SQLInsert> queries) throws SQLException {
        long time;
        SQLDataSource dataSource = sysRoot.getDataSource();
        if (dataSource.getSystem() != SQLSystem.POSTGRESQL) {
            return SQLInsert.executeSimilarInserts(sysRoot, queries, true).size();
        }
        if (queries.isEmpty()) {
            throw new IllegalArgumentException("no inserts");
        }
        final SQLInsert insert0 = queries.get(0);
        final long timeMs = System.currentTimeMillis();
        final long afterCache = time = System.nanoTime();
        final String query = insert0 + "..." + queries.size() + " queries";
        return dataSource.useConnection(new ConnectionHandlerNoSetup<Long, SQLException>(){

            @Override
            public Long handle(SQLDataSource ds) throws SQLException {
                long afterExecute;
                long count;
                Connection conn = ds.getConnection().unwrap(PgConnection.class);
                CopyManager copyManager = new CopyManager((BaseConnection)conn);
                StringBuilder allValues = new StringBuilder(insert0.fields.size() * 10 * queries.size());
                ArrayList<String> fi = new ArrayList<String>();
                for (SQLField f : insert0.fields) {
                    fi.add(f.getQuotedName());
                }
                for (SQLInsert q : queries) {
                    if (!q.table.equals(insert0.table)) {
                        throw new IllegalArgumentException("table " + q.table.getName() + " is not " + insert0.table.getTable());
                    }
                    if (!q.fields.equals(insert0.fields)) {
                        throw new IllegalArgumentException("fields" + q.fields + " not equals to " + insert0.fields);
                    }
                    int stop = q.values.size();
                    int i = 0;
                    while (i < stop) {
                        Object value = q.values.get(i);
                        SQLField field = (SQLField)q.fields.get(i);
                        Class<?> javaType = field.getType().getJavaType();
                        Object str = value;
                        if (!javaType.isInstance(value)) {
                            str = SQLRowValues.convert(value.getClass(), value, javaType);
                        }
                        allValues.append(field.getType().toString(str));
                        if (i < stop - 1) {
                            allValues.append('\t');
                        }
                        ++i;
                    }
                    allValues.append('\n');
                }
                long afterQueryInfo = System.nanoTime();
                try {
                    count = copyManager.copyIn("COPY " + insert0.table.getSQLName() + "(" + String.join((CharSequence)",", fi) + ") FROM STDIN WITH (ENCODING 'UTF-8') ", new StringReader(allValues.toString()));
                }
                catch (IOException e) {
                    throw new SQLException(e);
                }
                long afterHandle = afterExecute = System.nanoTime();
                SQLRequestLog.log(query, "multiple similar with copy", conn, timeMs, time, afterCache, afterQueryInfo, afterExecute, afterHandle, System.nanoTime(), queries.size());
                return count;
            }
        });
    }

    public static List<Number> executeSimilarInserts(DBSystemRoot sysRoot, final List<SQLInsert> queries, final boolean returnIds) throws SQLException {
        long time;
        SQLDataSource dataSource = sysRoot.getDataSource();
        if (queries.isEmpty()) {
            throw new IllegalArgumentException("no inserts");
        }
        final SQLInsert insert0 = queries.get(0);
        final long timeMs = System.currentTimeMillis();
        final long afterCache = time = System.nanoTime();
        final String query = insert0 + "..." + queries.size() + " queries";
        if (sysRoot.getServer().getSQLSystem() != SQLSystem.POSTGRESQL) {
            ArrayList<Number> res = new ArrayList<Number>();
            for (SQLInsert sqlInsert : queries) {
                res.add((Number)sysRoot.getDataSource().executeScalar(sqlInsert.asString()));
            }
            return res;
        }
        return dataSource.useConnection(new ConnectionHandlerNoSetup<List<Number>, SQLException>(){

            @Override
            public List<Number> handle(SQLDataSource ds) throws SQLException {
                long afterExecute;
                List<Number> res;
                Connection conn = ds.getConnection();
                ArrayList<String> fi = new ArrayList<String>();
                for (SQLField f : insert0.fields) {
                    fi.add(f.getQuotedName());
                }
                long afterQueryInfo = System.nanoTime();
                StringBuilder sql = new StringBuilder(insert0.fields.size() * 10 * (queries.size() + 1));
                sql.append("(" + String.join((CharSequence)",", fi) + ")");
                sql.append(" VALUES ");
                int size = queries.size();
                int j = 0;
                while (j < size) {
                    SQLInsert q = (SQLInsert)queries.get(j);
                    if (!q.table.equals(insert0.table)) {
                        throw new IllegalArgumentException("table " + q.table.getName() + " is not " + insert0.table.getTable());
                    }
                    if (!q.fields.equals(insert0.fields)) {
                        throw new IllegalArgumentException("fields" + q.fields + " not equals to " + insert0.fields);
                    }
                    sql.append("(");
                    int stop = q.values.size();
                    int i = 0;
                    while (i < stop) {
                        Object value = q.values.get(i);
                        SQLField field = (SQLField)q.fields.get(i);
                        Class<?> javaType = field.getType().getJavaType();
                        Object str = value;
                        if (!field.isNullable().booleanValue() && value == null) {
                            throw new IllegalStateException("null value for " + field);
                        }
                        if (value != null && !javaType.isInstance(value)) {
                            str = SQLRowValues.convert(value.getClass(), value, javaType);
                        }
                        sql.append(field.getType().toString(str));
                        if (i < stop - 1) {
                            sql.append(',');
                        }
                        ++i;
                    }
                    sql.append(")");
                    if (j < size - 1) {
                        sql.append(',');
                    }
                    ++j;
                }
                if (!returnIds) {
                    SQLRowValues.insertCount(insert0.table, sql.toString());
                    res = null;
                } else {
                    res = SQLRowValues.insertIDs(insert0.table, sql.toString());
                }
                long afterHandle = afterExecute = System.nanoTime();
                SQLRequestLog.log(query, "multiple similar insert", conn, timeMs, time, afterCache, afterQueryInfo, afterExecute, afterHandle, System.nanoTime(), queries.size());
                return res;
            }
        });
    }
}

