/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.ui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.view.list.RowValuesTable;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.ui.table.TableCellRendererUtils;
import org.openconcerto.utils.CollectionUtils;

public class QteMultipleRowValuesRenderer
extends DefaultTableCellRenderer {
    private static final Color red = new Color(255, 31, 52);
    private static final Color redGrey = new Color(224, 115, 137);
    private static final Color redLightGrey = new Color(240, 65, 85);

    public QteMultipleRowValuesRenderer() {
        AlternateTableCellRenderer.setBGColorMap(this, CollectionUtils.createMap(red, redLightGrey, redGrey, redLightGrey));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableCellRendererUtils.setColors(comp, table, isSelected);
        ((JLabel)comp).setHorizontalAlignment(4);
        if (table instanceof RowValuesTable) {
            int qteAchat;
            Number qte;
            RowValuesTableModel model = ((RowValuesTable)table).getRowValuesTableModel();
            SQLRowValues rowVals = model.getRowValuesAt(row);
            Number qteM = (Number)rowVals.getObject("QTE_ACHAT");
            if (qteM == null) {
                qteM = 0;
            }
            if ((qte = (Number)rowVals.getObject("QTE")) == null) {
                qte = 0;
            }
            if ((qteAchat = qteM.intValue()) != 0 && qte.intValue() % qteAchat != 0) {
                if (!isSelected) {
                    comp.setBackground(red);
                } else {
                    comp.setBackground(redGrey);
                }
                return comp;
            }
        }
        return comp;
    }
}

