/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.product.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class PriceByQty {
    private long qty;
    private BigDecimal price;
    private Date startDate;

    public PriceByQty(long qty, BigDecimal price, Date startDate) {
        this.qty = qty;
        this.price = price;
        this.startDate = startDate;
    }

    public static BigDecimal getPriceForQty(int qty, List<PriceByQty> list) {
        return PriceByQty.getPriceForQty(qty, list, new Date(System.currentTimeMillis()));
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public static BigDecimal getPriceForQty(int qty, List<PriceByQty> list, Date d) {
        BigDecimal result = null;
        Collections.sort(list, new Comparator<PriceByQty>(){

            @Override
            public int compare(PriceByQty o1, PriceByQty o2) {
                int i = (int)(o1.qty - o2.qty);
                if (i != 0) {
                    return i;
                }
                return o1.startDate.compareTo(o2.startDate);
            }
        });
        for (PriceByQty priceByQty : list) {
            if (priceByQty.qty > (long)qty) {
                if (result != null) break;
                result = priceByQty.price;
                break;
            }
            if (result != null && !priceByQty.startDate.before(d)) continue;
            result = priceByQty.price;
        }
        return result;
    }

    public static void main(String[] args) {
        ArrayList<PriceByQty> l = new ArrayList<PriceByQty>();
        long currentTimeMillis = System.currentTimeMillis();
        l.add(new PriceByQty(50L, new BigDecimal(11), new Date(currentTimeMillis)));
        l.add(new PriceByQty(1L, new BigDecimal(14), new Date(currentTimeMillis + 2000L)));
        l.add(new PriceByQty(1L, new BigDecimal(13), new Date(currentTimeMillis - 5000L)));
        l.add(new PriceByQty(1L, new BigDecimal(12), new Date(currentTimeMillis)));
        System.out.println(PriceByQty.getPriceForQty(0, l));
        System.out.println(PriceByQty.getPriceForQty(1, l));
        System.out.println(PriceByQty.getPriceForQty(49, l));
        System.out.println(PriceByQty.getPriceForQty(50, l));
    }
}

