/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.action;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import org.openconcerto.erp.config.Gestion;
import org.openconcerto.sql.Configuration;
import org.openconcerto.ui.FrameUtil;
import org.openconcerto.ui.state.WindowStateManager;

public abstract class CreateFrameAbstractAction
extends AbstractAction {
    protected boolean mustLoadState = true;

    protected CreateFrameAbstractAction() {
    }

    protected CreateFrameAbstractAction(String name) {
        super(name);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFrame frame = this.createFrame();
        CreateFrameAbstractAction.initFrame(frame, this, Configuration.getInstance(), this.mustLoadState);
        FrameUtil.show(frame);
    }

    protected static void initFrame(JFrame frame, Action action, Configuration conf, boolean mustLoadState) {
        frame.setIconImages(Gestion.getFrameIcon());
        Object name = action.getValue("Name");
        WindowStateManager stateManager = null;
        if (name != null) {
            if (conf == null) {
                System.err.println("Warning: no configuration for action " + action + ", unable to use a window state manager.");
            } else {
                stateManager = new WindowStateManager(frame, new File(conf.getConfDir(), "Configuration" + File.separator + "Frame" + File.separator + name.toString() + ".xml"), true);
            }
        } else {
            System.err.println("Warning: no action name for action " + action + ", unable to use a window state manager.");
        }
        frame.pack();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int w = Math.min(d.width - 100, frame.getWidth());
        int h = Math.min(d.height - 100, frame.getHeight());
        frame.setMinimumSize(new Dimension(w, h));
        frame.setLocationRelativeTo(null);
        if (mustLoadState && stateManager != null) {
            stateManager.loadState();
        }
        frame.setDefaultCloseOperation(2);
    }

    public abstract JFrame createFrame();
}

