/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.supplychain.stock.element;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openconcerto.erp.core.sales.product.model.PriceByQty;
import org.openconcerto.erp.importer.ArrayTableModel;
import org.openconcerto.erp.importer.DataImporter;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;

public class EtatStockFromInventoryFileCreator {
    public void importArticles(File file, Date d) throws IOException, SQLException {
        SQLTable table = Configuration.getInstance().getRoot().findTable("ARTICLE");
        Map<String, SQLRowValues> articles = this.getArticles();
        DataImporter importer = new DataImporter(table){

            protected void customizeRowValuesToFetch(SQLRowValues vals) {
                vals.putRowValues("ID_STOCK").putNulls("ID", "QTE_REEL", "QTE_TH");
            }
        };
        importer.setSkipFirstLine(true);
        ArrayTableModel m = importer.createModelFrom(file);
        SQLRowValues rowValsEtatStock = new SQLRowValues(table.getTable("ETAT_STOCK"));
        rowValsEtatStock.put("DATE", d);
        SQLRow etatStock = rowValsEtatStock.commit();
        BigDecimal total = BigDecimal.ZERO;
        int i = 0;
        while (i < m.getRowCount()) {
            List o = m.getLineValuesAt(i);
            String code = o.get(0).toString();
            if (code.trim().length() == 0) break;
            String stringQty = o.get(3).toString();
            Integer qty = stringQty.trim().length() == 0 ? 0 : Integer.valueOf(stringQty);
            SQLRowValues match = articles.get(code);
            if (match != null) {
                SQLRowValues stockValues = new SQLRowValues(table.getTable("ETAT_STOCK_ELEMENT"));
                BigDecimal qtyB = new BigDecimal(qty);
                stockValues.put("QTE", qtyB);
                stockValues.put("NOM", match.getString("NOM"));
                stockValues.put("CODE", match.getString("CODE"));
                stockValues.put("ID_ARTICLE", match.getID());
                BigDecimal prc = this.getPRC(match, qty, d);
                stockValues.put("PA", prc);
                BigDecimal totalElt = prc.multiply(qtyB);
                stockValues.put("T_PA", totalElt);
                stockValues.put("ID_ETAT_STOCK", etatStock.getID());
                stockValues.commit();
                total = total.add(totalElt);
            } else {
                System.err.println("Aucun article correspondant au code " + code);
            }
            ++i;
        }
        etatStock.createEmptyUpdateRow().put("MONTANT_HA", total).commit();
    }

    public BigDecimal getPRC(SQLRowValues rowVals, int qty, Date d) {
        if (rowVals.getTable().getDBRoot().contains("ARTICLE_PRIX_REVIENT")) {
            SQLTable table = rowVals.getTable().getDBRoot().getTable("ARTICLE_PRIX_REVIENT");
            Collection prcs = rowVals.asRow().getReferentRows(table);
            BigDecimal result = null;
            ArrayList<PriceByQty> prices = new ArrayList<PriceByQty>();
            for (SQLRow row : prcs) {
                Calendar date = Calendar.getInstance();
                date.set(5, 1);
                date.set(2, 1);
                date.set(1, 2001);
                if (row.getObject("DATE") != null) {
                    date = row.getDate("DATE");
                }
                prices.add(new PriceByQty(row.getLong("QTE"), row.getBigDecimal("PRIX"), date.getTime()));
            }
            result = PriceByQty.getPriceForQty(qty, prices, d);
            if (result == null) {
                result = BigDecimal.ZERO;
            }
            return result;
        }
        return rowVals.getBigDecimal("PA_HT");
    }

    private Map<String, SQLRowValues> getArticles() throws SQLException {
        SQLTable table = Configuration.getInstance().getRoot().findTable("ARTICLE");
        SQLRowValues graph = new SQLRowValues(table);
        graph.put("ID", null);
        graph.put("CODE", null);
        graph.put("SYNC_ID", null);
        graph.put("NOM", null);
        graph.put("PA_HT", null);
        graph.putRowValues("ID_STOCK").putNulls("ID", "QTE_REEL", "QTE_TH", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE");
        SQLTable tableArtElt = table.getTable("ARTICLE_ELEMENT");
        SQLRowValues artElt = new SQLRowValues(tableArtElt);
        artElt.put("ID", null);
        artElt.put("QTE", null);
        artElt.put("QTE_UNITAIRE", null);
        artElt.put("ID_ARTICLE_PARENT", (Object)graph);
        artElt.putRowValues("ID_ARTICLE").putNulls("ID", "CODE", "NOM").putRowValues("ID_STOCK").putNulls("QTE_TH", "QTE_REEL", "QTE_LIV_ATTENTE", "QTE_RECEPT_ATTENTE");
        SQLRowValuesListFetcher fetcher = SQLRowValuesListFetcher.create(graph);
        List<SQLRowValues> results = fetcher.fetch();
        HashMap<String, SQLRowValues> vals = new HashMap<String, SQLRowValues>();
        for (SQLRowValues sqlRowValues : results) {
            Collection referentRows = sqlRowValues.getReferentRows(tableArtElt.getField("ID_ARTICLE_PARENT"));
            if (referentRows.size() != 0) continue;
            String code = sqlRowValues.getString("CODE");
            vals.put(code, sqlRowValues);
        }
        return vals;
    }
}

