/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.rights;

import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.Configuration;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.ui.group.Group;
import org.openconcerto.ui.group.Item;
import org.openconcerto.utils.i18n.TranslationManager;

public class GroupItemUIComboItem {
    private final String id;
    private final SQLElement elt;

    public GroupItemUIComboItem(String id, SQLElement elt) {
        this.id = id;
        this.elt = elt;
    }

    public String getId() {
        return this.id;
    }

    public String getTranslation() {
        String fieldLabel;
        String translationForItem = TranslationManager.getInstance().getTranslationForItem(this.id);
        if (translationForItem != null && translationForItem.trim().length() > 0) {
            return translationForItem;
        }
        if (this.elt.getTable().contains(this.id) && (fieldLabel = Configuration.getInstance().getTranslator().getLabelFor(this.elt.getTable().getField(this.id))) != null && fieldLabel.trim().length() > 0) {
            return fieldLabel;
        }
        return this.id;
    }

    public String toString() {
        return this.getTranslation();
    }

    public static List<GroupItemUIComboItem> getComboMenu(Group g, SQLElement elt) {
        ArrayList<GroupItemUIComboItem> result = new ArrayList<GroupItemUIComboItem>();
        GroupItemUIComboItem.getSubMenu(g, result, elt);
        return result;
    }

    private static void getSubMenu(Group g, List<GroupItemUIComboItem> result, SQLElement elt) {
        int size = g.getSize();
        int i = 0;
        while (i < size) {
            Item item = g.getItem(i);
            result.add(new GroupItemUIComboItem(item.getId(), elt));
            if (item instanceof Group) {
                GroupItemUIComboItem.getSubMenu((Group)item, result, elt);
            }
            ++i;
        }
    }
}

