/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.sales.invoice.action;

import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.openconcerto.erp.core.finance.payment.element.EncaisserMontantSQLElement;
import org.openconcerto.erp.core.sales.invoice.action.ImportReglementSage;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.ui.SwingThreadUtils;
import org.openconcerto.utils.ExceptionHandler;

public class ImportReglementSageAction
extends AbstractAction {
    private final EncaisserMontantSQLElement elt;

    public ImportReglementSageAction(EncaisserMontantSQLElement elt) {
        this.elt = elt;
        this.putValue("Name", "Import XML des r\u00e9glements depuis Sage");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Frame frame = SwingThreadUtils.getAncestorOrSelf(Frame.class, (Component)e.getSource());
        final FileDialog fd = new FileDialog(frame, "Import XML des r\u00e9glements Sage", 0);
        if (fd.getFile() != null) {
            try {
                SQLUtils.executeAtomic(this.elt.getTable().getDBSystemRoot().getDataSource(), new ConnectionHandlerNoSetup<Object, IOException>(){

                    @Override
                    public Object handle(SQLDataSource ds) throws SQLException, IOException {
                        ImportReglementSage sageImporter = new ImportReglementSage(ImportReglementSageAction.this.elt);
                        try {
                            sageImporter.importFromFile(new File(fd.getDirectory(), fd.getFile()));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            new SQLException(e);
                        }
                        return null;
                    }
                });
                JOptionPane.showMessageDialog(null, "Import des paiements termin\u00e9s!");
            }
            catch (IOException exn) {
                ExceptionHandler.handle(frame, "Erreur lors de la lecture du fichier", exn);
            }
            catch (SQLException exn) {
                ExceptionHandler.handle(frame, "Erreur lors de l'insertion des paiements dans la base", exn);
            }
        }
        fd.setVisible(true);
    }
}

