/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.core.common.ui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import org.openconcerto.erp.core.common.ui.AbstractArticleItemTable;
import org.openconcerto.erp.core.common.ui.AjoutDeclinaisonTableModel;
import org.openconcerto.erp.core.sales.product.element.ReferenceArticleSQLElement;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLRowValuesListFetcher;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.ComboSQLRequest;
import org.openconcerto.sql.sqlobject.IComboModel;
import org.openconcerto.sql.sqlobject.SQLRequestComboBox;
import org.openconcerto.sql.view.list.RowValuesTableModel;
import org.openconcerto.ui.DefaultGridBagConstraints;
import org.openconcerto.ui.FontUtils;

public class AjoutDeclinaisonButton
extends JButton
implements ActionListener {
    AbstractArticleItemTable itemTable;

    public AjoutDeclinaisonButton(AbstractArticleItemTable itemTable) {
        super("Ajouter des d\u00e9clinaisons");
        this.itemTable = itemTable;
        this.addActionListener(this);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(true);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final JFrame f = new JFrame(this.getText());
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        DefaultGridBagConstraints c = new DefaultGridBagConstraints();
        c.gridx = 0;
        c.weightx = 0.0;
        p.add((Component)new JLabel("Article virtuel", 4), c);
        ++c.gridx;
        String variant1ForeignFieldName = "ID_ARTICLE_DECLINAISON_COULEUR";
        String variant2ForeignFieldName = "ID_ARTICLE_DECLINAISON_TAILLE";
        final SQLRequestComboBox combo = new SQLRequestComboBox(false);
        ReferenceArticleSQLElement articleElement = this.itemTable.getSQLElement().getDirectory().getElement(ReferenceArticleSQLElement.class);
        SQLTable articleTable = articleElement.getTable();
        Where where = new Where((FieldRef)articleTable.getField("VIRTUEL"), "=", (Object)true).and(new Where((FieldRef)articleTable.getField("OBSOLETE"), "=", (Object)false));
        IComboModel comboModel = new IComboModel(articleElement.createComboRequest(null, where));
        comboModel.getRequest().keepRows(ComboSQLRequest.KeepMode.ROW);
        comboModel.getRequest().setWhere(where);
        combo.uiInit(comboModel);
        p.add((Component)combo, c);
        final AjoutDeclinaisonTableModel model = new AjoutDeclinaisonTableModel();
        final JTable table = new JTable(model);
        final JTextField tf = new JTextField();
        tf.setHorizontalAlignment(4);
        DefaultCellEditor editor = new DefaultCellEditor(tf){

            @Override
            public Object getCellEditorValue() {
                String str = (String)super.getCellEditorValue();
                if (str == null || str.length() == 0) {
                    return 0;
                }
                try {
                    int i = Integer.parseInt(str);
                    if (i < 0) {
                        i = 0;
                    }
                    return i;
                }
                catch (Exception ex) {
                    return 0;
                }
            }
        };
        table.setRowHeight(FontUtils.getPreferredRowHeight(table));
        table.setDefaultEditor(Integer.class, editor);
        tf.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                tf.selectAll();
            }
        });
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 2;
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 1;
        p.add((Component)new JScrollPane(table), c);
        JButton bAnnuler = new JButton("Annuler");
        JButton bAjouter = new JButton("Ajouter");
        JPanel buttons = new JPanel();
        buttons.setLayout(new FlowLayout());
        buttons.add(bAnnuler);
        buttons.add(bAjouter);
        c.anchor = 14;
        ++c.gridy;
        c.fill = 0;
        p.add((Component)buttons, c);
        f.setContentPane(p);
        f.setDefaultCloseOperation(2);
        f.setSize(800, 600);
        f.setLocationRelativeTo(this);
        f.setVisible(true);
        combo.addValueListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println("AjoutDeclinaisonButton.actionPerformed(...).new PropertyChangeListener() {...}.propertyChange()");
                combo.setEnabled(false);
                final SQLRow selectedRowArticle = combo.getSelectedRow();
                if (selectedRowArticle != null) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            DBRoot root = (this).AjoutDeclinaisonButton.this.itemTable.getSQLElement().getTable().getDBRoot();
                            SQLField variant1 = selectedRowArticle.getTable().getField("ID_ARTICLE_DECLINAISON_COULEUR");
                            SQLField variant2 = selectedRowArticle.getTable().getField("ID_ARTICLE_DECLINAISON_TAILLE");
                            model.loadFrom(root, selectedRowArticle, variant1, variant2, table);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    combo.setEnabled(true);
                                }
                            });
                        }
                    });
                    t.start();
                }
            }
        });
        bAnnuler.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                f.dispose();
            }
        });
        bAjouter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TableCellEditor cellEditor = table.getCellEditor();
                if (cellEditor != null && table.isEditing()) {
                    cellEditor.stopCellEditing();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        this.fetchAndClose(f, model);
                    }
                });
            }

            private void fetchAndClose(JFrame f2, AjoutDeclinaisonTableModel model2) {
                RowValuesTableModel rowValuesTableModel = AjoutDeclinaisonButton.this.itemTable.getRowValuesTable().getRowValuesTableModel();
                List<SQLRowValues> values = model2.getFilledArticles(rowValuesTableModel.getSQLElement().getTable());
                System.err.println("AjoutDeclinaisonButton.actionPerformed(...).new ActionListener() {...}.actionPerformed() TODO : remplir et ajouter : " + values);
                ArrayList<Number> idsArt = new ArrayList<Number>();
                HashMap<Number, Integer> mapQte = new HashMap<Number, Integer>();
                for (SQLRowValues sqlRowValues : values) {
                    Number foreignIDNumber = sqlRowValues.getForeignIDNumber("ID_ARTICLE");
                    idsArt.add(foreignIDNumber);
                    mapQte.put(foreignIDNumber, sqlRowValues.getInt("QTE"));
                }
                Set<String> fieldsFrom = AjoutDeclinaisonButton.this.itemTable.getCodeCompletionManager().getFieldsFrom();
                SQLRowValues rowValsArtFetch = new SQLRowValues(rowValuesTableModel.getSQLElement().getTable().getForeignTable("ID_ARTICLE"));
                rowValsArtFetch.putNulls(rowValsArtFetch.getTable().getFieldsName());
                List<SQLRowValues> artsFetched = SQLRowValuesListFetcher.create(rowValsArtFetch).fetch(new Where(rowValsArtFetch.getTable().getKey(), idsArt));
                for (SQLRowValues sqlRowValues : artsFetched) {
                    SQLRowValues row2Insert = new SQLRowValues(AjoutDeclinaisonButton.this.itemTable.getDefaultRowValues());
                    row2Insert.put("ID_ARTICLE", sqlRowValues.getID());
                    row2Insert.put("QTE", Math.round(((Integer)mapQte.get(sqlRowValues.getIDNumber())).intValue()));
                    row2Insert.put("CODE", sqlRowValues.getObject("CODE"));
                    row2Insert.put("NOM", sqlRowValues.getObject("NOM"));
                    AjoutDeclinaisonButton.this.itemTable.getRowValuesTable().getRowValuesTableModel().addRowAt(0, row2Insert);
                    AjoutDeclinaisonButton.this.itemTable.getCodeCompletionManager().fillRowValues(sqlRowValues, fieldsFrom, row2Insert);
                }
                f2.dispose();
            }
        });
    }
}

