/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public final class RandomAccessFileInputStream
extends InputStream {
    private final RandomAccessFile r;
    private final boolean closeUnderlying;

    public RandomAccessFileInputStream(RandomAccessFile r) {
        this(r, true);
    }

    public RandomAccessFileInputStream(RandomAccessFile r, boolean closeUnderlying) {
        this.r = r;
        this.closeUnderlying = closeUnderlying;
    }

    @Override
    public final int read() throws IOException {
        return this.r.read();
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        return this.r.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        long len;
        if (n <= 0L) {
            return 0L;
        }
        long pos = this.r.getFilePointer();
        long newpos = pos + n;
        if (newpos > (len = this.r.length())) {
            newpos = len;
        }
        this.r.seek(newpos);
        return newpos - pos;
    }

    @Override
    public final void close() throws IOException {
        if (this.closeUnderlying) {
            this.r.close();
        }
    }
}

