/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils.cc;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import org.openconcerto.utils.cc.I2ExnFactory;

public class ExceptionFuture<V, X extends Exception, X2 extends Exception>
extends FutureTask<V> {
    private final Class<X2> exnClass;

    public ExceptionFuture(I2ExnFactory<? extends V, ? extends X, ? extends X2> cl, Class<X2> exnClass) {
        super(cl::createChecked);
        this.exnClass = exnClass;
    }

    public final V getWithOriginalException() throws InterruptedException, X, X2 {
        try {
            return this.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (this.exnClass.isInstance(cause)) {
                throw (Exception)this.exnClass.cast(cause);
            }
            Exception casted = (Exception)cause;
            throw casted;
        }
    }

    public static class OneExceptionFuture<V, X extends Exception>
    extends ExceptionFuture<V, X, RuntimeException> {
        public <X2 extends RuntimeException> OneExceptionFuture(I2ExnFactory<? extends V, ? extends X, ? extends RuntimeException> cl) {
            super(cl, RuntimeException.class);
        }
    }
}

