/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.utils;

import com.ibm.icu.lang.UCharacter;
import java.awt.FontMetrics;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openconcerto.utils.Log;
import org.openconcerto.utils.MessageDigestUtils;
import org.openconcerto.utils.Tuple2;

public class StringUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    public static final Charset UTF16 = Charset.forName("UTF-16");
    public static final Charset ASCII = Charset.forName("US-ASCII");
    public static final Charset ISO8859_1 = Charset.forName("ISO-8859-1");
    public static final Charset ISO8859_15 = Charset.forName("ISO-8859-15");
    public static final Charset Cp1252 = Charset.forName("Cp1252");
    public static final Charset Cp850 = Charset.forName("Cp850");
    public static final char BOM = '\ufeff';
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private static final Pattern singleQuote = Pattern.compile("'", 16);
    public static final Pattern SINGLE_QUOTED_PATTERN = Pattern.compile("'(('')|[^'])*'");
    private static final Pattern twoSingleQuote = Pattern.compile("''", 16);
    private static final Pattern quotePatrn = Pattern.compile("\"", 16);
    private static final Pattern slashPatrn = Pattern.compile("(\\\\+)");
    public static final Search EXACT_SEARCH = new Search(){

        @Override
        public boolean startsWith(String str, String prefix) {
            return str.startsWith(prefix);
        }

        @Override
        public boolean equals(String str, String anotherString) {
            return str.equals(anotherString);
        }

        @Override
        public boolean endsWith(String str, String suffix) {
            return str.endsWith(suffix);
        }

        @Override
        public boolean contains(String str, String searchStr) {
            return str.contains(searchStr);
        }
    };
    public static final Search SIMPLE_CASE_MAPPING_SEARCH = new Search(){

        @Override
        public boolean startsWith(String str, String prefix) {
            return str.regionMatches(true, 0, prefix, 0, prefix.length());
        }

        @Override
        public boolean equals(String str, String anotherString) {
            return str.equalsIgnoreCase(anotherString);
        }

        @Override
        public boolean endsWith(String str, String suffix) {
            int suffixLength = suffix.length();
            return str.regionMatches(true, str.length() - suffixLength, suffix, 0, suffixLength);
        }

        @Override
        public boolean contains(String str, String searchStr) {
            int length = searchStr.length();
            if (length == 0) {
                return true;
            }
            int i = str.length() - length;
            while (i >= 0) {
                if (str.regionMatches(true, i, searchStr, 0, length)) {
                    return true;
                }
                --i;
            }
            return false;
        }
    };
    public static final Search DEFAULT_LOWERCASE_MAPPING_SEARCH = new NormalizeSearch(){

        @Override
        protected String normalize(String s) {
            return s.toLowerCase();
        }
    };
    public static final Search CASE_FOLDING_SEARCH = new NormalizeSearch(){

        @Override
        protected String normalize(String s) {
            return StringUtils.normalizeCase(s);
        }
    };
    private static final Pattern BLANK_PATTERN = Pattern.compile("\\p{Blank}+");
    private static final Pattern DIACRITICAL_PATTERN = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");

    public static String firstUpThenLow(String s) {
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1).toLowerCase();
    }

    public static String firstUp(String s) {
        if (s.length() == 0) {
            return s;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0, 1).toUpperCase()) + s.substring(1);
    }

    public static final int getLeastMaximum() {
        return Shortener.ORDERED[Shortener.ORDERED.length - 1].getMinStringLength();
    }

    private static final Shortener getShortener(int l) {
        Shortener[] shortenerArray = Shortener.ORDERED;
        int n = Shortener.ORDERED.length;
        int n2 = 0;
        while (n2 < n) {
            Shortener sh = shortenerArray[n2];
            if (l >= sh.getMinStringLength()) {
                return sh;
            }
            ++n2;
        }
        return null;
    }

    public static final String getBoundedLengthString(String s, int maxLength) throws IllegalArgumentException {
        if (maxLength < StringUtils.getLeastMaximum()) {
            throw new IllegalArgumentException("Maximum too low : " + maxLength + "<" + StringUtils.getLeastMaximum());
        }
        String res = s.length() <= maxLength ? s : StringUtils.getShortener(maxLength).shorten(s, maxLength);
        return res;
    }

    public static String getFixedWidthString(String s, int width, Side align) {
        return StringUtils.getFixedWidthString(s, width, align, false);
    }

    public static String getFixedWidthString(String s, int width, Side align, boolean allowShorten) {
        int length = s.length();
        String res = length == width ? s : (length < width ? StringUtils.appendFixedWidthString(new StringBuilder(width), s, width, align, ' ', false).toString() : StringUtils.getTooWideString(s, width, allowShorten));
        assert (res.length() == width);
        return res;
    }

    private static String getTooWideString(String s, int width, boolean allowShorten) {
        assert (s.length() > width);
        if (!allowShorten) {
            throw new IllegalArgumentException("Too wide : " + s.length() + " > " + width);
        }
        return StringUtils.getBoundedLengthString(s, width);
    }

    public static StringBuilder appendFixedWidthString(StringBuilder sb, String s, int width, Side align, char filler, boolean allowShorten) {
        int origBuilderLen = sb.length();
        int length = s.length();
        if (length <= width) {
            sb.ensureCapacity(origBuilderLen + width);
            if (align == Side.LEFT) {
                sb.append(s);
            }
            int i = length;
            while (i < width) {
                sb.append(filler);
                ++i;
            }
            if (align == Side.RIGHT) {
                sb.append(s);
            }
        } else {
            sb.append(StringUtils.getTooWideString(s, width, allowShorten));
        }
        assert (sb.length() == origBuilderLen + width);
        return sb;
    }

    public static final List<String> fastSplit(String string, char sep) {
        ArrayList<String> l = new ArrayList<String>();
        int length = string.length();
        char[] cars = string.toCharArray();
        int rfirst = 0;
        int i = 0;
        while (i < length) {
            if (cars[i] == sep) {
                l.add(new String(cars, rfirst, i - rfirst));
                rfirst = i + 1;
            }
            ++i;
        }
        if (rfirst < length) {
            l.add(new String(cars, rfirst, length - rfirst));
        }
        return l;
    }

    public static final List<String> fastSplitTrimmed(String string, char sep) {
        ArrayList<String> l = new ArrayList<String>();
        int length = string.length();
        char[] cars = string.toCharArray();
        int rfirst = 0;
        int i = 0;
        while (i < length) {
            if (cars[i] == sep) {
                l.add(new String(cars, rfirst, i - rfirst).trim());
                rfirst = i + 1;
            }
            ++i;
        }
        if (rfirst < length) {
            l.add(new String(cars, rfirst, length - rfirst).trim());
        }
        return l;
    }

    public static String splitString(String s, int nbCharMaxLine) {
        if (s == null) {
            return s;
        }
        if (s.trim().length() < nbCharMaxLine) {
            return s;
        }
        StringBuffer lastString = new StringBuffer();
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char charAt;
            if (lastString.length() == nbCharMaxLine) {
                int esp = lastString.lastIndexOf(" ");
                if (result.length() > 0 && result.charAt(result.length() - 1) != '\n') {
                    result.append("\n");
                }
                if (esp > 0) {
                    result.append(lastString.substring(0, esp).toString().trim());
                    lastString = new StringBuffer(lastString.substring(esp, lastString.length()));
                } else {
                    result.append(lastString.toString().trim());
                    lastString = new StringBuffer();
                }
                result.append("\n");
            }
            if ((charAt = s.charAt(i)) == '\n') {
                lastString.append(charAt);
                result.append(lastString);
                lastString = new StringBuffer();
            } else {
                lastString.append(charAt);
            }
            ++i;
        }
        if (result.length() > 0 && result.charAt(result.length() - 1) != '\n') {
            result.append("\n");
        }
        result.append(lastString.toString().trim());
        return result.toString();
    }

    public static int firstIndexOf(String s, char[] chars) {
        return StringUtils.firstIndexOf(s, 0, chars);
    }

    public static int firstIndexOf(String s, int offset, char[] chars) {
        int res = -1;
        char[] cArray = chars;
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            int index = s.indexOf(c, offset);
            if (index >= 0 && (res == -1 || index < res)) {
                res = index;
            }
            ++n2;
        }
        return res;
    }

    public static final String singleQuote(String s) {
        if (s.isEmpty()) {
            return "''";
        }
        return "'" + singleQuote.matcher(s).replaceAll("''") + "'";
    }

    public static final String unSingleQuote(String s) {
        if (!SINGLE_QUOTED_PATTERN.matcher(s).matches()) {
            throw new IllegalArgumentException("Invalid quoted string " + s);
        }
        return StringUtils.unSingleQuoteUnsafe(s);
    }

    private static String unSingleQuoteUnsafe(String s) {
        return twoSingleQuote.matcher(s.substring(1, s.length() - 1)).replaceAll("'");
    }

    public static final String unSingleQuote(Matcher m) {
        if (m.pattern() != SINGLE_QUOTED_PATTERN) {
            throw new IllegalArgumentException("Matcher not from SINGLE_QUOTED_PATTERN : " + m);
        }
        return StringUtils.unSingleQuoteUnsafe(m.group());
    }

    public static String doubleQuote(String s) {
        return StringUtils.doubleQuote(s, true);
    }

    public static String doubleQuote(String s, boolean escapeEscapeChar) {
        if (s.length() > 0) {
            if (escapeEscapeChar) {
                s = slashPatrn.matcher(s).replaceAll("$1$1");
            }
            s = quotePatrn.matcher(s).replaceAll("\\\\\"");
        }
        return String.valueOf('\"') + s + '\"';
    }

    public static String unDoubleQuote(String s) {
        Tuple2<String, Integer> res = StringUtils.unDoubleQuote(s, 0);
        if (res.get1().intValue() != s.length()) {
            throw new IllegalArgumentException("Extra content at the end : " + s.substring(res.get1()));
        }
        return res.get0();
    }

    public static Tuple2<String, Integer> unDoubleQuote(String s, int offset) {
        if (s.charAt(offset) != '\"') {
            throw new IllegalArgumentException("Expected quote but got : " + s.charAt(offset));
        }
        int l = s.length();
        if (offset + 1 < l && s.charAt(offset + 1) == '\"') {
            return Tuple2.create("", offset + 2);
        }
        ++offset;
        char[] chars = new char[]{'\"', '\\'};
        StringBuilder sb = new StringBuilder(512);
        boolean foundEnd = false;
        while (offset < l && !foundEnd) {
            int index = StringUtils.firstIndexOf(s, offset, chars);
            if (index < 0) {
                throw new IllegalArgumentException("End quote not found after " + offset);
            }
            sb.append(s.substring(offset, index));
            if (s.charAt(index) == '\"') {
                offset = index + 1;
                foundEnd = true;
                continue;
            }
            assert (s.charAt(index) == '\\');
            sb.append(s.charAt(index + 1));
            offset = index + 2;
        }
        if (!foundEnd) {
            throw new IllegalArgumentException("End quote not found after " + offset);
        }
        return Tuple2.create(sb.toString(), offset);
    }

    public static String rightAlign(String s, int width) {
        String r = s;
        int n = width - s.length();
        int i = 0;
        while (i < n) {
            r = String.valueOf(' ') + r;
            ++i;
        }
        return r;
    }

    public static String leftAlign(String s, int width) {
        String r = s;
        int n = width - s.length();
        int i = 0;
        while (i < n) {
            r = String.valueOf(r) + ' ';
            ++i;
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    public static String trim(String s, boolean leading) {
        block2: {
            end = s.length();
            st = 0;
            if (!leading) ** GOTO lbl9
            while (st < end && s.charAt(st) <= ' ') {
                ++st;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                --end;
lbl9:
                // 2 sources

                ** while (st < end && s.charAt((int)(end - 1)) <= ' ')
            }
        }
        return st > 0 || end < s.length() ? s.substring(st, end) : s;
    }

    public static String limitLength(String s, int maxLength) {
        if (s.length() <= maxLength) {
            return s;
        }
        return s.substring(0, maxLength);
    }

    public static String removeAllSpaces(String text) {
        int length = text.length();
        StringBuilder builder = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            if (c <= ' ' && c != '\u00a0') {
                builder.append(c);
            }
            ++i;
        }
        return builder.toString();
    }

    public static String removeNonDecimalChars(String text) {
        int length = text.length();
        StringBuilder builder = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            char c = text.charAt(i);
            if (Character.isDigit(c) || c == '.' || c == '+' || c == '-') {
                builder.append(c);
            }
            ++i;
        }
        return builder.toString();
    }

    public static BigDecimal getBigDecimalFromUserText(String text) {
        if ((text = text.trim()).isEmpty() || text.equals("-")) {
            return BigDecimal.ZERO;
        }
        text = StringUtils.removeNonDecimalChars(text);
        BigDecimal result = null;
        try {
            result = new BigDecimal(text);
        }
        catch (Exception e) {
            Log.get().info(String.valueOf(text) + " is not a valid decimal");
        }
        return result;
    }

    public static List<String> wrap(String str, FontMetrics fm, int maxWidth) {
        List<String> lines = StringUtils.splitIntoLines(str);
        if (lines.size() == 0) {
            return lines;
        }
        ArrayList<String> strings = new ArrayList<String>();
        Iterator<String> iter = lines.iterator();
        while (iter.hasNext()) {
            StringUtils.wrapLineInto(iter.next(), strings, fm, maxWidth);
        }
        return strings;
    }

    public static void wrapLineInto(String line, List<String> list, FontMetrics fm, int maxWidth) {
        int width;
        int len = line.length();
        while (len > 0 && (width = fm.stringWidth(line)) > maxWidth) {
            int pos;
            int guess = len * maxWidth / width;
            String before = line.substring(0, guess).trim();
            if ((width = fm.stringWidth(before)) > maxWidth) {
                pos = StringUtils.findBreakBefore(line, guess);
            } else {
                pos = StringUtils.findBreakAfter(line, guess);
                if (pos != -1 && fm.stringWidth(before = line.substring(0, pos).trim()) > maxWidth) {
                    pos = StringUtils.findBreakBefore(line, guess);
                }
            }
            if (pos == -1) {
                pos = guess;
            }
            list.add(line.substring(0, pos).trim());
            line = line.substring(pos).trim();
            len = line.length();
        }
        if (len > 0) {
            list.add(line);
        }
    }

    public static int findBreakBefore(String line, int start) {
        int i = start;
        while (i >= 0) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c) || c == '-') {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static int findBreakAfter(String line, int start) {
        int len = line.length();
        int i = start;
        while (i < len) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c) || c == '-') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static List<String> splitIntoLines(String str) {
        ArrayList<String> strings = new ArrayList<String>();
        int len = str.length();
        if (len == 0) {
            strings.add("");
            return strings;
        }
        int lineStart = 0;
        int i = 0;
        while (i < len) {
            char c = str.charAt(i);
            if (c == '\r') {
                int newlineLength = 1;
                if (i + 1 < len && str.charAt(i + 1) == '\n') {
                    newlineLength = 2;
                }
                strings.add(str.substring(lineStart, i));
                lineStart = i + newlineLength;
                if (newlineLength == 2) {
                    ++i;
                }
            } else if (c == '\n') {
                strings.add(str.substring(lineStart, i));
                lineStart = i + 1;
            }
            ++i;
        }
        if (lineStart < len) {
            strings.add(str.substring(lineStart));
        }
        return strings;
    }

    public static String bytesToHexString(byte[] bytes, int length) {
        char[] hexChars = new char[length * 2];
        int j = 0;
        while (j < length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    public static String charToHex(char c) {
        int v = c & 0xFF;
        char[] hexChars = new char[]{hexArray[v >>> 4], hexArray[v & 0xF]};
        return new String(hexChars);
    }

    public static String bytesToHexString(byte[] bytes) {
        return StringUtils.bytesToHexString(bytes, bytes.length);
    }

    public static boolean isEmpty(String s) {
        return StringUtils.isEmpty(s, false);
    }

    public static boolean isEmpty(String s, boolean trim) {
        return s == null || (trim ? s.trim() : s).isEmpty();
    }

    public static String coalesce(String ... values) {
        return StringUtils.coalesce(false, values);
    }

    public static String coalesce(boolean trim, String ... values) {
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!StringUtils.isEmpty(s, trim)) {
                return s;
            }
            ++n2;
        }
        return null;
    }

    public static String toAsciiString(String str) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        StringBuilder b = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            int c = str.charAt(i);
            int newChar = c < 128 ? c : (c == 233 || c == 232 || c == 234 ? 101 : (c == 226 || c == 224 ? 97 : (c == 238 ? 105 : (c == 249 || c == 251 ? 117 : (c == 244 ? 111 : (c == 231 ? 99 : 32))))));
            b.append((char)newChar);
            ++i;
        }
        return b.toString();
    }

    public static final Matcher findFirstContaining(String s, Pattern ... patterns) {
        Pattern[] patternArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = patternArray[n2];
            Matcher matcher = p.matcher(s);
            if (matcher.find()) {
                return matcher;
            }
            ++n2;
        }
        return null;
    }

    public static final String normalizeBlanks(String s) {
        return BLANK_PATTERN.matcher(s.trim()).replaceAll(" ");
    }

    public static String removeDiacritical(String s) {
        return DIACRITICAL_PATTERN.matcher(Normalizer.normalize(s, Normalizer.Form.NFD)).replaceAll("");
    }

    public static final String normalizeCase(String s) {
        return UCharacter.foldCase(s, true);
    }

    public static final String normalizeForSearch(String s) {
        return StringUtils.normalizeCase(StringUtils.removeDiacritical(StringUtils.normalizeBlanks(s)));
    }

    public static final class Escaper {
        private final char esc;
        private final Map<Character, Character> substitution;
        private final Map<Character, Character> inv;

        public Escaper(char esc, char name) {
            this.esc = esc;
            this.substitution = new LinkedHashMap<Character, Character>();
            this.inv = new HashMap<Character, Character>();
            this.add(esc, name);
        }

        public Escaper add(char toRemove, char escapedName) {
            if (this.inv.containsKey(Character.valueOf(escapedName))) {
                throw new IllegalArgumentException(String.valueOf(escapedName) + " already replaces " + this.inv.get(Character.valueOf(escapedName)));
            }
            this.substitution.put(Character.valueOf(toRemove), Character.valueOf(escapedName));
            this.inv.put(Character.valueOf(escapedName), Character.valueOf(toRemove));
            return this;
        }

        public final Set<Character> getEscapedChars() {
            HashSet<Character> res = new HashSet<Character>(this.substitution.keySet());
            res.remove(Character.valueOf(this.esc));
            return res;
        }

        public final String escape(String s) {
            String res = s;
            for (Character toEsc : this.substitution.keySet()) {
                res = res.replace("" + toEsc, this.getEscaped(toEsc));
            }
            return res;
        }

        private String getEscaped(Character toEsc) {
            return String.valueOf(this.esc) + this.substitution.get(toEsc);
        }

        public final String unescape(String escaped) {
            String res = escaped;
            ArrayList<Character> toEscs = new ArrayList<Character>(this.substitution.keySet());
            Collections.reverse(toEscs);
            for (Character toEsc : toEscs) {
                res = res.replaceAll(this.getEscaped(toEsc), "" + toEsc);
            }
            return res;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Escaper) {
                Escaper o = (Escaper)obj;
                return this.esc == o.esc && this.substitution.equals(o.substitution);
            }
            return false;
        }

        public int hashCode() {
            return this.esc + this.substitution.hashCode();
        }
    }

    public static final class LowerCaseMappingSearch
    extends NormalizeSearch {
        private final Locale locale;

        public LowerCaseMappingSearch(Locale locale) {
            this.locale = locale;
        }

        public final Locale getLocale() {
            return this.locale;
        }

        @Override
        protected String normalize(String s) {
            return s.toLowerCase(this.getLocale());
        }
    }

    public static abstract class NormalizeSearch
    implements Search {
        protected abstract String normalize(String var1);

        @Override
        public boolean startsWith(String str, String prefix) {
            return this.normalize(str).startsWith(this.normalize(prefix));
        }

        @Override
        public boolean equals(String str, String anotherString) {
            return this.normalize(str).equals(this.normalize(anotherString));
        }

        @Override
        public boolean endsWith(String str, String suffix) {
            return this.normalize(str).endsWith(this.normalize(suffix));
        }

        @Override
        public boolean contains(String str, String searchStr) {
            return this.normalize(str).contains(this.normalize(searchStr));
        }
    }

    public static interface Search {
        public boolean equals(String var1, String var2);

        public boolean startsWith(String var1, String var2);

        public boolean endsWith(String var1, String var2);

        public boolean contains(String var1, String var2);
    }

    public static abstract class Shortener {
        private final int hashSize;
        private final int hashPartSize;
        private final String prefix;
        private final String suffix;
        private final int minStringLength;
        public static final Shortener Ellipsis = new Shortener(1, "", "", 1){

            @Override
            protected String shorten(String s) {
                return "\u2026";
            }
        };
        public static final Shortener JavaHashCode = new Shortener(8, "#", "#", 3){

            @Override
            protected String shorten(String s) {
                return MessageDigestUtils.asHex(MessageDigestUtils.int2bytes(s.hashCode()));
            }
        };
        public static final Shortener MD5 = new Shortener(32, "#", "#", 11){

            @Override
            protected String shorten(String s) {
                return MessageDigestUtils.getHashString(MessageDigestUtils.getMD5(), s.getBytes(UTF8));
            }
        };
        static final Shortener[] ORDERED = new Shortener[]{MD5, JavaHashCode, Ellipsis};

        protected Shortener(int hashSize, String prefix, String suffix, int minCharsBeforeAndAfter) {
            this.hashSize = hashSize;
            this.prefix = prefix;
            this.suffix = suffix;
            this.hashPartSize = this.hashSize + this.prefix.length() + this.suffix.length();
            if (minCharsBeforeAndAfter < 1) {
                throw new IllegalArgumentException("minCharsBeforeAndAfter must be at least 1: " + minCharsBeforeAndAfter);
            }
            this.minStringLength = this.hashPartSize + minCharsBeforeAndAfter * 2;
        }

        public final int getMinStringLength() {
            return this.minStringLength;
        }

        public final String getBoundedLengthString(String s, int maxLength) {
            if (maxLength < this.getMinStringLength()) {
                throw new IllegalArgumentException("Maximum too low : " + maxLength + "<" + this.getMinStringLength());
            }
            if (s.length() <= maxLength) {
                return s;
            }
            return this.shorten(s, maxLength);
        }

        final String shorten(String s, int maxLength) {
            assert (s.length() >= this.getMinStringLength());
            int toRemoveLength = s.length() - maxLength + this.hashPartSize;
            int toRemoveStartIndex = s.length() / 2 - toRemoveLength / 2;
            String toHash = s.substring(toRemoveStartIndex, toRemoveStartIndex + toRemoveLength);
            String hash = this.shorten(toHash);
            assert (this.hashSize == hash.length());
            String res = String.valueOf(s.substring(0, toRemoveStartIndex)) + this.prefix + hash + this.suffix + s.substring(toRemoveStartIndex + toRemoveLength);
            assert (res.length() == maxLength);
            return res;
        }

        protected abstract String shorten(String var1);
    }

    public static enum Side {
        LEFT,
        RIGHT;

    }
}

