/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;
import javax.swing.event.MouseInputAdapter;

public class TabReorderHandler
extends MouseInputAdapter {
    private JTabbedPane tabPane;
    private int draggedTabIndex;

    public static void enableReordering(JTabbedPane pane) {
        TabReorderHandler handler = new TabReorderHandler(pane);
        pane.addMouseListener(handler);
        pane.addMouseMotionListener(handler);
    }

    protected TabReorderHandler(JTabbedPane pane) {
        this.tabPane = pane;
        this.draggedTabIndex = -1;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.draggedTabIndex = -1;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.draggedTabIndex == -1) {
            return;
        }
        int targetTabIndex = this.tabPane.getUI().tabForCoordinate(this.tabPane, e.getX(), e.getY());
        if (targetTabIndex != -1 && targetTabIndex != this.draggedTabIndex) {
            boolean isForwardDrag = targetTabIndex > this.draggedTabIndex;
            this.tabPane.insertTab(this.tabPane.getTitleAt(this.draggedTabIndex), this.tabPane.getIconAt(this.draggedTabIndex), this.tabPane.getComponentAt(this.draggedTabIndex), this.tabPane.getToolTipTextAt(this.draggedTabIndex), isForwardDrag ? targetTabIndex + 1 : targetTabIndex);
            this.draggedTabIndex = targetTabIndex;
            this.tabPane.setSelectedIndex(this.draggedTabIndex);
        }
    }
}

