/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.ui;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;

public class FixedColumnExample
extends JFrame {
    Object[][] data;
    Object[] column;
    JTable fixedTable;
    JTable table;

    public FixedColumnExample() {
        super("Fixed Column Example");
        this.setSize(400, 150);
        this.data = new Object[][]{{"1", "11", "A", "", "", "", "", ""}, {"2", "22", "", "B", "", "", "", ""}, {"3", "33", "", "", "C", "", "", ""}, {"4", "44", "", "", "", "D", "", ""}, {"5", "55", "", "", "", "", "E", ""}, {"6", "66", "", "", "", "", "", "F"}};
        this.column = new Object[]{"fixed 1", "fixed 2", "a", "b", "c", "d", "e", "f"};
        AbstractTableModel fixedModel = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public int getRowCount() {
                return FixedColumnExample.this.data.length;
            }

            @Override
            public String getColumnName(int col) {
                return (String)FixedColumnExample.this.column[col];
            }

            @Override
            public Object getValueAt(int row, int col) {
                return FixedColumnExample.this.data[row][col];
            }
        };
        AbstractTableModel model = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return FixedColumnExample.this.column.length - 2;
            }

            @Override
            public int getRowCount() {
                return FixedColumnExample.this.data.length;
            }

            @Override
            public String getColumnName(int col) {
                return (String)FixedColumnExample.this.column[col + 2];
            }

            @Override
            public Object getValueAt(int row, int col) {
                return FixedColumnExample.this.data[row][col + 2];
            }

            @Override
            public void setValueAt(Object obj, int row, int col) {
                FixedColumnExample.this.data[row][col + 2] = obj;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return true;
            }
        };
        this.fixedTable = new JTable(fixedModel){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                FixedColumnExample.this.checkSelection(true);
            }
        };
        this.table = new JTable(model){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                FixedColumnExample.this.checkSelection(false);
            }
        };
        this.fixedTable.setAutoResizeMode(0);
        this.table.setAutoResizeMode(0);
        this.fixedTable.setSelectionMode(0);
        this.table.setSelectionMode(0);
        JScrollPane scroll = new JScrollPane(this.table);
        JViewport viewport = new JViewport();
        viewport.setView(this.fixedTable);
        viewport.setPreferredSize(this.fixedTable.getPreferredSize());
        scroll.setRowHeaderView(viewport);
        scroll.setCorner("UPPER_LEFT_CORNER", this.fixedTable.getTableHeader());
        this.getContentPane().add((Component)scroll, "Center");
    }

    private void checkSelection(boolean isFixedTable) {
        int selectedIndex;
        int fixedSelectedIndex;
        if (this.fixedTable != null && this.table != null && (fixedSelectedIndex = this.fixedTable.getSelectedRow()) != (selectedIndex = this.table.getSelectedRow())) {
            if (isFixedTable) {
                this.table.setRowSelectionInterval(fixedSelectedIndex, fixedSelectedIndex);
            } else {
                this.fixedTable.setRowSelectionInterval(selectedIndex, selectedIndex);
            }
        }
    }

    public static void main(String[] args) {
        FixedColumnExample frame = new FixedColumnExample();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.setVisible(true);
    }
}

