/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.openconcerto.sql.model.AliasedField;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.Order;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLName;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.utils.ReOrder;

final class ReOrderH2
extends ReOrder {
    public ReOrderH2(SQLTable t, ReOrder.Spec spec) {
        super(t, spec);
    }

    @Override
    public List<String> getSQL(Connection conn, BigDecimal inc) {
        SQLField oF = this.t.getOrderField();
        ArrayList<String> res = new ArrayList<String>();
        res.add("SET @inc to SELECT " + inc.toPlainString() + ";");
        res.add(this.t.getBase().quote("UPDATE %f SET %n =  -%n " + this.getWhere(), this.t, oF, oF));
        String alias = "T";
        AliasedField tID = new AliasedField(this.t.getKey(), "T");
        AliasedField tOrder = new AliasedField(oF, "T");
        SQLSelect idsToReorder = new SQLSelect(true);
        idsToReorder.addFrom(this.t, "T");
        idsToReorder.addSelect(tID);
        Where updateNulls = this.isAll() ? new Where((FieldRef)tOrder, "is", (Object)null) : null;
        Where w = new Where((FieldRef)tOrder, this.isFirstToReorderInclusive() ? "<=" : "<", (Object)this.getFirstToReorder().negate()).or(updateNulls);
        idsToReorder.setWhere(w);
        idsToReorder.addFieldOrder(tOrder, Order.desc(), Order.nullsLast());
        idsToReorder.addFieldOrder(tID, Order.asc());
        res.add("DROP TABLE IF EXISTS REORDER ;");
        String idName = this.t.getKey().getName();
        res.add("CREATE LOCAL TEMPORARY TABLE REORDER as select M.ID, " + this.getFirstOrderValue() + " +(M.ind - 1) * @inc as ORDRE from (\n" + "SELECT rownum() as ind, " + new SQLName(idName).quote() + " as ID from (" + idsToReorder.asString() + ") ) M;");
        res.add(this.t.getBase().quote("UPDATE %f %i SET %n = (\n        select M.ORDRE from REORDER M where M.ID = " + tID.getFieldRef() + ")\nwhere " + w.getClause() + ";", this.t, "T", oF));
        return res;
    }
}

