/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.utils;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.ConnectionHandlerNoSetup;
import org.openconcerto.sql.model.FieldRef;
import org.openconcerto.sql.model.SQLBase;
import org.openconcerto.sql.model.SQLDataSource;
import org.openconcerto.sql.model.SQLField;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.sql.model.SQLSystem;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.model.Where;
import org.openconcerto.sql.request.UpdateBuilder;
import org.openconcerto.sql.utils.ReOrderH2;
import org.openconcerto.sql.utils.ReOrderMySQL;
import org.openconcerto.sql.utils.ReOrderPostgreSQL;
import org.openconcerto.sql.utils.SQLUtils;
import org.openconcerto.utils.DecimalUtils;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.convertor.NumberConvertor;

public abstract class ReOrder {
    @GuardedBy(value="this")
    private static boolean AUTO_FIX_NULLS = false;
    public static final BigDecimal MIN_ORDER = BigDecimal.ZERO;
    public static final BigDecimal DISTANCE = BigDecimal.ONE;
    protected final SQLTable t;
    protected final Spec spec;
    private static Spec ALL = new Spec(){

        @Override
        public String getInc() {
            return String.valueOf(DISTANCE);
        }

        @Override
        public final Where getWhere(FieldRef order) {
            return null;
        }

        @Override
        public BigDecimal getFirstToReorder() {
            return MIN_ORDER;
        }

        @Override
        public boolean isFirstToReorderInclusive() {
            return true;
        }

        @Override
        public BigDecimal getFirst() {
            return this.getFirstToReorder();
        }
    };

    public static synchronized void setAutoFixNulls(boolean b) {
        AUTO_FIX_NULLS = b;
    }

    public static synchronized boolean isAutoFixNulls() {
        return AUTO_FIX_NULLS;
    }

    public static BigDecimal makeRoom(SQLTable t, BigDecimal roomNeeded, boolean after, BigDecimal destOrder) throws SQLException {
        return ReOrder.makeRoom(t, roomNeeded, after, destOrder, 100);
    }

    public static BigDecimal makeRoom(SQLTable t, BigDecimal roomNeeded, boolean after, BigDecimal destOrder, int initialCount) throws SQLException {
        if (roomNeeded.signum() <= 0) {
            throw new IllegalArgumentException("Negative roomNeeded");
        }
        if (initialCount < 1) {
            throw new IllegalArgumentException("Initial count too small");
        }
        BigDecimal newFirst = destOrder.add(roomNeeded);
        int count = Math.max(initialCount, roomNeeded.intValue() + 1);
        int tableRowCount = t.getRowCount();
        boolean reordered = false;
        while (!reordered) {
            reordered = ReOrder.create(t, destOrder, !after, count, newFirst).exec();
            if (!reordered && count > tableRowCount) {
                throw new IllegalStateException("Unable to reorder " + count + " rows in " + t);
            }
            count *= 10;
        }
        return after ? destOrder : newFirst;
    }

    public static Tuple2<List<BigDecimal>, BigDecimal> getFreeOrderValuesFor(int rowCount, boolean after, SQLRow r) throws SQLException {
        return ReOrder.getFreeOrderValuesFor(rowCount, after, r, ReOrder.isAutoFixNulls());
    }

    public static Tuple2<List<BigDecimal>, BigDecimal> getFreeOrderValuesFor(int rowCount, boolean after, SQLRow r, boolean autoFixNulls) throws SQLException {
        BigDecimal newOrder;
        BigDecimal inc;
        BigDecimal destOrder;
        if (rowCount == 0) {
            return Tuple2.create(Collections.emptyList(), null);
        }
        Tuple2.List2<SQLRow> seqRows = r.fetchThisAndSequentialRow(after);
        if (seqRows == null) {
            throw new IllegalStateException("Couldn't find " + r);
        }
        assert (((SQLRow)seqRows.get0()).equals(r)) : "fetchThisAndSequentialRow() failed";
        if (((SQLRow)seqRows.get0()).getOrder() == null) {
            if (!autoFixNulls) {
                throw new IllegalStateException("Row with null order : " + r);
            }
            Log.get().log(Level.WARNING, "Re-order table with null orders : " + r);
            if (!ReOrder.create(r.getTable()).exec()) {
                throw new IllegalStateException("Couldn't re-order table with null orders : " + r.getTable());
            }
            seqRows = r.fetchThisAndSequentialRow(after);
            if (seqRows == null || ((SQLRow)seqRows.get0()).getOrder() == null) {
                throw new IllegalStateException("Re-order table with null orders failed : " + seqRows);
            }
        }
        if ((destOrder = ((SQLRow)seqRows.get0()).getOrder()).compareTo(MIN_ORDER) < 0) {
            throw new IllegalStateException(seqRows.get0() + " has invalid order : " + destOrder);
        }
        BigDecimal newRowOrder = destOrder;
        SQLRow otherRow = (SQLRow)seqRows.get1();
        if (after && otherRow == null) {
            inc = DISTANCE;
            newOrder = destOrder.add(inc);
        } else {
            BigDecimal otherOrder = otherRow != null ? otherRow.getOrder() : MIN_ORDER;
            if (otherOrder.compareTo(MIN_ORDER) < 0) {
                throw new IllegalStateException(otherRow + " has invalid order : " + otherOrder);
            }
            BigDecimal minDistance = r.getTable().getOrderULP().scaleByPowerOfTen(1);
            BigDecimal places = BigDecimal.valueOf(rowCount + 1);
            BigDecimal roomNeeded = minDistance.multiply(places);
            BigDecimal roomAvailable = otherOrder.subtract(destOrder).abs();
            if (roomAvailable.compareTo(roomNeeded) < 0) {
                newRowOrder = ReOrder.makeRoom(r.getTable(), roomNeeded, after, destOrder);
                inc = minDistance;
                newOrder = after ? destOrder.add(inc) : destOrder;
            } else {
                inc = roomAvailable.divide(places, DecimalUtils.HIGH_PRECISION);
                newOrder = (after ? destOrder : otherOrder).add(inc);
            }
        }
        assert (inc.signum() > 0);
        ArrayList<BigDecimal> orders = new ArrayList<BigDecimal>(rowCount);
        int i = 0;
        while (i < rowCount) {
            orders.add(DecimalUtils.round(newOrder, r.getTable().getOrderDecimalDigits()));
            newOrder = newOrder.add(inc);
            ++i;
        }
        assert (after && newRowOrder.compareTo((BigDecimal)orders.get(0)) < 0 || !after && ((BigDecimal)orders.get(rowCount - 1)).compareTo(newRowOrder) < 0);
        return Tuple2.create(orders, newRowOrder);
    }

    public static ReOrder create(SQLTable t) {
        return ReOrder.create(t, ALL);
    }

    public static ReOrder create(SQLTable t, int first, int count) {
        return ReOrder.create(t, BigDecimal.valueOf(first), true, count, null);
    }

    public static ReOrder create(SQLTable t, BigDecimal first, boolean inclusive, int count, BigDecimal newFirst) {
        return ReOrder.create(t, new Some(t, first, inclusive, count, newFirst == null ? first : newFirst));
    }

    private static ReOrder create(SQLTable t, Spec spec) {
        SQLSystem system = t.getBase().getServer().getSQLSystem();
        if (system == SQLSystem.MYSQL) {
            return new ReOrderMySQL(t, spec);
        }
        if (system == SQLSystem.POSTGRESQL) {
            return new ReOrderPostgreSQL(t, spec);
        }
        if (system == SQLSystem.H2) {
            return new ReOrderH2(t, spec);
        }
        throw new IllegalArgumentException((Object)((Object)system) + " not supported");
    }

    protected ReOrder(SQLTable t, Spec spec) {
        this.t = t;
        if (!this.t.isOrdered()) {
            throw new IllegalArgumentException(t + " is not ordered");
        }
        this.spec = spec;
    }

    protected final boolean isAll() {
        return this.spec == ALL;
    }

    protected final BigDecimal getFirstToReorder() {
        return this.spec.getFirstToReorder();
    }

    protected final boolean isFirstToReorderInclusive() {
        return this.spec.isFirstToReorderInclusive();
    }

    protected final BigDecimal getFirstOrderValue() {
        return this.spec.getFirst();
    }

    protected final String getWhere() {
        Where w = this.spec.getWhere(null);
        return w == null ? "" : " where " + w;
    }

    protected final Where getWhere(FieldRef f) {
        return this.spec.getWhere(f);
    }

    public abstract List<String> getSQL(Connection var1, BigDecimal var2) throws SQLException;

    public final boolean exec() throws SQLException {
        final SQLTable t = this.t;
        return SQLUtils.executeAtomic(this.t.getBase().getDataSource(), new ConnectionHandlerNoSetup<Boolean, SQLException>(){

            @Override
            public Boolean handle(SQLDataSource ds) throws SQLException, SQLException {
                Connection conn = ds.getConnection();
                Statement stmt = conn.createStatement();
                if (ReOrder.this.isAll() && t.getUndefinedIDNumber() != null) {
                    UpdateBuilder updateUndef = new UpdateBuilder(t).setObject(t.getOrderField(), (Object)MIN_ORDER);
                    updateUndef.setWhere(new Where((FieldRef)t.getKey(), "=", t.getUndefinedID()));
                    stmt.execute(updateUndef.asString());
                }
                stmt.execute("SELECT " + ReOrder.this.spec.getInc());
                BigDecimal inc = NumberConvertor.toBigDecimal((Number)SQLDataSource.SCALAR_HANDLER.handle(stmt.getResultSet()));
                if (inc.compareTo(t.getOrderULP().scaleByPowerOfTen(1)) < 0) {
                    return false;
                }
                for (String s : ReOrder.this.getSQL(conn, inc)) {
                    stmt.execute(s);
                }
                t.fireTableModified(-1, Collections.singletonList(t.getOrderField().getName()));
                return true;
            }
        });
    }

    private static class Some
    implements Spec {
        private final SQLTable t;
        private final BigDecimal firstToReorder;
        private final boolean firstToReorderInclusive;
        private final BigDecimal first;
        private final BigDecimal lastToReorder;

        public Some(SQLTable t, BigDecimal first, boolean inclusive, int count, BigDecimal newFirst) {
            this.t = t;
            if (count <= 0) {
                throw new IllegalArgumentException("Negative Count : " + count);
            }
            if (first.compareTo(newFirst) > 0) {
                throw new IllegalArgumentException("New first before first : " + first + " > " + newFirst);
            }
            BigDecimal originalLastToReorder = first.add(BigDecimal.valueOf(count));
            if (newFirst.compareTo(originalLastToReorder) >= 0) {
                throw new IllegalArgumentException("New first after last to reorder : " + newFirst + " >= " + originalLastToReorder);
            }
            if (first.compareTo(MIN_ORDER) <= 0) {
                this.firstToReorder = MIN_ORDER;
                this.firstToReorderInclusive = false;
                this.first = MIN_ORDER.add(DISTANCE).max(newFirst);
                this.lastToReorder = originalLastToReorder.compareTo(this.first) > 0 ? originalLastToReorder : this.first.add(BigDecimal.valueOf(count));
            } else {
                this.firstToReorder = first;
                this.firstToReorderInclusive = inclusive;
                this.first = newFirst;
                this.lastToReorder = originalLastToReorder;
            }
            assert (this.getFirstToReorder().compareTo(this.getFirst()) <= 0 && this.getFirst().compareTo(this.getLast()) < 0 && this.getLast().compareTo(this.getLastToReorder()) <= 0);
        }

        @Override
        public final String getInc() {
            SQLField oF = this.t.getOrderField();
            SQLSyntax syntax = SQLSyntax.get(this.t);
            SQLSelect selTableLast = new SQLSelect(true);
            selTableLast.addSelect(oF, "MAX");
            String avgDistance = " cast( " + this.getLast() + " - " + this.getFirst() + " as " + syntax.getOrderType() + " ) / ( count(*) -1)";
            String res = "CASE WHEN max(" + SQLBase.quoteIdentifier(oF.getName()) + ") = (" + selTableLast.asString() + ") then " + ALL.getInc() + " else " + avgDistance + " end";
            return String.valueOf(res) + " FROM " + this.t.getSQLName().quote() + " where " + this.getWhere(null).getClause();
        }

        @Override
        public final Where getWhere(FieldRef order) {
            if (order == null) {
                order = this.t.getOrderField();
            } else if (order.getField() != this.t.getOrderField()) {
                throw new IllegalArgumentException();
            }
            return new Where(order, this.getFirstToReorder(), this.firstToReorderInclusive, this.getLastToReorder(), true);
        }

        @Override
        public final BigDecimal getFirstToReorder() {
            return this.firstToReorder;
        }

        @Override
        public boolean isFirstToReorderInclusive() {
            return this.firstToReorderInclusive;
        }

        private final BigDecimal getLastToReorder() {
            return this.lastToReorder;
        }

        @Override
        public BigDecimal getFirst() {
            return this.first;
        }

        public final BigDecimal getLast() {
            return this.getLastToReorder();
        }
    }

    static interface Spec {
        public String getInc();

        public Where getWhere(FieldRef var1);

        public BigDecimal getFirstToReorder();

        public boolean isFirstToReorderInclusive();

        public BigDecimal getFirst();
    }
}

