/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.users;

import java.awt.Color;
import java.awt.Component;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import org.openconcerto.sql.users.User;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.ui.table.AlternateTableCellRenderer;
import org.openconcerto.ui.table.TableCellRendererUtils;

public class UserTableCellRenderer
implements TableCellRenderer {
    private static JLabel label = new JLabel("timestamp");
    private static Color c = new Color(250, 240, 230);
    private static Color cDark = new Color(240, 230, 210);
    private final UserManager mngr;

    static {
        label.setOpaque(true);
        label.setBorder(new EmptyBorder(1, 1, 1, 1));
        label.setHorizontalAlignment(2);
        AlternateTableCellRenderer.setBGColorMap(label, Collections.singletonMap(c, cDark));
    }

    public UserTableCellRenderer(UserManager mngr) {
        this.mngr = mngr;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        TableCellRendererUtils.setBackgroundColor(label, table, isSelected);
        Integer v = (Integer)value;
        try {
            User u = this.mngr.getUser(v);
            if (!isSelected && u.equals(this.mngr.getCurrentUser())) {
                label.setBackground(c);
            }
            label.setText(u.getFullName());
        }
        catch (Exception e) {
            label.setText(e.getLocalizedMessage());
        }
        return label;
    }
}

