/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.h2.engine.ConnectionInfo;
import org.h2.util.StringUtils;
import org.openconcerto.sql.model.DBRoot;
import org.openconcerto.sql.model.DBStructureItem;
import org.openconcerto.sql.model.DBStructureItemDB;
import org.openconcerto.sql.model.DBStructureItemJDBC;
import org.openconcerto.sql.model.DBSystemRoot;
import org.openconcerto.sql.model.HierarchyLevel;
import org.openconcerto.sql.model.SQLServer;
import org.openconcerto.sql.model.SQLSyntax;
import org.openconcerto.utils.EnumOrderedSet;
import org.openconcerto.utils.Tuple2;
import org.openconcerto.utils.cc.ITransformer;

public class SQLSystem
extends Enum<SQLSystem> {
    public static final /* enum */ SQLSystem POSTGRESQL = new SQLSystem("PostgreSQL"){

        @Override
        void removeRootsToIgnore(Set<String> s) {
            super.removeRootsToIgnore(s);
            Iterator<String> iter = s.iterator();
            while (iter.hasNext()) {
                String r = iter.next();
                if (!r.startsWith("pg_")) continue;
                iter.remove();
            }
        }

        @Override
        public boolean isClearingPathSupported() {
            return true;
        }

        @Override
        public boolean autoCreatesFKIndex() {
            return false;
        }

        @Override
        public boolean isIndexFilterConditionSupported() {
            return true;
        }

        @Override
        public boolean isSequencesSupported() {
            return true;
        }
    };
    public static final /* enum */ SQLSystem MYSQL = new SQLSystem("MySQL"){

        @Override
        EnumSet<HierarchyLevel> createLevels() {
            return EnumSet.complementOf(EnumSet.of(HierarchyLevel.SQLSCHEMA));
        }

        @Override
        void removeRootsToIgnore(Set<String> s) {
            super.removeRootsToIgnore(s);
            s.remove("mysql");
            s.remove("performance_schema");
            s.remove("PERFORMANCE_SCHEMA");
        }

        @Override
        public boolean isInterBaseSupported() {
            return true;
        }

        @Override
        public boolean isDBPathEmpty() {
            return true;
        }

        @Override
        public boolean isFractionalSecondsSupported() {
            return false;
        }

        @Override
        public boolean isTablesCommentSupported() {
            return false;
        }
    };
    public static final /* enum */ SQLSystem H2 = new SQLSystem("H2"){
        private static final String TCP_PREFIX = "tcp://";
        private static final String ARBITRARY_BASE_NAME = "foo";

        @Override
        ITransformer<String, String> getURLTransf(final SQLServer s) {
            if (s.getSQLSystem() != this) {
                throw new IllegalArgumentException(s + " is not " + (Object)((Object)this));
            }
            return new ITransformer<String, String>(){

                @Override
                public String transformChecked(String base) {
                    return String.valueOf(s.getName()) + base + ";DATABASE_TO_UPPER=false";
                }
            };
        }

        @Override
        public boolean isClearingPathSupported() {
            return false;
        }

        @Override
        public boolean isMultipleResultSetsSupported() {
            return false;
        }

        @Override
        public boolean isSequencesSupported() {
            return true;
        }

        @Override
        public String getServerName(String host) {
            return TCP_PREFIX + host + "/";
        }

        @Override
        public Tuple2.List2<String> getHostnameAndPath(String server) {
            int pathIndex;
            String hostName;
            ConnectionInfo info = new ConnectionInfo(String.valueOf(server) + ARBITRARY_BASE_NAME);
            String name = info.getName();
            if (info.isRemote()) {
                if (!$assertionsDisabled && !name.startsWith("//")) {
                    throw new AssertionError();
                }
                int slashIndex = name.indexOf(47, 2);
                hostName = name.substring(2, slashIndex);
                pathIndex = slashIndex + 1;
            } else {
                hostName = null;
                pathIndex = 0;
            }
            return new Tuple2.List2<String>(hostName, name.substring(pathIndex, name.length() - ARBITRARY_BASE_NAME.length()));
        }

        @Override
        public boolean isPermanent(String server) {
            return !server.startsWith(SQLSystem.H2_IN_MEMORY);
        }

        @Override
        public Map<String, String> getConnectionInfo(String url) {
            Tuple2<String, Map<String, String>> settings = this.readSettingsFromURL(url);
            HashMap<String, String> res = new HashMap<String, String>();
            res.put("root", settings.get1().get(StringUtils.toUpperEnglish("SCHEMA")));
            res.put("table", settings.get1().get(StringUtils.toUpperEnglish("TABLE")));
            res.put("login", settings.get1().get(StringUtils.toUpperEnglish("USER")));
            res.put("pass", settings.get1().get(StringUtils.toUpperEnglish("PASSWORD")));
            String name = settings.get0();
            int prefix = name.indexOf(58);
            int lastSlash = name.lastIndexOf(47);
            String sysRoot = lastSlash < 0 ? name.substring(prefix + 1) : name.substring(lastSlash + 1);
            res.put("systemRoot", sysRoot);
            res.put("name", name.substring(0, name.length() - sysRoot.length()));
            return res;
        }

        private Tuple2<String, Map<String, String>> readSettingsFromURL(String origURL) throws IllegalArgumentException {
            String url = origURL;
            HashMap<String, String> prop = new HashMap<String, String>();
            int idx = url.indexOf(59);
            if (idx >= 0) {
                String[] list;
                String settings = url.substring(idx + 1);
                url = url.substring(0, idx);
                String[] stringArray = list = StringUtils.arraySplit(settings, ';', false);
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    String setting = stringArray[n2];
                    int equal = setting.indexOf(61);
                    if (equal < 0) {
                        throw new IllegalArgumentException("format error, missing =" + url);
                    }
                    String value = setting.substring(equal + 1);
                    String key = setting.substring(0, equal);
                    String old = (String)prop.get(key = StringUtils.toUpperEnglish(key));
                    if (old != null && !old.equals(value)) {
                        throw new IllegalArgumentException("DUPLICATE_PROPERTY " + key + " in " + url);
                    }
                    prop.put(key, value);
                    ++n2;
                }
            }
            return Tuple2.create(url.substring("jdbc:h2:".length()), prop);
        }
    };
    public static final /* enum */ SQLSystem MSSQL = new SQLSystem("Microsoft SQL Server"){

        @Override
        public String getJDBCName() {
            return "sqlserver";
        }

        @Override
        ITransformer<String, String> getURLTransf(final SQLServer s) {
            return new ITransformer<String, String>(){

                @Override
                public String transformChecked(String base) {
                    return "//" + s.getName() + ";databaseName=" + base;
                }
            };
        }

        @Override
        void removeRootsToIgnore(Set<String> s) {
            super.removeRootsToIgnore(s);
            Iterator<String> iter = s.iterator();
            while (iter.hasNext()) {
                String r = iter.next();
                if (!r.startsWith("db_") && !r.equals("sys")) continue;
                iter.remove();
            }
        }

        @Override
        public boolean autoCreatesFKIndex() {
            return false;
        }

        @Override
        public boolean isIndexFilterConditionSupported() {
            return true;
        }

        @Override
        public boolean isTablesCommentSupported() {
            return false;
        }
    };
    public static final /* enum */ SQLSystem DERBY = new SQLSystem("Apache Derby");
    public static final String H2_IN_MEMORY = "mem:";
    private final String label;
    private final EnumOrderedSet<HierarchyLevel> levels;
    private static final /* synthetic */ SQLSystem[] ENUM$VALUES;

    static {
        ENUM$VALUES = new SQLSystem[]{POSTGRESQL, MYSQL, H2, MSSQL, DERBY};
    }

    public static SQLSystem get(String name) {
        String normalized = name.toUpperCase();
        try {
            return SQLSystem.valueOf(normalized);
        }
        catch (IllegalArgumentException e) {
            if (normalized.equals("PSQL")) {
                return POSTGRESQL;
            }
            throw e;
        }
    }

    private SQLSystem(String label) {
        this.label = label;
        this.levels = new EnumOrderedSet<HierarchyLevel>(this.createLevels());
    }

    public String getJDBCName() {
        return this.name().toLowerCase();
    }

    public final String getLabel() {
        return this.label;
    }

    EnumSet<HierarchyLevel> createLevels() {
        return EnumSet.allOf(HierarchyLevel.class);
    }

    public final EnumOrderedSet<HierarchyLevel> getLevels() {
        return this.levels;
    }

    public final int getHops(Class<? extends DBStructureItem<?>> clazz1, Class<? extends DBStructureItem<?>> clazz2) {
        EnumOrderedSet<HierarchyLevel> levels = DBStructureItemDB.class.isAssignableFrom(clazz1) || DBStructureItemDB.class.isAssignableFrom(clazz2) ? this.getLevels() : HierarchyLevel.getAll();
        return levels.getHops(this.getLevel(clazz1), this.getLevel(clazz2));
    }

    public final HierarchyLevel getDBRootLevel() {
        return this.getLevels().getPrevious(HierarchyLevel.SQLTABLE);
    }

    public final HierarchyLevel getDBLevel(Class<? extends DBStructureItemDB> clazz) {
        if (clazz.equals(DBRoot.class)) {
            return this.getDBRootLevel();
        }
        if (clazz.equals(DBSystemRoot.class)) {
            return this.getLevels().getPrevious(this.getDBRootLevel());
        }
        throw new IllegalArgumentException(clazz + " should be either DBRoot or DBSystemRoot");
    }

    public final HierarchyLevel getLevel(Class<? extends DBStructureItem<?>> clazz) {
        if (DBStructureItemDB.class.isAssignableFrom(clazz)) {
            return this.getDBLevel(clazz.asSubclass(DBStructureItemDB.class));
        }
        return HierarchyLevel.get(clazz.asSubclass(DBStructureItemJDBC.class));
    }

    void removeRootsToIgnore(Set<String> s) {
        s.remove("information_schema");
        s.remove("INFORMATION_SCHEMA");
    }

    ITransformer<String, String> getURLTransf(final SQLServer s) {
        if (s.getSQLSystem() != this) {
            throw new IllegalArgumentException(s + " is not " + (Object)((Object)this));
        }
        return new ITransformer<String, String>(){

            @Override
            public String transformChecked(String base) {
                return "//" + s.getName() + "/" + base;
            }
        };
    }

    public String getServerName(String host) {
        return host;
    }

    public Tuple2.List2<String> getHostnameAndPath(String server) {
        Objects.requireNonNull(server, "Null server");
        return new Tuple2.List2<Object>(server, null);
    }

    public final boolean isEmbedded(String server) {
        return this.getHostnameAndPath(server).get0() == null;
    }

    public boolean isPermanent(String server) {
        return true;
    }

    public Map<String, String> getConnectionInfo(String url) {
        throw new UnsupportedOperationException();
    }

    public final boolean isNoDefaultSchemaSupported() {
        return this.isClearingPathSupported() || this.isDBPathEmpty();
    }

    public boolean isClearingPathSupported() {
        return false;
    }

    public boolean isDBPathEmpty() {
        return false;
    }

    public boolean isInterBaseSupported() {
        return false;
    }

    public boolean autoCreatesFKIndex() {
        return true;
    }

    public boolean isIndexFilterConditionSupported() {
        return false;
    }

    public boolean isFractionalSecondsSupported() {
        return true;
    }

    public boolean isTablesCommentSupported() {
        return true;
    }

    public boolean isMultipleResultSetsSupported() {
        return true;
    }

    public boolean isSequencesSupported() {
        return false;
    }

    public String getMDName(String name) {
        return name;
    }

    public final SQLSyntax getSyntax() {
        try {
            return SQLSyntax.get(this);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static SQLSystem[] values() {
        SQLSystem[] sQLSystemArray = ENUM$VALUES;
        int n = sQLSystemArray.length;
        SQLSystem[] sQLSystemArray2 = new SQLSystem[n];
        System.arraycopy(ENUM$VALUES, 0, sQLSystemArray2, 0, n);
        return sQLSystemArray2;
    }

    public static SQLSystem valueOf(String string) {
        return Enum.valueOf(SQLSystem.class, string);
    }

    /* synthetic */ SQLSystem(String string, int n, String string2, SQLSystem sQLSystem) {
        this(string2);
    }
}

