/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.model;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import net.jcip.annotations.GuardedBy;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.model.SQLRequestLogModel;
import org.openconcerto.ui.FontUtils;
import org.openconcerto.utils.ExceptionUtils;

public class SQLRequestLog {
    private static final Color BG_PINK = new Color(254, 240, 240);
    private static final String ACTIVER_LA_CAPTURE = "Enable monitoring";
    private static final String DESACTIVER_LA_CAPTURE = "Disable monitoring";
    private static Vector<SQLRequestLog> list = new Vector(500);
    @GuardedBy(value="this")
    private static boolean enabled;
    private String query;
    private String comment;
    private long startAsMs;
    private final long startTime;
    private final long afterCache;
    private final long afterQueryInfo;
    private final long afterExecute;
    private final long afterHandle;
    private final long endTime;
    private String stack;
    private boolean inSwing;
    private int connectionId;
    private boolean forShare;
    private String threadId;
    private static List<ChangeListener> listeners;
    @GuardedBy(value="EDT")
    private static JLabel textInfo;
    @GuardedBy(value="EDT")
    private static final DateFormat sdt;
    private static final DecimalFormat dformat;
    private boolean isHighlighted = false;
    private int rs_count;
    static long total_count;

    static {
        listeners = new ArrayList<ChangeListener>(2);
        sdt = new SimpleDateFormat("HH:mm:ss.SS");
        dformat = new DecimalFormat("##0.00");
        total_count = 0L;
    }

    public static synchronized void setEnabled(boolean enable) {
        enabled = enable;
    }

    public static synchronized boolean toggleEnabled() {
        boolean newVal = !SQLRequestLog.isEnabled();
        SQLRequestLog.setEnabled(newVal);
        return newVal;
    }

    public static synchronized boolean isEnabled() {
        return enabled;
    }

    private static final String format(Object nano) {
        long l = ((Number)nano).longValue();
        return l == 0L ? "" : String.valueOf(dformat.format((double)l / 1000000.0)) + " ms";
    }

    public SQLRequestLog(String query, String comment, int connectionId, long starAtMs, String ex, boolean inSwing, long startTime, long afterCache, long afterQueryInfo, long afterExecute, long afterHandle, long endTime, int count) {
        this.query = query;
        this.comment = comment;
        this.connectionId = connectionId;
        this.startAsMs = starAtMs;
        this.startTime = startTime;
        this.afterCache = afterCache;
        this.afterQueryInfo = afterQueryInfo;
        this.afterExecute = afterExecute;
        this.afterHandle = afterHandle;
        this.endTime = endTime;
        this.rs_count = count;
        this.stack = ex;
        this.inSwing = inSwing;
        this.forShare = query.contains("FOR SHARE");
        if (this.forShare) {
            this.comment = "Use FOR SHARE. " + comment;
        }
        this.threadId = "[" + Thread.currentThread().getId() + "] " + Thread.currentThread().getName();
    }

    public static void log(String query, String comment, int connectionId, long starAtMs, long startTime, long afterCache, long afterQueryInfo, long afterExecute, long afterHandle, long endTime, int count) {
        if (SQLRequestLog.isEnabled() && list.size() < 50000) {
            String ex = ExceptionUtils.getStackTrace(new Exception());
            list.add(new SQLRequestLog(query, comment, connectionId, starAtMs, ex, SwingUtilities.isEventDispatchThread(), startTime, afterCache, afterQueryInfo, afterExecute, afterHandle, endTime, count));
            SQLRequestLog.fireEvent();
        }
        ++count;
    }

    public static void log(String query, String comment, long starAtMs, long startTime) {
        SQLRequestLog.log(query, comment, 0, starAtMs, startTime, startTime, startTime, startTime, startTime, startTime, 0);
    }

    public static void log(PreparedStatement pStmt, String comment, long timeMs, long startTime, long afterCache, long afterQueryInfo, long afterExecute, long afterHandle, long endTime) {
        if (SQLRequestLog.isEnabled()) {
            try {
                SQLRequestLog.log(pStmt.toString(), comment, pStmt.getConnection(), timeMs, startTime, afterCache, afterQueryInfo, afterExecute, afterHandle, endTime, 0);
            }
            catch (Exception e) {
                Log.get().log(Level.WARNING, "Couldn't log " + pStmt, e);
            }
        }
    }

    public static void log(String query, String comment, Connection conn, long timeMs, long startTime, long afterCache, long afterQueryInfo, long afterExecute, long afterHandle, long endTime, int count) {
        SQLRequestLog.log(query, comment, System.identityHashCode(conn), timeMs, startTime, afterCache, afterQueryInfo, afterExecute, afterHandle, endTime, count);
    }

    private static void fireEvent() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int stop = listeners.size();
                int i = 0;
                while (i < stop) {
                    ((ChangeListener)listeners.get(i)).stateChanged(null);
                    ++i;
                }
                if (textInfo != null) {
                    long totalMs = SQLRequestLog.getTotalMs();
                    long totalSQLMs = SQLRequestLog.getTotalSQLMs();
                    textInfo.setText("Total: " + totalMs + " ms,  Swing: " + SQLRequestLog.getTotalSwing() + " ms, SQL: " + totalSQLMs + " ms, processing: " + (totalMs - totalSQLMs) + " ms , " + SQLRequestLog.getNbConnections() + " conn., " + SQLRequestLog.getNbThread() + " threads. Total: " + list.size() + " / " + total_count);
                }
            }
        });
    }

    protected static int getNbConnections() {
        HashSet<Integer> s = new HashSet<Integer>();
        int stop = list.size();
        int i = 0;
        while (i < stop) {
            SQLRequestLog l = list.get(i);
            if (l.getConnectionId() > 0) {
                s.add(l.getConnectionId());
            }
            ++i;
        }
        return s.size();
    }

    protected static int getNbThread() {
        HashSet<String> s = new HashSet<String>();
        int stop = list.size();
        int i = 0;
        while (i < stop) {
            SQLRequestLog l = list.get(i);
            s.add(l.getThreadId());
            ++i;
        }
        return s.size();
    }

    protected static long getTotalMs() {
        int stop = list.size();
        long t = 0L;
        int i = 0;
        while (i < stop) {
            t += list.get(i).getDurationTotalNano() / 1000L;
            ++i;
        }
        return t / 1000L;
    }

    protected static long getTotalSQLMs() {
        int stop = list.size();
        long t = 0L;
        int i = 0;
        while (i < stop) {
            t += list.get(i).getDurationSQLNano() / 1000L;
            ++i;
        }
        return t / 1000L;
    }

    protected static long getTotalSwing() {
        int stop = list.size();
        long t = 0L;
        int i = 0;
        while (i < stop) {
            SQLRequestLog requestLog = list.get(i);
            if (requestLog.isInSwing()) {
                t += requestLog.getDurationTotalNano() / 1000L;
            }
            ++i;
        }
        return t / 1000L;
    }

    public boolean isInSwing() {
        return this.inSwing;
    }

    public static void addChangeListener(ChangeListener l) {
        listeners.add(l);
    }

    public static void showFrame() {
        if (textInfo != null) {
            return;
        }
        JFrame f = new JFrame("SQL monitoring");
        final SQLRequestLogModel model = new SQLRequestLogModel();
        final JTable table = new JTable(model);
        table.setRowHeight(FontUtils.getPreferredRowHeight(table));
        final TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(table.getModel());
        table.setRowSorter(sorter);
        table.getTableHeader().setReorderingAllowed(false);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    SQLRequestLog.showStack(model, sorter, table.getSelectedRow());
                }
                SQLRequestLog.highLight(model, sorter, table.getSelectedRow());
            }
        });
        TableColumn timeCol = table.getColumnModel().getColumn(0);
        timeCol.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            protected void setValue(Object value) {
                super.setValue(sdt.format(value));
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component tableCellRendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                SQLRequestLog rowAt = model.getRowAt(sorter.convertRowIndexToModel(row));
                if (rowAt.isHighlighted) {
                    tableCellRendererComponent.setBackground(Color.black);
                    tableCellRendererComponent.setForeground(Color.white);
                } else {
                    tableCellRendererComponent.setBackground(Color.white);
                    tableCellRendererComponent.setForeground(Color.black);
                }
                return tableCellRendererComponent;
            }
        });
        timeCol.setMaxWidth(80);
        timeCol.setMinWidth(80);
        DefaultTableCellRenderer cellRendererDurationSQL = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component tableCellRendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    int b;
                    SQLRequestLog rowAt = model.getRowAt(sorter.convertRowIndexToModel(row));
                    float ratio = 1.0f;
                    if (rowAt.getDurationTotalNano() > 0L && rowAt.getDurationTotalNano() - rowAt.getDurationSQLNano() > 2000000L) {
                        ratio = (float)rowAt.getDurationSQLNano() / (float)rowAt.getDurationTotalNano();
                    }
                    if ((b = Math.round(255.0f * (ratio * ratio))) < 0) {
                        b = 0;
                    }
                    if (b > 255) {
                        b = 255;
                    }
                    tableCellRendererComponent.setBackground(new Color(255, 255, b));
                    tableCellRendererComponent.setForeground(Color.BLACK);
                }
                return tableCellRendererComponent;
            }

            @Override
            protected void setValue(Object value) {
                super.setValue(SQLRequestLog.format(value));
            }
        };
        cellRendererDurationSQL.setHorizontalAlignment(4);
        TableColumn execCol = table.getColumnModel().getColumn(1);
        execCol.setCellRenderer(cellRendererDurationSQL);
        execCol.setMaxWidth(80);
        execCol.setMinWidth(80);
        DefaultTableCellRenderer cellRendererTraitement = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel tableCellRendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    long l = ((Number)value).longValue();
                    if (l > 100000000L) {
                        tableCellRendererComponent.setBackground(new Color(254, 254, 0));
                    } else {
                        tableCellRendererComponent.setBackground(Color.WHITE);
                    }
                    tableCellRendererComponent.setForeground(Color.BLACK);
                }
                return tableCellRendererComponent;
            }

            @Override
            protected void setValue(Object value) {
                super.setValue(SQLRequestLog.format(value));
            }
        };
        cellRendererTraitement.setHorizontalAlignment(4);
        TableColumn processingCol = table.getColumnModel().getColumn(2);
        processingCol.setCellRenderer(cellRendererTraitement);
        processingCol.setMaxWidth(80);
        processingCol.setMinWidth(80);
        DefaultTableCellRenderer nanoRenderer = new DefaultTableCellRenderer(){
            {
                this.setHorizontalAlignment(4);
            }

            @Override
            protected void setValue(Object value) {
                super.setValue(SQLRequestLog.format(value));
            }
        };
        TableColumn cleanupCol = table.getColumnModel().getColumn(3);
        cleanupCol.setCellRenderer(nanoRenderer);
        cleanupCol.setMaxWidth(80);
        cleanupCol.setMinWidth(80);
        TableColumn totalCol = table.getColumnModel().getColumn(4);
        totalCol.setCellRenderer(nanoRenderer);
        totalCol.setMaxWidth(80);
        totalCol.setMinWidth(80);
        TableColumn reqCol = table.getColumnModel().getColumn(5);
        DefaultTableCellRenderer cellRendererQuery = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel tableCellRendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    SQLRequestLog rowAt = model.getRowAt(sorter.convertRowIndexToModel(row));
                    if (rowAt.isInSwing() && !rowAt.getComment().contains("cache")) {
                        tableCellRendererComponent.setBackground(BG_PINK);
                    } else {
                        tableCellRendererComponent.setBackground(Color.WHITE);
                    }
                    tableCellRendererComponent.setForeground(Color.BLACK);
                }
                return tableCellRendererComponent;
            }
        };
        reqCol.setCellRenderer(cellRendererQuery);
        reqCol.setMinWidth(400);
        DefaultTableCellRenderer cellRendererInfo = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel tableCellRendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    if (model.getRowAt(sorter.convertRowIndexToModel(row)).isForShare()) {
                        tableCellRendererComponent.setBackground(new Color(254, 254, 150));
                    } else {
                        tableCellRendererComponent.setBackground(Color.WHITE);
                    }
                    tableCellRendererComponent.setForeground(Color.BLACK);
                }
                return tableCellRendererComponent;
            }
        };
        table.getColumnModel().getColumn(6).setCellRenderer(cellRendererInfo);
        table.getColumnModel().getColumn(6).setMaxWidth(200);
        table.getColumnModel().getColumn(6).setMinWidth(80);
        table.getColumnModel().getColumn(7).setMaxWidth(80);
        table.getColumnModel().getColumn(7).setMinWidth(80);
        DefaultTableCellRenderer cellRendererThread = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel tableCellRendererComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    if (model.getRowAt(sorter.convertRowIndexToModel(row)).isInSwing()) {
                        tableCellRendererComponent.setBackground(BG_PINK);
                    } else {
                        tableCellRendererComponent.setBackground(Color.WHITE);
                    }
                    tableCellRendererComponent.setForeground(Color.BLACK);
                }
                return tableCellRendererComponent;
            }
        };
        table.getColumnModel().getColumn(8).setCellRenderer(cellRendererThread);
        table.getColumnModel().getColumn(8).setMinWidth(150);
        JPanel p = new JPanel(new BorderLayout());
        JPanel bar = new JPanel(new FlowLayout());
        final JButton b0 = new JButton();
        if (SQLRequestLog.isEnabled()) {
            b0.setText(DESACTIVER_LA_CAPTURE);
        } else {
            b0.setText(ACTIVER_LA_CAPTURE);
        }
        b0.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SQLRequestLog.toggleEnabled()) {
                    b0.setText(SQLRequestLog.ACTIVER_LA_CAPTURE);
                } else {
                    b0.setText(SQLRequestLog.DESACTIVER_LA_CAPTURE);
                }
            }
        });
        bar.add(b0);
        JButton b1 = new JButton("Clear");
        b1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SQLRequestLog.clear();
            }
        });
        bar.add(b1);
        JButton b2 = new JButton("Show stacktrace");
        b2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int s = table.getSelectedRow();
                SQLRequestLog.showStack(model, sorter, s);
            }
        });
        bar.add(b2);
        p.add((Component)bar, "North");
        table.setAutoResizeMode(0);
        table.getTableHeader().setReorderingAllowed(true);
        JScrollPane sc = new JScrollPane(table);
        p.add((Component)sc, "Center");
        textInfo = new JLabel("Total: ");
        p.add((Component)textInfo, "South");
        f.setContentPane(p);
        f.setSize(960, 480);
        f.setVisible(true);
        f.setDefaultCloseOperation(0);
        f.setVisible(true);
    }

    public static synchronized void clear() {
        list.clear();
        SQLRequestLog.fireEvent();
        total_count = 0L;
    }

    public static long getCount() {
        return total_count;
    }

    public static synchronized int getSize() {
        return list.size();
    }

    public static synchronized SQLRequestLog get(int rowIndex) {
        return list.get(rowIndex);
    }

    public String getQuery() {
        return this.query;
    }

    public String getComment() {
        return this.comment;
    }

    public long getStartAsMs() {
        return this.startAsMs;
    }

    public long getDurationTotalNano() {
        return this.getEndTime() - this.getStartTime();
    }

    public long getDurationSQLNano() {
        return this.getAfterExecute() - this.getAfterQueryInfo();
    }

    public long getDurationHandleNano() {
        return this.getAfterHandle() - this.getAfterExecute();
    }

    public long getDurationCleanupNano() {
        return this.getEndTime() - this.getAfterHandle();
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final long getAfterCache() {
        return this.afterCache;
    }

    public final long getAfterQueryInfo() {
        return this.afterQueryInfo;
    }

    public final long getAfterExecute() {
        return this.afterExecute;
    }

    public final long getAfterHandle() {
        return this.afterHandle;
    }

    public final long getEndTime() {
        return this.endTime;
    }

    public String getStack() {
        return this.stack;
    }

    public boolean isForShare() {
        return this.forShare;
    }

    public int getResultCount() {
        return this.rs_count;
    }

    public void printStack() {
        System.err.println("Stacktrace of : " + this.query);
        System.err.println(this.stack);
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public String getThreadId() {
        return this.threadId;
    }

    private static void showStack(SQLRequestLogModel model, TableRowSorter<TableModel> sorter, int s) {
        assert (SwingUtilities.isEventDispatchThread());
        if (s >= 0 && s < model.getRowCount()) {
            SQLRequestLog rowAt = model.getRowAt(sorter.convertRowIndexToModel(s));
            rowAt.printStack();
            String text = "Thread: " + rowAt.getThreadId();
            if (rowAt.isInSwing()) {
                text = String.valueOf(text) + " (Swing)";
            }
            text = String.valueOf(text) + "\nStart: " + sdt.format(rowAt.getStartAsMs()) + "\n";
            text = String.valueOf(text) + "Total duration: " + dformat.format((double)rowAt.getDurationTotalNano() / 1000000.0) + " ms, " + dformat.format((double)rowAt.getDurationSQLNano() / 1000000.0) + " ms SQL\n";
            text = String.valueOf(text) + rowAt.getQuery() + "\n" + rowAt.getStack();
            JTextArea area = new JTextArea(text);
            area.setFont(area.getFont().deriveFont(12.0f));
            area.setLineWrap(true);
            JFrame fStack = new JFrame("Stacktrace");
            fStack.setContentPane(new JScrollPane(area));
            fStack.pack();
            fStack.setSize(800, 600);
            fStack.setLocationRelativeTo(null);
            fStack.setDefaultCloseOperation(2);
            fStack.setVisible(true);
        }
    }

    protected static synchronized void highLight(SQLRequestLogModel model, TableRowSorter<TableModel> sorter, int s) {
        if (s >= 0 && s < model.getRowCount()) {
            SQLRequestLog rowAt = model.getRowAt(sorter.convertRowIndexToModel(s));
            String req = rowAt.getQuery();
            for (SQLRequestLog l : list) {
                l.isHighlighted = l.getQuery().equals(req);
            }
            model.fireTableRowsUpdated(0, model.getRowCount() - 1);
        }
    }

    public static void dump(PrintStream out) {
        DecimalFormat dformat = new DecimalFormat("##0.00");
        for (SQLRequestLog log : list) {
            out.print(String.valueOf(dformat.format((double)log.getDurationTotalNano() / 1000000.0)) + " ms ");
            out.print("\t");
            out.print(log.getQuery());
            out.println();
        }
    }
}

