/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.sql.element;

import java.awt.Component;
import java.util.Map;
import javax.swing.JPanel;
import org.openconcerto.sql.Log;
import org.openconcerto.sql.element.ElementSQLObject;
import org.openconcerto.sql.element.SQLElement;
import org.openconcerto.sql.model.SQLRow;
import org.openconcerto.sql.model.SQLRowAccessor;
import org.openconcerto.sql.model.SQLRowValues;
import org.openconcerto.sql.model.SQLSelect;
import org.openconcerto.sql.model.SQLTable;
import org.openconcerto.sql.request.SQLRowItemView;
import org.openconcerto.sql.users.UserManager;
import org.openconcerto.sql.utils.AlterTable;
import org.openconcerto.ui.component.InteractionMode;
import org.openconcerto.utils.cc.ConstantFactory;
import org.openconcerto.utils.cc.IFactory;
import org.openconcerto.utils.checks.ValidObject;

public abstract class SQLComponent
extends JPanel
implements ValidObject {
    private static final String NONINITED_CODE = new String("default " + SQLComponent.class.getName() + " code");
    public static final String READ_ONLY_FIELD = "UI_LOCK";
    public static final String READ_ONLY_VALUE = "ro";
    public static final String READ_WRITE_VALUE = "";
    public static final String READ_ONLY_USER_FIELD = "ID_USER_UI_LOCK";
    public static final String READ_ONLY_PROP = "readOnlySelection";
    private final SQLElement element;
    private String code;
    private ElementSQLObject parent;
    private boolean inited;
    private Mode mode;
    private IFactory<SQLRowValues> defaults;

    public static final AlterTable addLockFields(SQLTable t) {
        AlterTable res = new AlterTable(t);
        if (!t.contains(READ_ONLY_FIELD)) {
            res.addVarCharColumn(READ_ONLY_FIELD, 16, false, res.getSyntax().quoteString(READ_WRITE_VALUE), false);
            res.addForeignColumn(READ_ONLY_USER_FIELD, UserManager.getInstance().getTable());
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isReadOnly(SQLRowAccessor r) {
        SQLRowAccessor roRow;
        if (r.isUndefined()) {
            return true;
        }
        if (!r.getFields().contains(READ_ONLY_FIELD)) {
            Log.get().warning("UI_LOCK not provided : " + r);
            if (!r.hasID() || r.getID() == -1) return false;
            roRow = r.getTable().getRow(r.getID());
            return READ_ONLY_VALUE.equals(roRow.getString(READ_ONLY_FIELD));
        } else {
            roRow = r;
        }
        return READ_ONLY_VALUE.equals(roRow.getString(READ_ONLY_FIELD));
    }

    protected SQLComponent(SQLElement element) {
        if (element == null) {
            throw new IllegalArgumentException("null element");
        }
        this.setOpaque(true);
        this.parent = null;
        this.element = element;
        this.code = NONINITED_CODE;
        this.mode = null;
        this.inited = false;
        this.clearDefaults();
    }

    public final Mode getMode() {
        return this.mode;
    }

    public ResetMode getResetMode() {
        return ResetMode.ON_SHOW;
    }

    public final boolean isInited() {
        return this.inited;
    }

    public final void setMode(Mode m) {
        if (!m.equals((Object)this.getMode())) {
            this.mode = m;
            this.modeChanged();
        }
    }

    protected void modeChanged() {
    }

    public final boolean setEditable(boolean b) {
        return this.setEditable(b ? InteractionMode.READ_WRITE : InteractionMode.DISABLED);
    }

    public abstract boolean setEditable(InteractionMode var1);

    public abstract int insert();

    public abstract int insert(SQLRow var1);

    public abstract SQLRowValues getLastKnownDBVals();

    public final boolean updateLastKnownDBVals() {
        return this.updateLastKnownDBVals(SQLSelect.LockStrength.NONE);
    }

    public abstract boolean updateLastKnownDBVals(SQLSelect.LockStrength var1);

    public abstract void select(int var1);

    public abstract void select(SQLRowAccessor var1);

    public abstract void detach();

    public abstract int getSelectedID();

    public abstract boolean isSelectionReadOnly();

    public abstract void update();

    public abstract void archive();

    public final void uiInit() {
        if (this.isInited()) {
            throw new IllegalStateException("already inited");
        }
        this.addViews();
        this.resetValue();
        this.inited();
        this.inited = true;
    }

    protected void inited() {
    }

    protected final SQLRowValues createValidDefaults() {
        return this.checkDefaultsID(this.createDefaults());
    }

    private final SQLRowValues checkDefaultsID(SQLRowValues res) {
        if (res != null && res.hasID()) {
            throw new IllegalStateException("Defaults should be without ID : " + res);
        }
        return res;
    }

    protected SQLRowValues createDefaults() {
        return this.defaults.createChecked();
    }

    public final void clearDefaults() {
        this.setDefaultsFactory(ConstantFactory.nullFactory());
    }

    public final void setDefaults(Map<String, ?> defaults) {
        if (defaults == null) {
            throw new NullPointerException();
        }
        this.setDefaults(new SQLRowValues(this.getTable(), defaults));
    }

    public final void setDefaults(SQLRowValues defaults) {
        this.setDefaultsFactory(new ConstantFactory<SQLRowValues>(this.checkDefaultsID(defaults).toImmutable()));
    }

    public final void setDefaultsFactory(IFactory<SQLRowValues> defaults) {
        this.defaults = defaults;
    }

    protected abstract void addViews();

    public final SQLElement getElement() {
        return this.element;
    }

    protected final SQLTable getTable() {
        return this.getElement().getTable();
    }

    final void setCode(String code) {
        if (code == NONINITED_CODE) {
            throw new IllegalStateException("Cannot un-initialise");
        }
        if (this.code != NONINITED_CODE) {
            throw new IllegalStateException("Code of " + this + " already inited to " + this.code);
        }
        this.code = code;
    }

    public final String getCode() {
        return this.code;
    }

    public abstract void resetValue();

    public abstract boolean isNonExistantEditable();

    public abstract void setNonExistantEditable(boolean var1);

    void setSQLParent(ElementSQLObject parent) {
        this.parent = parent;
    }

    public final ElementSQLObject getSQLParent() {
        return this.parent;
    }

    public void analyze() {
        Component c;
        System.out.println("Analyse");
        int i = 0;
        while (i < this.getComponentCount()) {
            c = this.getComponent(i);
            System.out.println(String.valueOf(i) + ":" + c.getClass() + " , " + c);
            ++i;
        }
        System.out.println("Analyse des SQLRowView");
        i = 0;
        while (i < this.getComponentCount()) {
            c = this.getComponent(i);
            if (c instanceof SQLRowItemView) {
                SQLRowItemView r = (SQLRowItemView)((Object)c);
                System.out.println(r.getSQLName());
            } else if (c instanceof JPanel) {
                JPanel p = (JPanel)c;
                int j = 0;
                while (j < p.getComponentCount()) {
                    Component c2 = p.getComponent(j);
                    if (c2 instanceof SQLRowItemView) {
                        SQLRowItemView r = (SQLRowItemView)((Object)c2);
                        System.out.println(":" + r.getSQLName());
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public static enum Mode {
        INSERTION,
        MODIFICATION,
        READ_ONLY;

    }

    public static enum ResetMode {
        ON_SHOW(true, false),
        ON_HIDE(false, true),
        ON_BOTH(true, true);

        private final boolean onShow;
        private final boolean onHide;

        private ResetMode(boolean onShow, boolean onHide) {
            this.onShow = onShow;
            this.onHide = onHide;
        }

        public final boolean isOnShow() {
            return this.onShow;
        }

        public final boolean isOnHide() {
            return this.onHide;
        }
    }
}

