/*
 * Decompiled with CFR 0.152.
 */
package org.openconcerto.erp.generationDoc.provider;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueContext;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProvider;
import org.openconcerto.erp.generationDoc.SpreadSheetCellValueProviderManager;
import org.openconcerto.sql.model.SQLRowAccessor;

public class PrixUVProvider
implements SpreadSheetCellValueProvider {
    private final boolean shortName;
    private final DecimalFormat decimalFormat = new DecimalFormat("##,##0.00#");

    public PrixUVProvider(boolean shortName) {
        this.shortName = shortName;
    }

    @Override
    public Object getValue(SpreadSheetCellValueContext context) {
        SQLRowAccessor row = context.getRow();
        BigDecimal pv = row.getBigDecimal("PV_HT");
        if (pv.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        String result = this.decimalFormat.format(pv);
        SQLRowAccessor rMode = row.getForeign("ID_UNITE_VENTE");
        result = String.valueOf(result) + "\u20ac / " + (this.shortName ? rMode.getString("CODE") : rMode.getString("NOM"));
        return result;
    }

    public static void register() {
        SpreadSheetCellValueProviderManager.put("supplychain.element.salesunit.price", new PrixUVProvider(false));
        SpreadSheetCellValueProviderManager.put("supplychain.element.salesunit.price.short", new PrixUVProvider(true));
    }
}

